/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.util.Dictionary;
import java.util.Hashtable;
import oracle.bali.ewt.worker.AbstractWorkerQueue;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;

public final class WorkerUtils {
    public static final Object PARAMETER_NULL = new Object();
    private static final int _QUEUE_ALWAYS = 0;
    private static final int _QUEUE_IF_NECESSARY = 1;
    private static final int _QUEUE_NEVER = 2;
    private static boolean _sQueueLocationsSaved = false;

    public static Throwable getFailureCause(InvocationContext context) {
        return (Throwable)context.getValue(InvocationContext.FAILURE_CAUSE, null);
    }

    public static Object getMainResult(InvocationContext context) {
        return WorkerUtils.getMainResult(context, InvocationContext.UNDEFINED);
    }

    public static Object getMainResult(InvocationContext context, Object defaultValue) {
        return context.getValue(InvocationContext.RESULT, defaultValue);
    }

    public static Boolean isCanceled(InvocationContext context) {
        return (Boolean)context.getValue(InvocationContext.CANCELED, null);
    }

    public static InvocationContext getParentContext(InvocationContext context) {
        return (InvocationContext)context.getValue(InvocationContext.PARENT_CONTEXT, null);
    }

    public static Object getDefaultParameter(InvocationContext context) {
        return WorkerUtils.getDefaultParameter(context, InvocationContext.UNDEFINED);
    }

    public static Object getDefaultParameter(InvocationContext context, Object defaultValue) {
        return context.getValue(InvocationContext.PARAMETER_VALUE, defaultValue);
    }

    public static void setQueueLocationsSaved(boolean queueLocationsSaved) {
        _sQueueLocationsSaved = queueLocationsSaved;
    }

    public static boolean getQueueLocationsSaved() {
        return _sQueueLocationsSaved;
    }

    public static InvocationContext queueWorker(Worker queuableWorker) {
        return WorkerUtils.queueWorker(queuableWorker, null);
    }

    public static InvocationContext queueWorker(Worker queuableWorker, WorkerStatusListener statusListener) {
        return WorkerUtils.queueWorker(queuableWorker, InvocationContext.UNDEFINED, statusListener);
    }

    public static InvocationContext queueWorker(Worker queuableWorker, Object parameterValue, WorkerStatusListener statusListener) {
        return WorkerUtils.queueWorker(queuableWorker, InvocationContext.PARAMETER_VALUE, parameterValue, statusListener);
    }

    public static InvocationContext queueWorker(Worker queuableWorker, Object parameterKey, Object parameterValue, WorkerStatusListener statusListener) {
        return WorkerUtils.queueWorker(queuableWorker, WorkerUtils.createParameters(parameterKey, parameterValue), statusListener);
    }

    public static InvocationContext queueWorker(Worker queuableWorker, Dictionary parameters, WorkerStatusListener statusListener) {
        try {
            return WorkerUtils._runWorker(queuableWorker, parameters, 0, statusListener);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static InvocationContext runOrQueueWorker(Worker runnableWorker) {
        return WorkerUtils.runOrQueueWorker(runnableWorker, null);
    }

    public static InvocationContext runOrQueueWorker(Worker runnableWorker, WorkerStatusListener statusListener) {
        return WorkerUtils.runOrQueueWorker(runnableWorker, InvocationContext.UNDEFINED, statusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker runnableWorker, Object parameterValue, WorkerStatusListener statusListener) {
        return WorkerUtils.runOrQueueWorker(runnableWorker, InvocationContext.PARAMETER_VALUE, parameterValue, statusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker runnableWorker, Object parameterKey, Object parameterValue, WorkerStatusListener statusListener) {
        return WorkerUtils.runOrQueueWorker(runnableWorker, WorkerUtils.createParameters(parameterKey, parameterValue), statusListener);
    }

    public static InvocationContext runOrQueueWorker(Worker runnableWorker, Dictionary parameters, WorkerStatusListener statusListener) {
        try {
            return WorkerUtils._runWorker(runnableWorker, parameters, 1, statusListener);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static Object runWorkerAndWait(Worker runnableWorker) throws Throwable {
        return WorkerUtils.runWorkerAndWait(runnableWorker, InvocationContext.UNDEFINED);
    }

    public static Object runWorkerAndWait(Worker runnableWorker, Object parameterValue) throws Throwable {
        return WorkerUtils.runWorkerAndWait(runnableWorker, InvocationContext.PARAMETER_VALUE, parameterValue);
    }

    public static Object runWorkerAndWait(Worker runnableWorker, Object parameterKey, Object parameterValue) throws Throwable {
        return WorkerUtils.runWorkerAndWait(runnableWorker, WorkerUtils.createParameters(parameterKey, parameterValue));
    }

    public static Object runWorkerAndWait(Worker runnableWorker, Dictionary parameters) throws Throwable {
        InvocationContext invokeContext = WorkerUtils._runWorker(runnableWorker, parameters, 2, null);
        Object result = invokeContext.getValue(InvocationContext.RESULT, InvocationContext.UNDEFINED);
        if (result == InvocationContext.UNDEFINED) {
            throw WorkerUtils.getFailureCause(invokeContext);
        }
        return result;
    }

    public static Dictionary createMinimalParameterDictionary() {
        return new Hashtable(7);
    }

    public static void putNullableValue(Dictionary map, Object key, Object value) {
        if (value == null) {
            value = PARAMETER_NULL;
        }
        map.put(key, value);
    }

    public static Dictionary createParameters(Object parameterKey, Object parameterValue) {
        Dictionary params = WorkerUtils.createMinimalParameterDictionary();
        if (parameterValue != InvocationContext.UNDEFINED) {
            WorkerUtils.putNullableValue(params, parameterKey, parameterValue);
        }
        return params;
    }

    private static InvocationContext _runWorker(Worker runnableWorker, Dictionary parameters, int queueMode, WorkerStatusListener statusListener) throws Throwable {
        WorkerQueue queue = runnableWorker.getWorkerQueue();
        InvocationContext invokingContext = null;
        if (parameters == null) {
            parameters = WorkerUtils.createMinimalParameterDictionary();
        }
        if (queueMode != 0 && (queue == null || queue.isInWorkerQueueThread())) {
            invokingContext = AbstractWorkerQueue.__runWorkerImmediately(runnableWorker, parameters, statusListener);
        } else {
            if (queue == null) {
                throw new IllegalArgumentException("Attempt to queue worker with no queue");
            }
            invokingContext = queueMode == 2 ? queue.invokeAndWait(runnableWorker, parameters, statusListener) : queue.invokeLater(runnableWorker, parameters, statusListener);
        }
        return invokingContext;
    }

    private WorkerUtils() {
    }
}

