/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.RegisteredByExtension;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.style.controller.CodingStyleController;

@RegisteredByExtension(value="oracle.jdeveloper.style")
final class CodeFormatHook
extends HashStructureHook {
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "code-format");

    CodeFormatHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                CodeFormatHook.this.addProviders(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                CodeFormatHook.this.addProviders(e.getNewElementHashStructure());
            }
        });
    }

    public static CodeFormatHook get() {
        return (CodeFormatHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    private void addProviders(HashStructure hs) {
        if (hs == null) {
            return;
        }
        List newDelegateRefs = hs.getAsList("format-delegate");
        if (newDelegateRefs == null) {
            return;
        }
        for (Object o : newDelegateRefs) {
            HashStructure hsProvider = (HashStructure)o;
            HashStructure classHash = hsProvider.getHashStructure("delegate-class");
            MetaClass delegateMetaClass = LazyClassAdapter.getInstance((HashStructure)classHash).getMetaClass("#text");
            HashStructure nodeHash = hsProvider.getHashStructure("node-class");
            MetaClass nodeMetaClass = LazyClassAdapter.getInstance((HashStructure)nodeHash).getMetaClass("#text");
            try {
                Class nodeClass = nodeMetaClass.toClass();
                Class delegateClass = delegateMetaClass.toClass();
                CodingStyleController.registerFormatDelegate(nodeClass, delegateClass);
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger("global").log(Level.SEVERE, "Code Format Hook, cannot create declared class");
            }
        }
    }
}

