/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.patch.res.Bundle;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.patch.PatchException;
import oracle.jdeveloper.patch.PatchExceptionHandler;

public abstract class CreatePatchDialogVetoer
implements VetoableChangeListener {
    private final Component _parent;

    public CreatePatchDialogVetoer(Component parent) {
        this._parent = parent;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
            return;
        }
        try {
            this.validateCustomOptions();
        }
        catch (PatchException vcse) {
            this.validationFailed(vcse.getMessage(), e);
        }
        if (!this.isFileTargetSelected()) {
            return;
        }
        URL url = this.getFileTargetURL();
        if (URLFileSystem.isDirectory((URL)url)) {
            this.validationFailed(Bundle.get("ERROR_GENERATE_PATCH_IS_DIR"), e);
        }
        if (!URLFileSystem.exists((URL)url)) {
            URL parentUrl = URLFileSystem.getParent((URL)url);
            if (!URLFileSystem.exists((URL)parentUrl) && !URLFileSystem.mkdirs((URL)parentUrl)) {
                this.validationFailed(Bundle.get("ERROR_GENERATE_PATCH_MKDIRS_FAILED"), e);
            }
            if (!URLFileSystem.canCreate((URL)url)) {
                this.validationFailed(Bundle.get("ERROR_GENERATE_PATCH_FILE_FAILED"), e);
            }
            return;
        }
        if (MessageDialog.confirm((Component)this._parent, (Object)Bundle.format("CONFIRM_GENERATE_PATCH_OVERWRITE", URLFileSystem.getPlatformPathName((URL)url)), (String)Bundle.get("CONFIRM_GENERATE_PATCH_OVERWRITE_TITLE"), null)) {
            return;
        }
        this.throwPropertyVetoException(e);
    }

    protected abstract boolean isFileTargetSelected();

    protected abstract URL getFileTargetURL();

    protected void validateCustomOptions() throws PatchException {
    }

    protected void handleException(String message) {
        new PatchExceptionHandler().handleException(new ValidationException(message));
    }

    private void validationFailed(String message, PropertyChangeEvent e) throws PropertyVetoException {
        this.handleException(message);
        this.throwPropertyVetoException(e);
    }

    private void throwPropertyVetoException(PropertyChangeEvent e) throws PropertyVetoException {
        throw new PropertyVetoException("", e);
    }

    private class ValidationException
    extends PatchException {
        ValidationException(String message) {
            super(Bundle.get("VALIDATION_ERROR_TITLE"), message);
        }
    }
}

