/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.DefaultTopicPanel;
import oracle.help.WindowManager;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.AboutBox;
import oracle.help.java.util.ImageLoader;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.NavigatorTabPanel;
import oracle.help.navigator.NavigatorToolBar;
import oracle.help.navigator.SimpleNavigatorPanel;
import oracle.help.navigator.tocNavigator.TOCNavigator;

public class DefaultNavigatorPanel
extends JPanel
implements ActionListener,
NavigatorListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
    private static String NAVIGATOR_WINDOW_TITLE = "defaultNavigatorWindow.title";
    private static String VIEW_SELECT = "VIEW_SELECT";
    private NavigatorWindowMenuBar _menuBar;
    private SimpleNavigatorPanel _navPanel;
    private JSplitPane _splitter;
    private int _preferredDividerSize;
    private JFrame _navFrame;
    private JDialog _navDialog;
    private String _defaultTitle;
    private boolean _inDialogState;
    private boolean _hasDockedTopicPanel;
    private DefaultTopicPanel _dockedPanel;
    private WindowManager _manager;
    private FrameNavigatorPanelHider _frameListener = null;
    private DialogNavigatorPanelHider _dialogListener = null;
    private Rectangle _navigatorWindowBounds = null;
    private NavigatorToolBar _toolBar;
    private JButton _displayButton;
    private JButton _displayNewButton;
    private ListenerManager _listeners;
    private TabPanelChoiceModel _tabPanelModel;
    private TabPanelChoiceListener _choiceListener;
    private NavigatorTabPanel _activeTabPanel;
    private JComboBox _tabPanelChoice;
    private boolean _choiceAdded;
    private Component _choiceSeparator;
    private JMenu _fileMenu;
    private JPopupMenu _fileSubMenu;
    private JMenuItem _displayItem;
    private JMenuItem _displayNewItem;
    private JMenuItem _printTopicItem;
    private JMenuItem _printMultipleTopicsItem;
    private JMenuItem _printTreeItem;
    private JMenuItem _closeItem;
    private JMenuItem _exitItem;
    private JMenu _viewMenu;
    private JPopupMenu _viewSubMenu;
    private ButtonGroup _viewTabGroup;
    private JMenu _toolsMenu;
    private JPopupMenu _toolsSubMenu;
    private JMenu _fontSizeMenu;
    private JMenuItem _undockItem;
    private JMenuItem _copyItem;
    private JMenuItem _selectAllItem;
    private JMenuItem _increaseItem;
    private JMenuItem _decreaseItem;
    private JMenuItem _findItem;
    private JMenuItem _addFavoriteItem;
    private JMenuItem _optionsItem;
    private JMenu _helpMenu;
    private JMenuItem _helpOnHelpItem;
    private JMenuItem _aboutItem;
    private JMenu _sharedGoMenu;
    private Topic _helpOnHelpTopic;

    public DefaultNavigatorPanel() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this._defaultTitle = bundle.getString(NAVIGATOR_WINDOW_TITLE);
        this._listeners = new ListenerManager();
        this.setLayout(new BorderLayout());
        Color background = UIManager.getColor("darkLook");
        if (background != null) {
            this.setBackground(background);
        }
        this._helpOnHelpTopic = null;
        this._menuBar = new NavigatorWindowMenuBar();
        this._toolBar = new NavigatorToolBar();
        this.addNavigatorWindowListener(this._toolBar);
        Insets buttonInsets = new Insets(2, 2, 2, 2);
        this._tabPanelModel = new TabPanelChoiceModel();
        this._tabPanelChoice = new MinimumSizedComboBox(this._tabPanelModel);
        this._tabPanelChoice.setEditable(false);
        this._choiceListener = new TabPanelChoiceListener();
        this._tabPanelChoice.addItemListener(this._choiceListener);
        this._choiceAdded = false;
        ImageIcon displayImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/display.gif"));
        this._displayButton = new JButton(displayImage);
        this._displayButton.setMargin(buttonInsets);
        this._toolBar.addItem(this._displayButton, null, true);
        this._displayButton.addActionListener(this);
        ImageIcon displayNewImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/diswin.gif"));
        this._displayNewButton = new JButton(displayNewImage);
        this._displayNewButton.setMargin(buttonInsets);
        this._toolBar.addItem(this._displayNewButton, null, true);
        this._displayNewButton.addActionListener(this);
        this._choiceSeparator = new JToolBar.Separator();
        String displayHelpText = MenuUtils.getDefaultMenuLabel("toolbar.Display.tooltip");
        this._displayButton.setToolTipText(displayHelpText);
        String displayNewHelpText = MenuUtils.getDefaultMenuLabel("toolbar.Display_New.tooltip");
        this._displayNewButton.setToolTipText(displayNewHelpText);
        this._navFrame = null;
        this._navDialog = null;
        this._setDialogState(false);
        this._frameListener = new FrameNavigatorPanelHider();
        this._dialogListener = new DialogNavigatorPanelHider();
        this._navPanel = new SimpleNavigatorPanel(null, this._menuBar, this._toolBar);
        this._hasDockedTopicPanel = false;
        this._dockedPanel = null;
        this._manager = null;
        this._splitter = new JSplitPane(1);
        this._splitter.setLeftComponent(this._navPanel);
        this._preferredDividerSize = this._splitter.getDividerSize();
        this._splitter.setDividerSize(0);
        this.add((Component)this._splitter, "Center");
    }

    public JFrame createNavigatorFrame() {
        if (this._navDialog != null) {
            this.disposeNavigatorDialog();
        }
        if (this._navFrame == null) {
            this._navFrame = new JFrame();
            WindowUtils.registerWindow((Window)this._navFrame);
            if (ImageLoader.getIconImage() != null) {
                this._navFrame.setIconImage(ImageLoader.getIconImage());
            }
            this._navFrame.getContentPane().setLayout(new BorderLayout());
            this._navFrame.getContentPane().add((Component)this, "Center");
            this._navFrame.addWindowListener(this._frameListener);
            this._navFrame.setTitle(this._defaultTitle);
            if (this._navigatorWindowBounds == null) {
                ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                int width = Integer.parseInt(defaults.getString("navigator.width"));
                int height = Integer.parseInt(defaults.getString("navigator.height"));
                this._navFrame.setSize(width, height);
                int topicWidth = Integer.parseInt(defaults.getString("topicwin.width"));
                int topicHeight = Integer.parseInt(defaults.getString("topicwin.height"));
                Toolkit toolkit = this._navFrame.getToolkit();
                Dimension screensize = toolkit.getScreenSize();
                int x = (screensize.width - (width + 20 + topicWidth)) / 2;
                if (x < 0) {
                    x = 20;
                }
                WindowUtils.centerWindow((Window)this._navFrame);
                this._navFrame.setLocation(x, this._navFrame.getLocation().y);
            } else {
                this._navFrame.setBounds(this._navigatorWindowBounds);
            }
        }
        return this._navFrame;
    }

    public JDialog createNavigatorDialog(Dialog owner) {
        if (this._navFrame != null) {
            this.disposeNavigatorFrame();
        }
        if (this._navDialog != null && this._navDialog.getParent() != owner) {
            this.disposeNavigatorDialog();
        }
        if (this._navDialog == null) {
            this._navDialog = new JDialog(owner);
            WindowUtils.registerWindow((Window)this._navDialog);
            this._navDialog.getContentPane().setLayout(new BorderLayout());
            this._navDialog.getContentPane().add((Component)this, "Center");
            this._navDialog.addComponentListener(this._dialogListener);
            this._navDialog.setTitle(this._defaultTitle);
            if (this._navigatorWindowBounds == null) {
                ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                int width = Integer.parseInt(defaults.getString("navigator.width"));
                int height = Integer.parseInt(defaults.getString("navigator.height"));
                this._navDialog.setSize(width, height);
                int topicWidth = Integer.parseInt(defaults.getString("topicwin.width"));
                int topicHeight = Integer.parseInt(defaults.getString("topicwin.height"));
                Toolkit toolkit = this._navDialog.getToolkit();
                Dimension screensize = toolkit.getScreenSize();
                int x = (screensize.width - (width + 20 + topicWidth)) / 2;
                if (x < 0) {
                    x = 20;
                }
                WindowUtils.centerWindow((Window)this._navDialog);
                this._navDialog.setLocation(x, this._navDialog.getLocation().y);
            } else {
                this._navDialog.setBounds(this._navigatorWindowBounds);
            }
        }
        return this._navDialog;
    }

    public Window getCurrentNavigatorWindow() {
        if (this._navFrame != null) {
            return this._navFrame;
        }
        if (this._navDialog != null) {
            return this._navDialog;
        }
        return null;
    }

    public void setWindowManager(WindowManager manager) {
        this._manager = manager;
    }

    public WindowManager getWindowManager() {
        return this._manager;
    }

    public void addNavigatorTabPanel(NavigatorTabPanel aPanel, String title) {
        if (aPanel != null) {
            this._tabPanelModel.addNavigatorTabPanel(aPanel, title);
            aPanel.addActiveNavigatorListener(this);
        }
        if (this._tabPanelModel.getSize() > 1) {
            if (!this._choiceAdded) {
                this._toolBar.addItem(this._tabPanelChoice, this._displayButton);
                this._toolBar.addItem(this._choiceSeparator, this._displayButton);
                this._choiceAdded = true;
            }
        } else if (this._tabPanelModel.getSize() == 1) {
            this._tabPanelChoice.setSelectedIndex(0);
        }
    }

    public void removeNavigatorTabPanel(NavigatorTabPanel aPanel) {
        if (aPanel != null) {
            this._tabPanelModel.removeNavigatorTabPanel(aPanel);
            aPanel.removeActiveNavigatorListener(this);
        }
        if (this._tabPanelModel.getSize() <= 1 && this._choiceAdded) {
            this._toolBar.removeItem(this._tabPanelChoice);
            this._toolBar.removeItem(this._choiceSeparator);
            this._choiceAdded = false;
        }
        if (aPanel == this.getActiveNavigatorTabPanel()) {
            this._tabPanelChoice.setSelectedIndex(0);
        }
    }

    public void addNavigatorWindowListener(NavigatorListener listener) {
        if (listener != null) {
            this._listeners.addListener((EventListener)listener);
        }
    }

    public void removeNavigatorWindowListener(NavigatorListener listener) {
        if (listener != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public NavigatorTabPanel getActiveNavigatorTabPanel() {
        return this._choiceListener.getActiveNavigatorTabPanel();
    }

    public NavigatorTabPanel[] getAllNavigatorTabPanels() {
        Object[] panelArr = null;
        Vector allPanels = this._tabPanelModel.getAllNavigatorTabPanels();
        if (allPanels != null) {
            panelArr = new NavigatorTabPanel[allPanels.size()];
            allPanels.copyInto(panelArr);
        }
        return panelArr;
    }

    public Navigator getActiveNavigator() {
        Navigator activeNav = null;
        NavigatorTabPanel activePanel = this.getActiveNavigatorTabPanel();
        if (activePanel != null) {
            activeNav = activePanel.getActiveNavigator();
        }
        return activeNav;
    }

    public void setActiveNavigator(Navigator nav) {
        if (nav != null) {
            Vector allPanels = this._tabPanelModel.getAllNavigatorTabPanels();
            for (int iter = 0; iter < allPanels.size(); ++iter) {
                Navigator[] navArr;
                NavigatorTabPanel aPanel = (NavigatorTabPanel)allPanels.elementAt(iter);
                if (aPanel == null || (navArr = aPanel.getNavigators()) == null) continue;
                for (int navCount = 0; navCount < navArr.length; ++navCount) {
                    Navigator currentNav = navArr[navCount];
                    if (nav != currentNav) continue;
                    this._tabPanelChoice.setSelectedIndex(iter);
                    aPanel.setSelectedComponent(currentNav);
                    return;
                }
            }
        }
    }

    public void setActiveNavigatorTabPanel(NavigatorTabPanel activePanel) {
        if (activePanel != null) {
            Vector allPanels = this._tabPanelModel.getAllNavigatorTabPanels();
            for (int iter = 0; iter < allPanels.size(); ++iter) {
                NavigatorTabPanel currentPanel = (NavigatorTabPanel)allPanels.elementAt(iter);
                if (currentPanel != activePanel) continue;
                this._tabPanelChoice.setSelectedIndex(iter);
                return;
            }
        }
        this._tabPanelChoice.setSelectedIndex(0);
    }

    public Navigator[] getAllNavigators() {
        Object[] navArr = null;
        Vector allNavs = this._tabPanelModel.getAllNavigators();
        if (allNavs != null) {
            navArr = new Navigator[allNavs.size()];
            allNavs.copyInto(navArr);
        }
        return navArr;
    }

    public void synchronizeNavigators(URL url) {
        Vector allNavs;
        if (url != null && (allNavs = this._tabPanelModel.getAllNavigators()) != null) {
            for (int iter = 0; iter < allNavs.size(); ++iter) {
                Navigator aNav = (Navigator)allNavs.elementAt(iter);
                if (!(aNav instanceof TOCNavigator)) continue;
                TOCNavigator tocNav = (TOCNavigator)aNav;
                tocNav.selectMatchingTopic(url);
            }
        }
    }

    public void setHelpOnHelpTopic(Topic aTopic) {
        this._helpOnHelpTopic = null;
        if (aTopic != null && aTopic.hasTarget()) {
            this._helpOnHelpTopic = aTopic;
        }
        if (this._helpOnHelpTopic == null) {
            this._menuBar.setHelpOnHelpVisible(false);
        } else {
            this._menuBar.setHelpOnHelpVisible(true);
        }
    }

    public void dockTopicPanel(DefaultTopicPanel panel) {
        Window currentNavWindow = this.getCurrentNavigatorWindow();
        if (panel != null && currentNavWindow != null) {
            if (this.hasDockedTopicPanel()) {
                this.undockTopicPanel();
            }
            Dimension navSize = currentNavWindow.getSize();
            Dimension navPanelSize = this._navPanel.getSize();
            Dimension panelSize = panel.getSize();
            try {
                ResourceBundle defaults = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                int defaultTopicWidth = Integer.parseInt(defaults.getString("topicwin.width"));
                int defaultTopicHeight = Integer.parseInt(defaults.getString("topicwin.height"));
                if (navPanelSize.width == 0) {
                    navPanelSize.width = navSize.width - 8;
                }
                if (navPanelSize.height == 0) {
                    navPanelSize.height = navSize.height - 27;
                }
                if (panelSize.width == 0) {
                    panelSize.width = defaultTopicWidth - 8;
                }
                if (panelSize.height == 0) {
                    panelSize.height = defaultTopicHeight - 27;
                }
            }
            catch (Exception defaults) {
                // empty catch block
            }
            this._splitter.setDividerSize(this._preferredDividerSize);
            this._splitter.setRightComponent(panel);
            this._dockedPanel = panel;
            this._hasDockedTopicPanel = true;
            int newWidth = navSize.width + this._preferredDividerSize + panelSize.width;
            int newHeight = panelSize.height + (navSize.height - navPanelSize.height);
            if (navSize.height > newHeight) {
                newHeight = navSize.height;
            }
            currentNavWindow.setSize(newWidth, newHeight);
            currentNavWindow.validate();
            this._splitter.setDividerLocation(navPanelSize.width + 1);
            this._menuBar.setDockedState(true);
        }
    }

    public DefaultTopicPanel undockTopicPanel() {
        DefaultTopicPanel oldPanel = this._dockedPanel;
        if (this.hasDockedTopicPanel()) {
            Dimension panelSize = this._dockedPanel.getSize();
            this._splitter.remove(this._dockedPanel);
            this._splitter.setDividerSize(0);
            Window currentNavWindow = this.getCurrentNavigatorWindow();
            if (currentNavWindow != null) {
                Dimension currentSize = currentNavWindow.getSize();
                currentNavWindow.setSize(currentSize.width - (panelSize.width + this._preferredDividerSize), currentSize.height);
                currentNavWindow.validate();
            }
            this._dockedPanel = null;
            this._hasDockedTopicPanel = false;
            this._menuBar.setDockedState(false);
        }
        return oldPanel;
    }

    public boolean hasDockedTopicPanel() {
        return this._hasDockedTopicPanel;
    }

    public void hideNavigatorWindow() {
        Window navigatorWindow = this.getCurrentNavigatorWindow();
        if (navigatorWindow != null && navigatorWindow.isVisible()) {
            navigatorWindow.setVisible(false);
        }
        if (this._manager != null) {
            this._manager.hideNavigatorWindow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Topic activatedTopic;
        Navigator nav;
        if (event != null && (nav = this.getActiveNavigator()) != null && (activatedTopic = nav.getCurrentSelection()) != null) {
            if (event.getSource() == this._displayButton) {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2001, activatedTopic, 1));
            } else if (event.getSource() == this._displayNewButton) {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2001, activatedTopic, 2));
            }
        }
    }

    @Override
    public void topicSelected(NavigatorEvent e) {
        if (e != null && (e.getSource() == this.getActiveNavigatorTabPanel() || e.getSource() == this.getActiveNavigator())) {
            this._fireNavigatorEvent(e);
        }
    }

    @Override
    public void topicActivated(NavigatorEvent e) {
        if (e != null && (e.getSource() == this.getActiveNavigatorTabPanel() || e.getSource() == this.getActiveNavigator())) {
            this._fireNavigatorEvent(e);
        }
    }

    public void dispose() {
        if (this._navFrame != null) {
            this.disposeNavigatorFrame();
        }
        if (this._navDialog != null) {
            this.disposeNavigatorDialog();
        }
        this.removeNavigatorWindowListener(this._toolBar);
        this._dialogListener = null;
        this._frameListener = null;
        this._tabPanelChoice.removeItemListener(this._choiceListener);
        this._tabPanelChoice.removeAll();
        this._tabPanelChoice = null;
        this._choiceListener = null;
        this._choiceSeparator = null;
        this._tabPanelModel = null;
        this._activeTabPanel = null;
        this._defaultTitle = null;
        this._listeners = null;
        this._menuBar.removeAll();
        this._menuBar = null;
        this._toolBar.removeAll();
        this._toolBar = null;
        this._navPanel.removeAll();
        this._navPanel = null;
        this._dockedPanel = null;
        this._splitter.removeAll();
        this._splitter = null;
        this._manager = null;
        this.removeAll();
    }

    public void disposeNavigatorFrame() {
        if (this._navFrame != null) {
            this._navFrame.removeWindowListener(this._frameListener);
            this._navFrame.setVisible(false);
            this._navigatorWindowBounds = this._navFrame.getBounds();
            this._navFrame.remove(this);
            WindowUtils.unregisterWindow((Window)this._navFrame);
            this._navFrame.dispose();
            this._navFrame = null;
        }
    }

    public void disposeNavigatorDialog() {
        if (this._navDialog != null) {
            this._navDialog.removeComponentListener(this._dialogListener);
            this._navDialog.setVisible(false);
            this._navigatorWindowBounds = this._navDialog.getBounds();
            this._navDialog.remove(this);
            WindowUtils.unregisterWindow((Window)this._navDialog);
            this._navDialog.dispose();
            this._navDialog = null;
        }
    }

    private void _setDialogState(boolean dialogMode) {
        this._inDialogState = dialogMode;
        if (this._inDialogState) {
            this._toolBar.enableItemBasedOnSelection(false, this._displayNewButton);
            this._displayNewButton.setEnabled(false);
        } else {
            this._toolBar.enableItemBasedOnSelection(true, this._displayNewButton);
        }
    }

    private void _fireNavigatorEvent(NavigatorEvent event) {
        Enumeration listenEnum = this._listeners.getListeners();
        if (listenEnum != null) {
            while (listenEnum.hasMoreElements()) {
                NavigatorListener l = (NavigatorListener)listenEnum.nextElement();
                if (event.getID() == 2000) {
                    l.topicSelected(event);
                    continue;
                }
                l.topicActivated(event);
            }
        }
    }

    private class FrameNavigatorPanelHider
    extends WindowAdapter {
        private FrameNavigatorPanelHider() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DefaultNavigatorPanel.this.hideNavigatorWindow();
        }
    }

    private class DialogNavigatorPanelHider
    extends ComponentAdapter {
        private DialogNavigatorPanelHider() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (e.getComponent() == DefaultNavigatorPanel.this.getCurrentNavigatorWindow()) {
                DefaultNavigatorPanel.this.hideNavigatorWindow();
            }
        }
    }

    private class NavigatorWindowMenuBar
    extends JMenuBar
    implements ActionListener,
    PopupMenuListener {
        public NavigatorWindowMenuBar() {
            this._initMenuBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorTabPanel activePanel = DefaultNavigatorPanel.this.getActiveNavigatorTabPanel();
            Navigator activeNav = DefaultNavigatorPanel.this.getActiveNavigator();
            Topic activeTopic = null;
            if (activeNav != null) {
                activeTopic = activeNav.getCurrentSelection();
            }
            if (e.getSource() == DefaultNavigatorPanel.this._displayItem) {
                if (activeTopic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, activeTopic, 1));
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._displayNewItem) {
                if (activeTopic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, activeTopic, 2));
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._printTopicItem) {
                if (DefaultNavigatorPanel.this._dockedPanel != null) {
                    DefaultNavigatorPanel.this._dockedPanel.printDisplayedTopic();
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._printTreeItem) {
                if (activeNav != null && activeNav instanceof TOCNavigator) {
                    TOCNavigator tocNav = (TOCNavigator)DefaultNavigatorPanel.this.getActiveNavigator();
                    tocNav.printNavigator();
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._printMultipleTopicsItem) {
                TOCNavigator tocNav;
                TopicTreeNode selectedNode;
                if (activeNav != null && activeNav instanceof TOCNavigator && (selectedNode = (tocNav = (TOCNavigator)DefaultNavigatorPanel.this.getActiveNavigator()).getCurrentSelectionNode()) != null && DefaultNavigatorPanel.this._manager != null) {
                    DefaultNavigatorPanel.this._manager.printTopics(selectedNode.getAllTopicsInSubTree());
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._closeItem) {
                DefaultNavigatorPanel.this.hideNavigatorWindow();
            } else if (e.getSource() == DefaultNavigatorPanel.this._exitItem) {
                if (DefaultNavigatorPanel.this._manager != null) {
                    DefaultNavigatorPanel.this._manager.hideAllWindows();
                } else {
                    DefaultNavigatorPanel.this.hideNavigatorWindow();
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._aboutItem) {
                AboutBox aboutBox = new AboutBox(WindowUtils.parentFrame((Component)this));
                aboutBox.setVisible(true);
            } else if (e.getSource() == DefaultNavigatorPanel.this._undockItem) {
                if (DefaultNavigatorPanel.this._dockedPanel != null) {
                    DefaultNavigatorPanel.this._dockedPanel.undockTopicPanel();
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._findItem) {
                DefaultNavigatorPanel.this._dockedPanel.runFindDialog();
            } else if (e.getSource() == DefaultNavigatorPanel.this._helpOnHelpItem) {
                if (DefaultNavigatorPanel.this._helpOnHelpTopic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, DefaultNavigatorPanel.this._helpOnHelpTopic, 2));
                }
            } else if (VIEW_SELECT.equals(e.getActionCommand())) {
                JMenuItem anItem = (JMenuItem)e.getSource();
                if (activePanel != null) {
                    for (int iter = 0; iter < activePanel.getTabCount(); ++iter) {
                        String tabTitle = activePanel.getTitleAt(iter);
                        if (tabTitle == null || !tabTitle.equals(anItem.getText())) continue;
                        activePanel.setSelectedIndex(iter);
                        break;
                    }
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._copyItem) {
                DefaultNavigatorPanel.this._dockedPanel.copySelectedText();
            } else if (e.getSource() == DefaultNavigatorPanel.this._increaseItem) {
                DefaultNavigatorPanel.this._dockedPanel.increaseFontSize();
            } else if (e.getSource() == DefaultNavigatorPanel.this._decreaseItem) {
                DefaultNavigatorPanel.this._dockedPanel.decreaseFontSize();
            } else if (e.getSource() == DefaultNavigatorPanel.this._selectAllItem) {
                DefaultNavigatorPanel.this._dockedPanel.selectAll();
            } else if (e.getSource() == DefaultNavigatorPanel.this._addFavoriteItem) {
                DefaultNavigatorPanel.this._dockedPanel.addFavoriteItem();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            NavigatorTabPanel activePanel = DefaultNavigatorPanel.this.getActiveNavigatorTabPanel();
            Navigator activeNav = DefaultNavigatorPanel.this.getActiveNavigator();
            boolean enableTreeItems = false;
            boolean enableTopicItems = false;
            boolean enableTargetItems = false;
            if (activeNav != null) {
                Topic currentSel;
                if (activeNav instanceof TOCNavigator) {
                    enableTreeItems = true;
                }
                if ((currentSel = activeNav.getCurrentSelection()) != null) {
                    enableTopicItems = true;
                    if (currentSel.hasTarget()) {
                        enableTargetItems = true;
                    }
                }
            }
            if (e.getSource() == DefaultNavigatorPanel.this._fileSubMenu) {
                DefaultNavigatorPanel.this._displayItem.setEnabled(enableTargetItems);
                DefaultNavigatorPanel.this._displayNewItem.setEnabled(enableTargetItems && !DefaultNavigatorPanel.this._inDialogState);
                DefaultNavigatorPanel.this._printTreeItem.setEnabled(enableTreeItems);
                DefaultNavigatorPanel.this._printMultipleTopicsItem.setEnabled(enableTreeItems && enableTopicItems);
            }
            if (e.getSource() == DefaultNavigatorPanel.this._viewSubMenu) {
                DefaultNavigatorPanel.this._viewTabGroup = new ButtonGroup();
                DefaultNavigatorPanel.this._viewMenu.removeAll();
                if (activePanel != null) {
                    for (int iter = 0; iter < activePanel.getTabCount(); ++iter) {
                        boolean isTabSelected;
                        String tabTitle = activePanel.getTitleAt(iter);
                        boolean bl = isTabSelected = activePanel.getSelectedIndex() == iter;
                        if (tabTitle == null) continue;
                        JRadioButtonMenuItem anItem = new JRadioButtonMenuItem(tabTitle, isTabSelected);
                        DefaultNavigatorPanel.this._viewTabGroup.add(anItem);
                        anItem.setActionCommand(VIEW_SELECT);
                        anItem.addActionListener(this);
                        DefaultNavigatorPanel.this._viewMenu.add(anItem);
                    }
                }
            } else if (e.getSource() == DefaultNavigatorPanel.this._toolsSubMenu) {
                String selectedText = DefaultNavigatorPanel.this._dockedPanel.getSelectedText();
                DefaultNavigatorPanel.this._copyItem.setEnabled(selectedText != null && !"".equals(selectedText));
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void setDockedState(boolean docked) {
            if (docked) {
                DefaultNavigatorPanel.this._sharedGoMenu = DefaultNavigatorPanel.this._dockedPanel._getGoMenu();
                this.remove(DefaultNavigatorPanel.this._helpMenu);
                this.add(DefaultNavigatorPanel.this._sharedGoMenu);
                DefaultNavigatorPanel.this._toolsMenu.removeAll();
                if (!DefaultNavigatorPanel.this._inDialogState) {
                    DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._undockItem);
                }
                DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._copyItem);
                DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._selectAllItem);
                DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._findItem);
                DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._fontSizeMenu);
                if (DefaultNavigatorPanel.this._manager.getFavoritesModel() != null) {
                    DefaultNavigatorPanel.this._toolsMenu.addSeparator();
                    DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._addFavoriteItem);
                }
                this.add(DefaultNavigatorPanel.this._toolsMenu);
                this.add(DefaultNavigatorPanel.this._helpMenu);
                int i = 0;
                for (i = 0; i < DefaultNavigatorPanel.this._fileMenu.getItemCount() && DefaultNavigatorPanel.this._fileMenu.getItem(i) != DefaultNavigatorPanel.this._printTreeItem; ++i) {
                }
                DefaultNavigatorPanel.this._fileMenu.insert(DefaultNavigatorPanel.this._printTopicItem, i + 1);
            } else {
                this.remove(DefaultNavigatorPanel.this._sharedGoMenu);
                this.remove(DefaultNavigatorPanel.this._toolsMenu);
                DefaultNavigatorPanel.this._fileMenu.remove(DefaultNavigatorPanel.this._printTopicItem);
            }
            this.validate();
        }

        public void setHelpOnHelpVisible(boolean visible) {
            if (visible) {
                if (DefaultNavigatorPanel.this._helpOnHelpItem.getParent() == null) {
                    DefaultNavigatorPanel.this._helpMenu.insert(DefaultNavigatorPanel.this._helpOnHelpItem, 0);
                }
            } else if (DefaultNavigatorPanel.this._helpOnHelpItem.getParent() == DefaultNavigatorPanel.this._helpMenu) {
                DefaultNavigatorPanel.this._helpMenu.remove(DefaultNavigatorPanel.this._helpOnHelpItem);
            }
        }

        private void _initMenuBar() {
            this.add(this._createFileMenu());
            this.add(this._createViewMenu());
            this.add(this._createHelpMenu());
            this._createToolsMenu();
            DefaultNavigatorPanel.this._sharedGoMenu = null;
        }

        private JMenu _createFileMenu() {
            DefaultNavigatorPanel.this._fileMenu = new JMenu();
            DefaultNavigatorPanel.this._fileSubMenu = DefaultNavigatorPanel.this._fileMenu.getPopupMenu();
            DefaultNavigatorPanel.this._fileSubMenu.addPopupMenuListener(this);
            MenuUtils.setMenuLabelAndAccelerator(DefaultNavigatorPanel.this._fileMenu, "menu.File", false);
            DefaultNavigatorPanel.this._displayItem = MenuUtils.createItem("menu.Display", false);
            DefaultNavigatorPanel.this._displayItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._displayItem);
            DefaultNavigatorPanel.this._displayNewItem = MenuUtils.createItem("menu.Display_New", false);
            DefaultNavigatorPanel.this._displayNewItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._displayNewItem);
            DefaultNavigatorPanel.this._fileMenu.addSeparator();
            DefaultNavigatorPanel.this._printTreeItem = MenuUtils.createItem("menu.PrintTree", false);
            DefaultNavigatorPanel.this._printTreeItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._printTreeItem);
            DefaultNavigatorPanel.this._printTopicItem = MenuUtils.createItem("menu.PrintTopic", false);
            DefaultNavigatorPanel.this._printTopicItem.addActionListener(this);
            DefaultNavigatorPanel.this._printMultipleTopicsItem = MenuUtils.createItem("menu.PrintTopics", false);
            DefaultNavigatorPanel.this._printMultipleTopicsItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._printMultipleTopicsItem);
            DefaultNavigatorPanel.this._fileMenu.addSeparator();
            DefaultNavigatorPanel.this._closeItem = MenuUtils.createItem("menu.Close", false);
            DefaultNavigatorPanel.this._closeItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._closeItem);
            DefaultNavigatorPanel.this._exitItem = MenuUtils.createItem("menu.Exit", false);
            DefaultNavigatorPanel.this._exitItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._exitItem);
            DefaultNavigatorPanel.this._fileMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._fileMenu;
        }

        private JMenu _createViewMenu() {
            DefaultNavigatorPanel.this._viewMenu = new JMenu();
            DefaultNavigatorPanel.this._viewSubMenu = DefaultNavigatorPanel.this._viewMenu.getPopupMenu();
            DefaultNavigatorPanel.this._viewSubMenu.addPopupMenuListener(this);
            MenuUtils.setMenuLabelAndAccelerator(DefaultNavigatorPanel.this._viewMenu, "menu.View", false);
            DefaultNavigatorPanel.this._viewMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._viewMenu;
        }

        private JMenu _createToolsMenu() {
            DefaultNavigatorPanel.this._toolsMenu = new JMenu();
            DefaultNavigatorPanel.this._toolsSubMenu = DefaultNavigatorPanel.this._toolsMenu.getPopupMenu();
            DefaultNavigatorPanel.this._toolsSubMenu.addPopupMenuListener(this);
            MenuUtils.setMenuLabelAndAccelerator(DefaultNavigatorPanel.this._toolsMenu, "menu.Tools", false);
            DefaultNavigatorPanel.this._undockItem = MenuUtils.createItem("menu.Undock", false);
            DefaultNavigatorPanel.this._undockItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._undockItem);
            ResourceBundle miscBundle = ResourceBundle.getBundle(DefaultNavigatorPanel.MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            String copyLabel = miscBundle.getString("edit.copy");
            DefaultNavigatorPanel.this._copyItem = MenuUtils.createItem(copyLabel, MenuUtils.getMiscBundleKeyStroke("edit.copy"), false);
            DefaultNavigatorPanel.this._copyItem.addActionListener(this);
            String selectAllLabel = miscBundle.getString("edit.selectAll");
            DefaultNavigatorPanel.this._selectAllItem = MenuUtils.createItem(selectAllLabel, MenuUtils.getMiscBundleKeyStroke("edit.selectAll"), false);
            DefaultNavigatorPanel.this._selectAllItem.addActionListener(this);
            DefaultNavigatorPanel.this._fontSizeMenu = new JMenu();
            String fontSizeMenuLabel = miscBundle.getString("edit.fontSize");
            MenuUtils.setMenuLabelAndAccelerator(DefaultNavigatorPanel.this._fontSizeMenu, fontSizeMenuLabel, null, false);
            String increaseLabel = miscBundle.getString("edit.increase");
            DefaultNavigatorPanel.this._increaseItem = MenuUtils.createItem(increaseLabel, MenuUtils.getMiscBundleKeyStroke("edit.increase"), false);
            DefaultNavigatorPanel.this._increaseItem.addActionListener(this);
            DefaultNavigatorPanel.this._fontSizeMenu.add(DefaultNavigatorPanel.this._increaseItem);
            String decreaseLabel = miscBundle.getString("edit.decrease");
            DefaultNavigatorPanel.this._decreaseItem = MenuUtils.createItem(decreaseLabel, MenuUtils.getMiscBundleKeyStroke("edit.decrease"), false);
            DefaultNavigatorPanel.this._decreaseItem.addActionListener(this);
            DefaultNavigatorPanel.this._fontSizeMenu.add(DefaultNavigatorPanel.this._decreaseItem);
            DefaultNavigatorPanel.this._findItem = MenuUtils.createItem("menu.Find", false);
            DefaultNavigatorPanel.this._findItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._findItem);
            DefaultNavigatorPanel.this._optionsItem = MenuUtils.createItem("menu.Preferences", false);
            DefaultNavigatorPanel.this._optionsItem.addActionListener(this);
            String addFavoriteLabel = miscBundle.getString("addfavoriteitem.addtofavoritesdot");
            DefaultNavigatorPanel.this._addFavoriteItem = MenuUtils.createItem(addFavoriteLabel, MenuUtils.getMiscBundleKeyStroke("addfavoriteitem.addtofavoritesdot"), false);
            DefaultNavigatorPanel.this._addFavoriteItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._toolsMenu;
        }

        private JMenu _createHelpMenu() {
            DefaultNavigatorPanel.this._helpMenu = new JMenu();
            MenuUtils.setMenuLabelAndAccelerator(DefaultNavigatorPanel.this._helpMenu, "menu.Help", false);
            DefaultNavigatorPanel.this._helpOnHelpItem = MenuUtils.createItem("menu.HelpOnHelp", false);
            DefaultNavigatorPanel.this._helpOnHelpItem.addActionListener(this);
            DefaultNavigatorPanel.this._aboutItem = MenuUtils.createItem("menu.About", false);
            DefaultNavigatorPanel.this._aboutItem.addActionListener(this);
            DefaultNavigatorPanel.this._helpMenu.add(DefaultNavigatorPanel.this._aboutItem);
            DefaultNavigatorPanel.this._helpMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._helpMenu;
        }
    }

    private class TabPanelChoiceListener
    implements ItemListener {
        private NavigatorTabPanel _activeTabPanel = null;

        TabPanelChoiceListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e != null && e.getStateChange() == 1) {
                int selIndex = DefaultNavigatorPanel.this._tabPanelChoice.getSelectedIndex();
                this._selectImpl(selIndex);
            }
        }

        public NavigatorTabPanel getActiveNavigatorTabPanel() {
            return this._activeTabPanel;
        }

        private void _selectImpl(int selIndex) {
            this._activeTabPanel = DefaultNavigatorPanel.this._tabPanelModel.getTabPanel(selIndex);
            DefaultNavigatorPanel.this._navPanel.setTabPanel(this._activeTabPanel);
            Navigator activeNav = null;
            if (this._activeTabPanel != null) {
                activeNav = this._activeTabPanel.getActiveNavigator();
            }
            if (activeNav != null) {
                DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(activeNav, 2000, activeNav.getCurrentSelection()));
            } else {
                DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2000, null));
            }
        }
    }

    private class TabPanelChoiceModel
    extends DefaultComboBoxModel {
        public NavigatorTabPanel getTabPanel(int index) {
            NavigatorTabPanel result = null;
            try {
                TabPanelInfo anInfo = (TabPanelInfo)this.getElementAt(index);
                if (anInfo != null) {
                    result = anInfo.tabPanel;
                }
            }
            catch (Exception e) {
                result = null;
            }
            return result;
        }

        public synchronized void addNavigatorTabPanel(NavigatorTabPanel tabPanel, String title) {
            TabPanelInfo anInfo = new TabPanelInfo(tabPanel, title);
            this.addElement(anInfo);
        }

        public synchronized void removeNavigatorTabPanel(NavigatorTabPanel tabPanel) {
            for (int iter = this.getSize() - 1; iter >= 0; --iter) {
                TabPanelInfo currentInfo = (TabPanelInfo)this.getElementAt(iter);
                if (currentInfo.tabPanel != tabPanel) continue;
                this.removeElement(currentInfo);
            }
        }

        public synchronized Vector getAllNavigatorTabPanels() {
            Vector<NavigatorTabPanel> allPanels = new Vector<NavigatorTabPanel>();
            for (int iter = 0; iter < this.getSize(); ++iter) {
                TabPanelInfo anInfo = (TabPanelInfo)this.getElementAt(iter);
                if (anInfo == null) continue;
                allPanels.addElement(anInfo.tabPanel);
            }
            return allPanels;
        }

        public synchronized Vector getAllNavigators() {
            Vector<Navigator> allNavs = new Vector<Navigator>();
            for (int iter = 0; iter < this.getSize(); ++iter) {
                Navigator[] someNavs;
                TabPanelInfo anInfo = (TabPanelInfo)this.getElementAt(iter);
                if (anInfo.tabPanel == null || (someNavs = anInfo.tabPanel.getNavigators()) == null) continue;
                for (int navCount = 0; navCount < someNavs.length; ++navCount) {
                    allNavs.addElement(someNavs[navCount]);
                }
            }
            return allNavs;
        }

        private class TabPanelInfo {
            public NavigatorTabPanel tabPanel = null;
            public String title = null;

            public TabPanelInfo(NavigatorTabPanel tabPanel, String title) {
                this.tabPanel = tabPanel;
                this.title = title;
            }

            public String toString() {
                return this.title;
            }
        }
    }

    private class MinimumSizedComboBox
    extends JComboBox {
        public MinimumSizedComboBox(ComboBoxModel model) {
            super(model);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

