/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;

public class MnemonicUtils {
    public static JLabel createLabel(String translatedText) {
        return MnemonicUtils.createLabel(translatedText, null);
    }

    public static JLabel createLabel(String translatedText, Component componentFor) {
        JLabel theLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        theLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        if (componentFor != null) {
            theLabel.setLabelFor(componentFor);
        }
        return theLabel;
    }

    public static JButton createButton(String translatedText) {
        JButton theButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
        theButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        return theButton;
    }

    public static JCheckBox createCheckBox(String translatedText) {
        JCheckBox theBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        theBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        return theBox;
    }

    public static JCheckBox createCheckBox(String translatedText, boolean state) {
        JCheckBox theBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText), state);
        theBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        return theBox;
    }

    public static JRadioButton createRadioButton(String translatedText) {
        JRadioButton theButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        theButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        return theButton;
    }

    public static JRadioButton createRadioButton(String translatedText, boolean state) {
        JRadioButton theButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText), state);
        theButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        return theButton;
    }
}

