/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import oracle.help.common.Topic;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class SimpleTopicDisplayPanel
extends JPanel
implements TopicDisplay {
    private JMenuBar _menuBar;
    private JToolBar _toolBar;
    private TopicDisplay _topicDisplay;
    private JPanel _topicContainer;

    public SimpleTopicDisplayPanel(TopicDisplay display, JMenuBar menuBar, JToolBar toolBar) {
        this._menuBar = menuBar;
        this._topicDisplay = display;
        this._toolBar = toolBar;
        if (this._topicDisplay == null) {
            throw new IllegalArgumentException("SimpleTopicDisplayPanel:  passed NULL TopicDisplay to constructor");
        }
        this._topicContainer = this._topicDisplay.getDisplayContainer();
        if (this._topicContainer == null) {
            throw new IllegalArgumentException("SimpleTopicDisplayPanel:  This TopicDisplay cannot be contained in a SimpleTopicDisplayPanel");
        }
        Color background = UIManager.getColor("darkLook");
        if (background != null) {
            this.setBackground(background);
        }
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout(1, 5));
        if (this._menuBar != null || this._toolBar != null) {
            JPanel north = new JPanel();
            north.setLayout(new BorderLayout(0, 0));
            if (this._menuBar != null) {
                north.add((Component)this._menuBar, "North");
            }
            if (this._toolBar != null) {
                this._toolBar.setFloatable(false);
                north.add((Component)this._toolBar, "Center");
            }
            this.add((Component)north, "North");
        }
        this.add((Component)this._topicContainer, "Center");
    }

    @Override
    public void displayTopic(Topic topic) throws TopicDisplayException {
        this._topicDisplay.displayTopic(topic);
    }

    @Override
    public TopicPrintJob getTopicPrintJob() {
        return this._topicDisplay.getTopicPrintJob();
    }

    @Override
    public JPanel getDisplayContainer() {
        return this;
    }

    @Override
    public URL getCurrentURL() {
        return this._topicDisplay.getCurrentURL();
    }

    @Override
    public void dispose() {
        this._topicDisplay.dispose();
        this._menuBar = null;
        this._toolBar = null;
        this._topicDisplay = null;
        this._topicContainer = null;
        this.removeAll();
    }

    @Override
    public void clear() {
        this._topicDisplay.clear();
    }

    @Override
    public void addDisplayListener(TopicDisplayListener listener) {
        this._topicDisplay.addDisplayListener(listener);
    }

    @Override
    public void removeDisplayListener(TopicDisplayListener listener) {
        this._topicDisplay.removeDisplayListener(listener);
    }

    @Override
    public void runFindDialog() {
        this._topicDisplay.runFindDialog();
    }

    @Override
    public boolean canGoBack() {
        return this._topicDisplay.canGoBack();
    }

    @Override
    public void goBack() {
        this._topicDisplay.goBack();
    }

    @Override
    public boolean canGoForward() {
        return this._topicDisplay.canGoForward();
    }

    @Override
    public void goForward() {
        this._topicDisplay.goForward();
    }

    @Override
    public String getSelectedText() {
        return this._topicDisplay.getSelectedText();
    }

    @Override
    public void increaseFontSize() {
        this._topicDisplay.increaseFontSize();
    }

    @Override
    public void decreaseFontSize() {
        this._topicDisplay.decreaseFontSize();
    }

    @Override
    public void selectAll() {
        this._topicDisplay.selectAll();
    }

    @Override
    public String getCurrentPageTitle() {
        return this._topicDisplay.getCurrentPageTitle();
    }
}

