/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JPanel;

public abstract class BaseMetadataProvider
extends Component
implements Disposable {
    private boolean connected;
    private ArrayList internalConnectionObjects = new ArrayList();
    protected ArrayList<BeforeConnectEventListener> beforeConnectEventListenerList = new ArrayList();
    protected ArrayList<AfterConnectEventListener> afterConnectEventListenerList = new ArrayList();
    protected ArrayList<BeforeDisconnectEventListener> beforeDisconnectEventListenerList = new ArrayList();
    protected ArrayList<AfterDisconnectEventListener> afterDisconnectEventListenerList = new ArrayList();
    protected ArrayList<DestroyedEventListener> destroyedEventListenerList = new ArrayList();

    @Override
    public void dispose() {
        this.fireDestroyedEvent(new DestroyedEvent(this));
    }

    public boolean canExecSQL() {
        return true;
    }

    public boolean isConnectionObjectsCreated() {
        return this.internalConnectionObjects.size() > 0;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean value) {
        if (value != this.isConnected()) {
            if (value) {
                this.connect();
            } else {
                this.disconnect();
            }
        }
    }

    public String getDescription() {
        return this.getClass().getName();
    }

    protected void doConnect() {
        this.connected = true;
    }

    protected void doDisconnect() {
        this.connected = false;
    }

    protected void checkConnectionSet() throws QueryBuilderException {
    }

    protected void addInternalConnectionObject(Object obj) {
        this.internalConnectionObjects.add(obj);
    }

    protected void clearInternalConnectionObjects() {
        this.internalConnectionObjects.clear();
    }

    public ResultSet prepareSQLDataset(String sql, boolean schemaOnly) throws QueryBuilderException {
        this.checkConnectionSet();
        if (!this.isConnected()) {
            this.connect();
        }
        return this.prepareSQLDatasetInternal(sql, schemaOnly);
    }

    protected ResultSet prepareSQLDatasetInternal(String sql, boolean schemaOnly) throws QueryBuilderException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execSQLInternal(String sql) throws QueryBuilderException {
        ResultSet resultSet = null;
        try {
            resultSet = this.prepareSQLDatasetInternal(sql, false);
            resultSet.next();
        }
        catch (SQLException ex) {
            try {
                throw new QueryBuilderException("ResultSet.next() thrown the exception:\n" + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                        resultSet = null;
                        throw throwable;
                    }
                    catch (Exception exception) {
                        resultSet = null;
                        throw throwable;
                    }
                }
                catch (Throwable throwable2) {
                    resultSet = null;
                    throw throwable2;
                }
            }
        }
        try {
            if (resultSet == null) return;
            resultSet.getStatement().close();
            resultSet.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            resultSet = null;
        }
    }

    public ResultSet execSQL(String sql, boolean schemaOnly) throws QueryBuilderException {
        this.checkConnectionSet();
        if (!this.isConnected()) {
            this.connect();
        }
        return this.prepareSQLDatasetInternal(sql, schemaOnly);
    }

    public void execSQLNoResult(String sql) throws QueryBuilderException {
        this.checkConnectionSet();
        if (!this.isConnected()) {
            this.connect();
        }
        this.execSQLInternal(sql);
    }

    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        databaseList.clear();
    }

    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (database != null && database.getCount() != 0) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strMetaProviderCantLoadMetadataForDatabase", "Used metadata provider cannot automatically load metadata for database: %1$s"), database.getQualifiedName()));
        }
        throw new QueryBuilderException(Helpers.localizer.getString("strMetaProviderCantLoadMetadata", "Used metadata provider cannot automatically load metadata"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFieldsForQuery(BaseSQLContext sqlContext, String query, MetadataFieldList fieldList) {
        block22: {
            fieldList.beginUpdate();
            try {
                fieldList.clear();
                if (!this.canExecSQL() || Str.IsNullOrEmpty(query)) break block22;
                try {
                    ResultSet resultSet = this.prepareSQLDataset(query, true);
                    try {
                        ResultSetMetaData meta = resultSet.getMetaData();
                        fieldList.beginUpdate();
                        try {
                            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                                fieldList.addField(meta, i);
                            }
                            fieldList.setLoaded(true);
                        }
                        finally {
                            fieldList.endUpdate();
                        }
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            resultSet = null;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                fieldList.endUpdate();
            }
        }
    }

    public boolean canCreateInternalConnection() {
        return false;
    }

    public void createAndBindInternalConnectionObj() {
        this.clearInternalConnectionObjects();
    }

    public JPanel createConnectionEditFrame(Component owner) {
        return null;
    }

    public void connect() {
        if (!this.isConnected()) {
            this.fireBeforeConnectEvent(new BeforeConnectEvent(this));
            this.doConnect();
            this.fireAfterConnectEvent(new AfterConnectEvent(this));
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.fireBeforeDisconnectEvent(new BeforeDisconnectEvent(this));
            this.doDisconnect();
            this.fireBeforeDisconnectEvent(new BeforeDisconnectEvent(this));
        }
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) {
        return null;
    }

    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        defaultSchemaNames.clear();
    }

    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
    }

    private void copyPropsFromFieldDefToMetadataField(ResultSetMetaData metaData, int index, MetadataField metadataField) throws SQLException, QueryBuilderException {
        metadataField.setNameStr(metadataField.getSQLContext().getSyntaxProvider().getQuoteBegin() + metaData.getColumnName(index) + metadataField.getSQLContext().getSyntaxProvider().getQuoteEnd());
        metadataField.setFieldType(metaData.getColumnType(index));
        metadataField.setSize(metaData.getColumnDisplaySize(index));
        if (metadataField.getPrecision() == 0) {
            metadataField.setPrecision(metaData.getPrecision(index));
        }
        if (metadataField.getScale() == 0) {
            metadataField.setScale(metaData.getScale(index));
        }
        if (!metadataField.isNullable()) {
            metadataField.setNullable(metaData.isNullable(index) == 1);
        }
        if (!metadataField.isReadOnly()) {
            metadataField.setReadOnly(metaData.isReadOnly(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFieldsForObjectFromDriver(BaseSQLContext sqlContext, MetadataObject metadataObject) {
        MetadataField f;
        boolean loadFieldsSeparately;
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        assert (metadataObject.getFields().isUpdating());
        ResultSet resultSet = null;
        String query = metadataObject.getQueryToLoadFields("");
        if (!Str.IsNullOrEmpty(query)) {
            loadFieldsSeparately = false;
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL(query, true);
                ResultSetMetaData meta = resultSet.getMetaData();
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    String name = sqlContext.getSyntaxProvider().getQuoteBegin() + meta.getColumnName(i) + sqlContext.getSyntaxProvider().getQuoteEnd();
                    int x = metadataObject.getFields().findFieldByName(name);
                    if (x != -1) {
                        f = metadataObject.getFields().get(x);
                        this.copyPropsFromFieldDefToMetadataField(meta, i, f);
                        continue;
                    }
                    f = metadataObject.getFields().add();
                    this.copyPropsFromFieldDefToMetadataField(meta, i, f);
                }
                metadataObject.getFields().setLoaded(true);
            }
            catch (Exception ex) {
                loadFieldsSeparately = true;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    resultSet = null;
                }
            }
        } else {
            loadFieldsSeparately = true;
        }
        if (loadFieldsSeparately && metadataObject.getFields().isLoaded() && metadataObject.getFields().getCount() > 0) {
            for (int i = 0; i < metadataObject.getFields().getCount(); ++i) {
                f = metadataObject.getFields().get(i);
                query = metadataObject.getQueryToLoadFields(f.getName().getQualifiedNameForServer());
                if (Str.IsNullOrEmpty(query)) continue;
                try {
                    resultSet = sqlContext.getMetadataProvider().execSQL(query, true);
                    ResultSetMetaData meta = resultSet.getMetaData();
                    if (meta.getColumnCount() > 0) {
                        this.copyPropsFromFieldDefToMetadataField(meta, 1, f);
                    }
                    metadataObject.getFields().setLoaded(true);
                    continue;
                }
                catch (Exception exception) {
                    try {
                        if (resultSet == null) continue;
                        resultSet.getStatement().close();
                        resultSet.close();
                        continue;
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                    finally {
                        resultSet = null;
                    }
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        resultSet = null;
                    }
                }
            }
        }
    }

    public void loadFieldsForTableFromDriver(BaseSQLContext sqlContext, MetadataTable metadataTable) {
        assert (sqlContext != null);
        assert (metadataTable != null);
        this.loadFieldsForObjectFromDriver(sqlContext, metadataTable);
    }

    public void loadFieldsForViewFromDriver(BaseSQLContext sqlContext, MetadataView metadataView) {
        assert (sqlContext != null);
        assert (metadataView != null);
        this.loadFieldsForObjectFromDriver(sqlContext, metadataView);
    }

    public void loadFieldsForProcedureFromDriver(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) {
        assert (sqlContext != null);
        assert (metadataProcedure != null);
        this.loadFieldsForObjectFromDriver(sqlContext, metadataProcedure);
    }

    public void loadFieldsForSynonymFromDriver(BaseSQLContext sqlContext, MetadataSynonym metadataSynonym) {
        assert (sqlContext != null);
        assert (metadataSynonym != null);
        this.loadFieldsForObjectFromDriver(sqlContext, metadataSynonym);
    }

    public void loadParamsForProcedureFromDriver(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) {
    }

    public void loadMetadataForTable(BaseSQLContext sqlContext, MetadataTable metadataTable) {
        assert (sqlContext != null);
        assert (metadataTable != null);
        if (this.canExecSQL()) {
            this.loadFieldsForTableFromDriver(sqlContext, metadataTable);
        }
    }

    public void loadMetadataForView(BaseSQLContext sqlContext, MetadataView metadataView) {
        assert (sqlContext != null);
        assert (metadataView != null);
        if (this.canExecSQL()) {
            this.loadFieldsForViewFromDriver(sqlContext, metadataView);
        }
    }

    public void loadMetadataForProcedure(BaseSQLContext sqlContext, MetadataProcedure metadataProcedure) {
        assert (sqlContext != null);
        assert (metadataProcedure != null);
        if (this.canExecSQL()) {
            metadataProcedure.beginUpdate();
            try {
                this.loadParamsForProcedureFromDriver(sqlContext, metadataProcedure);
                this.loadFieldsForProcedureFromDriver(sqlContext, metadataProcedure);
            }
            finally {
                metadataProcedure.endUpdate();
            }
        }
    }

    public void loadMetadataForSynonym(BaseSQLContext sqlContext, MetadataSynonym metadataSynonym) {
        assert (sqlContext != null);
        assert (metadataSynonym != null);
        if (this.canExecSQL()) {
            this.loadFieldsForSynonymFromDriver(sqlContext, metadataSynonym);
        }
    }

    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        schemaList.clear();
    }

    public void addBeforeConnectEventListener(BeforeConnectEventListener listener) {
        this.beforeConnectEventListenerList.add(listener);
    }

    public void removeBeforeConnectEventListener(BeforeConnectEventListener listener) {
        this.beforeConnectEventListenerList.remove(listener);
    }

    protected void fireBeforeConnectEvent(BeforeConnectEvent evt) {
        Iterator<BeforeConnectEventListener> listeners = this.beforeConnectEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().beforeConnectEventOccurred(evt);
        }
    }

    public void addAfterConnectEventListener(AfterConnectEventListener listener) {
        this.afterConnectEventListenerList.add(listener);
    }

    public void removeAfterConnectEventListener(AfterConnectEventListener listener) {
        this.afterConnectEventListenerList.remove(listener);
    }

    protected void fireAfterConnectEvent(AfterConnectEvent evt) {
        Iterator<AfterConnectEventListener> listeners = this.afterConnectEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().afterConnectEventOccurred(evt);
        }
    }

    public void addBeforeDisconnectEventListener(BeforeDisconnectEventListener listener) {
        this.beforeDisconnectEventListenerList.add(listener);
    }

    public void removeBeforeDisconnectEventListener(BeforeDisconnectEventListener listener) {
        this.beforeDisconnectEventListenerList.remove(listener);
    }

    protected void fireBeforeDisconnectEvent(BeforeDisconnectEvent evt) {
        Iterator<BeforeDisconnectEventListener> listeners = this.beforeDisconnectEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().beforeDisconnectEventOccurred(evt);
        }
    }

    public void addAfterDisconnectEventListener(AfterDisconnectEventListener listener) {
        this.afterDisconnectEventListenerList.add(listener);
    }

    public void removeAfterDisconnectEventListener(AfterDisconnectEventListener listener) {
        this.afterDisconnectEventListenerList.remove(listener);
    }

    protected void fireAfterDisconnectEvent(AfterDisconnectEvent evt) {
        Iterator<AfterDisconnectEventListener> listeners = this.afterDisconnectEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().afterDisconnectEventOccurred(evt);
        }
    }

    public void addDestroyedEventListener(DestroyedEventListener listener) {
        this.destroyedEventListenerList.add(listener);
    }

    public void removeDestroyedEventListener(DestroyedEventListener listener) {
        this.destroyedEventListenerList.remove(listener);
    }

    protected void fireDestroyedEvent(DestroyedEvent evt) {
        Iterator<DestroyedEventListener> listeners = this.destroyedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().destroyedEventOccurred(evt);
        }
    }

    public Connection getConnection() {
        throw new RuntimeException("getConnection() is not applicable for this class.");
    }

    public void setConnection(Connection connection) {
        throw new RuntimeException("setConnection() is not applicable for this class.");
    }

    public static interface DestroyedEventListener
    extends EventListener {
        public void destroyedEventOccurred(DestroyedEvent var1);
    }

    public class DestroyedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public DestroyedEvent(Object source) {
            super(source);
        }
    }

    public static interface AfterDisconnectEventListener
    extends EventListener {
        public void afterDisconnectEventOccurred(AfterDisconnectEvent var1);
    }

    public class AfterDisconnectEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public AfterDisconnectEvent(Object source) {
            super(source);
        }
    }

    public static interface BeforeDisconnectEventListener
    extends EventListener {
        public void beforeDisconnectEventOccurred(BeforeDisconnectEvent var1);
    }

    public class BeforeDisconnectEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public BeforeDisconnectEvent(Object source) {
            super(source);
        }
    }

    public static interface AfterConnectEventListener
    extends EventListener {
        public void afterConnectEventOccurred(AfterConnectEvent var1);
    }

    public class AfterConnectEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public AfterConnectEvent(Object source) {
            super(source);
        }
    }

    public static interface BeforeConnectEventListener
    extends EventListener {
        public void beforeConnectEventOccurred(BeforeConnectEvent var1);
    }

    public class BeforeConnectEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public BeforeConnectEvent(Object source) {
            super(source);
        }
    }
}

