/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilterApplyFor;
import com.adbs.metadata.MetadataObjectFetcherFromResultSet;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;

public class MetadataObjectFetcherFromQuery
extends MetadataObjectFetcherFromResultSet {
    protected String query;

    public MetadataObjectFetcherFromQuery(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    protected void init() throws QueryBuilderException {
        if (!this.isResultSetCreated()) {
            this.createResultSet();
        }
        super.init();
    }

    @Override
    protected void close() {
        this.destroyResultSet();
        super.close();
    }

    @Override
    public void dispose() {
        this.destroyResultSet();
        super.dispose();
    }

    public void createResultSet() throws QueryBuilderException {
        String q;
        if (this.sqlContext.getMetadataProvider().canExecSQL()) {
            String condition;
            q = this.query;
            if (q.indexOf("{D2A96EA6-30C3-45CB-9C88-C71927284386}") != -1) {
                condition = this.getMetadataFilter() != null ? this.getMetadataFilter().createPrefilterCondition(this.sqlContext, this.getSchemaFieldName(), this.getNameFieldName(), EnumSet.of(MetadataFilterApplyFor.Tables), String.valueOf('%'), String.valueOf('_')) : "";
                q = !Str.IsNullOrEmpty(condition) ? q.replace("{D2A96EA6-30C3-45CB-9C88-C71927284386}", condition) : q.replace("{D2A96EA6-30C3-45CB-9C88-C71927284386}", "(0=0)");
            }
            if (q.indexOf("{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}") != -1) {
                condition = this.getMetadataFilter() != null ? this.getMetadataFilter().createPrefilterCondition(this.sqlContext, this.getSchemaFieldName(), this.getNameFieldName(), EnumSet.of(MetadataFilterApplyFor.Views), String.valueOf('%'), String.valueOf('_')) : "";
                q = !Str.IsNullOrEmpty(condition) ? q.replace("{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}", condition) : q.replace("{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}", "(0=0)");
            }
            if (q.indexOf("{C9B6D410-A51F-4FD8-9A70-F947D847697A}") != -1) {
                condition = this.getMetadataFilter() != null ? this.getMetadataFilter().createPrefilterCondition(this.sqlContext, this.getSchemaFieldName(), this.getNameFieldName(), EnumSet.of(MetadataFilterApplyFor.Procedures), String.valueOf('%'), String.valueOf('_')) : "";
                q = !Str.IsNullOrEmpty(condition) ? q.replace("{C9B6D410-A51F-4FD8-9A70-F947D847697A}", condition) : q.replace("{C9B6D410-A51F-4FD8-9A70-F947D847697A}", "(0=0)");
            }
            if (q.indexOf("{9A785FEF-8428-4D8A-8059-21AA7B87C31E}") != -1) {
                condition = this.getMetadataFilter() != null ? this.getMetadataFilter().createPrefilterCondition(this.sqlContext, this.getSchemaFieldName(), this.getNameFieldName(), EnumSet.of(MetadataFilterApplyFor.Synonyms), String.valueOf('%'), String.valueOf('_')) : "";
                q = !Str.IsNullOrEmpty(condition) ? q.replace("{9A785FEF-8428-4D8A-8059-21AA7B87C31E}", condition) : q.replace("{9A785FEF-8428-4D8A-8059-21AA7B87C31E}", "(0=0)");
            }
        } else {
            throw new QueryBuilderException(Helpers.localizer.getString("strMetadataProviderCantExecSQL", "Used metadata provider cannot execute SQL queries."));
        }
        this.resultSet.setResultSet(this.sqlContext.getMetadataProvider().execSQL(q, false));
    }

    public void destroyResultSet() {
        this.resultSet.close();
    }

    public boolean isResultSetCreated() {
        return this.resultSet.getResultSet() != null;
    }

    private void loadDefaults() {
        MetadataContainer metadataContainer = this.sqlContext.getMetadataContainer();
        if (this.sqlContext.getSyntaxProvider().isSupportDatabases() && Helpers.isQualifiedNameEmpty(metadataContainer.getDefaultDatabaseName())) {
            try {
                metadataContainer.setDefaultDatabaseName(this.sqlContext.getSyntaxProvider().getDefaultDatabaseName(this.sqlContext));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sqlContext.getSyntaxProvider().isSupportSchemas() && metadataContainer.getDefaultSchemaNames().getCount() == 0) {
            this.sqlContext.getSyntaxProvider().getDefaultSchemaNames(this.sqlContext, metadataContainer.getDefaultSchemaNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateQuery() {
        assert (!Str.IsNullOrEmpty(this.query));
        boolean result = true;
        String q = this.query;
        q = q.replace("{D2A96EA6-30C3-45CB-9C88-C71927284386}", "(0=0)");
        q = q.replace("{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}", "(0=0)");
        q = q.replace("{C9B6D410-A51F-4FD8-9A70-F947D847697A}", "(0=0)");
        q = q.replace("{9A785FEF-8428-4D8A-8059-21AA7B87C31E}", "(0=0)");
        ResultSet rs = null;
        try {
            this.loadDefaults();
            rs = this.sqlContext.getMetadataProvider().execSQL(q, true);
        }
        catch (Exception ex) {
            result = false;
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return result;
    }
}

