/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilderFast;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryXMLCreator;
import com.adbs.querybuilder.StatisticsBase;
import com.adbs.querybuilder.StatisticsColumnList;
import com.adbs.querybuilder.StatisticsDatabaseObjectList;
import com.adbs.querybuilder.StatisticsOutputColumnList;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class QueryStatistics
extends StatisticsBase {
    private SQLSelectStatement resultQueryAST;
    private StatisticsDatabaseObjectList usedDatabaseObjects = new StatisticsDatabaseObjectList(this.getQueryBuilder(), this.getSQLContext());
    private StatisticsColumnList usedDatabaseObjectColumns = new StatisticsColumnList(this.getQueryBuilder(), this.getSQLContext());
    private StatisticsOutputColumnList outputColumnList = new StatisticsOutputColumnList(this.getQueryBuilder(), this.getSQLContext());

    public QueryStatistics(QueryBuilder queryBuilder, BaseSQLContext sqlContext) {
        super(queryBuilder, sqlContext);
    }

    @Override
    public void dispose() {
        this.usedDatabaseObjects.dispose();
        this.usedDatabaseObjectColumns.dispose();
        this.outputColumnList.dispose();
        super.dispose();
    }

    public StatisticsDatabaseObjectList getUsedDatabaseObjects() {
        return this.usedDatabaseObjects;
    }

    public StatisticsColumnList getUsedDatabaseObjectColumns() {
        return this.usedDatabaseObjectColumns;
    }

    public StatisticsOutputColumnList getOutputColumns() {
        return this.outputColumnList;
    }

    @Override
    protected void setStatisticsInvalidInternal() {
        this.resultQueryAST = null;
        this.usedDatabaseObjects.setStatisticsInvalid();
        this.usedDatabaseObjectColumns.setStatisticsInvalid();
        this.outputColumnList.setStatisticsInvalid();
    }

    public void reloadStatistics(SQLSelectStatement query) {
        this.usedDatabaseObjects.reloadStatistics(query, query.getUsedDatabaseObjects());
        this.usedDatabaseObjectColumns.reloadStatistics(query, query.getUsedDatabaseObjectColumns());
        this.outputColumnList.reloadStatistics(query);
        this.resultQueryAST = query;
        this.setStatisticsValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryStructureXML() {
        SQLBuilderFast tmpSQLBuilder = new SQLBuilderFast(null);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.newDocument();
            if (!this.isStatisticsValid()) {
                this.getQueryBuilder().generateResultQueryAST();
            }
            tmpSQLBuilder.assign(this.sqlContext.getSQLBuilderExpressionForServer());
            tmpSQLBuilder.setExpandVirtualFields(false);
            tmpSQLBuilder.setExpandVirtualObjects(false);
            QueryXMLCreator.createQueryXML(this.resultQueryAST, tmpSQLBuilder, doc);
            DOMSource src = new DOMSource(doc.getDocumentElement());
            StringWriter sw = new StringWriter();
            TransformerFactory tranFact = TransformerFactory.newInstance();
            Transformer transformer = tranFact.newTransformer();
            StreamResult dest = new StreamResult(sw);
            transformer.transform(src, dest);
            String string = sw.toString();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            tmpSQLBuilder.dispose();
        }
        return "";
    }
}

