/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.MSSQLCEQueryPropertiesDialog;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.utils.Str;

public class MSSQLCESyntaxProvider
extends MSSQLSyntaxProvider {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public boolean isSupportSchemas() {
        return false;
    }

    @Override
    public boolean isSupportProcedures() {
        return false;
    }

    @Override
    public boolean isSupportSynonyms() {
        return false;
    }

    @Override
    public boolean isSupportViews() {
        return false;
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        this.setDetectServerVersion(false);
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsMSSQLCE(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top (0) " + fieldExpression + " from " + objectExpression + " a where 0<>0";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataObjectsMSSQLCE(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataRelationsMSSQLCE(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("select c.TABLE_NAME, c.COLUMN_NAME, c.DATA_TYPE, c.CHARACTER_MAXIMUM_LENGTH, c.NUMERIC_PRECISION, c.IS_NULLABLE, c.COLUMN_DEFAULT from INFORMATION_SCHEMA.COLUMNS c where c.TABLE_NAME='" + objectName + "' order by c.ORDINAL_POSITION");
        mff.setNameFieldName("COLUMN_NAME");
        mff.setServerTypeFieldName("DATA_TYPE");
        mff.setSizeFieldName("CHARACTER_MAXIMUM_LENGTH");
        mff.setPrecisionFieldName("NUMERIC_PRECISION");
        mff.setDefaultValueFieldName("COLUMN_DEFAULT");
        mff.setNullableFieldName("IS_NULLABLE");
        mff.setNonNullableValue(null);
        mff.loadFields(metadataObject.getFields());
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return MSSQLCEQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }
}

