/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import javax.swing.Icon;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.Copyable;

public class CheckBoxListCellData
implements Comparable,
Copyable {
    protected String _text;
    protected boolean _isTextEnabled;
    protected boolean _isTextSelectable;
    protected Icon _icon;
    protected boolean _hasCheckBox;
    protected TriStateBoolean _checkBoxState = TriStateBoolean.FALSE;
    protected boolean _isCheckBoxEnabled;
    protected boolean _isCheckBoxSelectable;
    protected boolean _isArmed = false;
    protected boolean _isPressed = false;
    protected Object _userObject;
    protected String _toolTipText;
    protected int _heightAdj;
    private Object groupId;
    private boolean groupTitle;
    CheckBoxListItemStateListener listener;

    private CheckBoxListCellData() {
    }

    public CheckBoxListCellData(Icon icon, String text, Object userObject) {
        this(icon, text, false, TriStateBoolean.FALSE, userObject, null);
    }

    public CheckBoxListCellData(Icon icon, String text, Object userObject, String toolTipText) {
        this(icon, text, false, TriStateBoolean.FALSE, userObject, toolTipText);
    }

    public CheckBoxListCellData(Icon icon, String text, boolean hasCheckBox, Object userObject) {
        this(icon, text, hasCheckBox, TriStateBoolean.FALSE, userObject);
    }

    public CheckBoxListCellData(Icon icon, String text, boolean hasCheckBox, TriStateBoolean checkBoxState, Object userObject) {
        this(icon, text, hasCheckBox, checkBoxState, userObject, null);
    }

    public CheckBoxListCellData(Icon icon, String text, boolean hasCheckBox, TriStateBoolean checkBoxState, Object userObject, String toolTipText) {
        if (checkBoxState == null) {
            throw new NullPointerException();
        }
        this._icon = icon;
        this._text = text;
        this._hasCheckBox = hasCheckBox;
        this._checkBoxState = checkBoxState;
        this._userObject = userObject;
        this._toolTipText = toolTipText;
        this.setEnabled(true);
    }

    public void setStateListener(CheckBoxListItemStateListener listener) {
        this.listener = listener;
    }

    protected void fireChanged(Object source) {
        if (this.listener != null) {
            this.listener.stateChanged(this);
        }
    }

    public int compareTo(Object object) {
        if (object != null && !(object instanceof CheckBoxListCellData)) {
            throw new ClassCastException("In order to sort, all list objects must be an instance of CheckBoxListCell.");
        }
        return this.compareTo((CheckBoxListCellData)object);
    }

    public int compareTo(CheckBoxListCellData otherData) {
        if (otherData == null) {
            return 1;
        }
        String otherText = otherData._text;
        if (this._text == null) {
            if (otherText == null) {
                return 0;
            }
            return -1;
        }
        if (otherText == null) {
            return 1;
        }
        return this._text.compareTo(otherText);
    }

    public void setEnabled(boolean isEnabled) {
        this.setEnabled(isEnabled, isEnabled);
    }

    public void setEnabled(boolean isEnabled, boolean isTextSelectable) {
        this._isTextEnabled = isEnabled;
        this._isTextSelectable = isTextSelectable;
        this._isCheckBoxEnabled = isEnabled;
        this._isCheckBoxSelectable = isEnabled;
    }

    public boolean isEnabled() {
        return this._isTextEnabled && this._isCheckBoxEnabled;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public boolean isTextEnabled() {
        return this._isTextEnabled;
    }

    public void setTextEnabled(boolean isTextEnabled) {
        this._isTextEnabled = isTextEnabled;
    }

    public boolean isTextSelectable() {
        return this._isTextSelectable;
    }

    public void setTextSelectable(boolean isTextSelectable) {
        this._isTextSelectable = isTextSelectable;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public boolean getHasCheckBox() {
        return this._hasCheckBox;
    }

    public void setHasCheckBox(boolean hasCheckBox) {
        this._hasCheckBox = hasCheckBox;
    }

    public TriStateBoolean getCheckBoxState() {
        return this._checkBoxState;
    }

    public void setCheckBoxState(TriStateBoolean checkBoxState) {
        this.setCheckBoxStateWithoutFiring(checkBoxState);
        this.fireChanged(this);
    }

    public void setCheckBoxStateWithoutFiring(TriStateBoolean checkBoxState) {
        this._checkBoxState = checkBoxState;
    }

    public void setCheckBoxState(boolean checkBoxState) {
        this.setCheckBoxState(checkBoxState ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
        this.fireChanged(this);
    }

    public boolean isCheckBoxEnabled() {
        return this._isCheckBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean isCheckBoxEnabled) {
        this._isCheckBoxEnabled = isCheckBoxEnabled;
    }

    public boolean isCheckBoxSelectable() {
        return this._isCheckBoxSelectable;
    }

    public void setCheckBoxSelectable(boolean isCheckBoxSelectable) {
        this._isCheckBoxSelectable = isCheckBoxSelectable;
    }

    public boolean isArmed() {
        return this._isArmed;
    }

    public void setArmed(boolean isArmed) {
        this._isArmed = isArmed;
    }

    public boolean isPressed() {
        return this._isPressed;
    }

    public void setPressed(boolean isPressed) {
        this._isPressed = isPressed;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object userObject) {
        this._userObject = userObject;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this._toolTipText = toolTipText;
    }

    public int getHeightAdjustment() {
        return this._heightAdj;
    }

    public void setHeightAdjustment(int heightAdj) {
        this._heightAdj = heightAdj;
    }

    public Object copyTo(Object target) {
        CheckBoxListCellData copy = target != null ? (CheckBoxListCellData)target : new CheckBoxListCellData();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(CheckBoxListCellData copy) {
        copy._icon = this._icon;
        copy._text = this._text;
        copy._hasCheckBox = this._hasCheckBox;
        copy._checkBoxState = this._checkBoxState;
        copy._userObject = this._userObject;
        copy._toolTipText = this._toolTipText;
        copy.setEnabled(this.isEnabled());
    }

    public void setGroupId(Object groupId) {
        this.groupId = groupId;
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public boolean isGroupTitle() {
        return this.groupTitle;
    }

    public void setGroupTitle(boolean groupTitle) {
        this.groupTitle = groupTitle;
    }
}

