/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.pomap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.pomap.POMapCellEditor;
import oracle.dbtools.rdfgraph.r2rml.editor.pomap.POMapCellRenderer;
import oracle.dbtools.rdfgraph.r2rml.editor.pomap.POMapTableModel;
import oracle.dbtools.rdfgraph.r2rml.language.PredicateObjectMap;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLTree;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchField;

public class POMapListEditor
extends JPanel {
    R2RMLTree tree;
    TriplesMapNode tmap;
    Connection connection;
    private JTable POMAPTable;
    private POMapTableModel tmodel;
    private JToolBar toolbar;

    public POMapListEditor(R2RMLTree r2RMLTree, TriplesMapNode triplesMapNode, Connection connection) {
        this.setLayout(new BorderLayout());
        this.tree = r2RMLTree;
        this.tmap = triplesMapNode;
        this.connection = connection;
        this.initUI();
    }

    private void initUI() {
        this.tmodel = new POMapTableModel(this.tmap);
        this.toolbar = this.createToolBar();
        this.add((Component)this.toolbar, "North");
        this.POMAPTable = new JTable(this.tmodel);
        this.POMAPTable.setRowHeight(50);
        TableColumn tableColumn = this.POMAPTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new POMapCellEditor(this.tree, this.tmap, this.connection));
        tableColumn.setCellRenderer(new POMapCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.POMAPTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)jScrollPane, "Center");
    }

    private JToolBar createToolBar() {
        this.toolbar = new JToolBar();
        SearchField searchField = new SearchField();
        this.toolbar.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(UiResources.getString((String)"ADD_BUTTON_LABEL"), OracleIcons.getIcon((String)"add.png"));
        this.toolbar.add(jButton);
        jButton.addActionListener(actionEvent -> {
            PredicateObjectMap predicateObjectMap = new PredicateObjectMap("_:" + RDFStringUtils.generateRandomId());
            this.tmap.addChildEdge("<http://www.w3.org/ns/r2rml#predicateObjectMap>", predicateObjectMap);
            this.tmodel.fireTableDataChanged();
            int n = this.tmap.getPOMaps().size();
            boolean bl = this.POMAPTable.editCellAt(n - 1, 0);
            if (bl) {
                boolean bl2 = false;
                boolean bl3 = false;
                this.POMAPTable.changeSelection(n - 1, 0, bl2, bl3);
                this.POMAPTable.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(RdfgraphArb.getString("DELETE"), OracleIcons.getIcon((String)"delete.png"));
        this.toolbar.add(jButton2);
        jButton2.addActionListener(actionEvent -> {
            boolean bl;
            if (this.POMAPTable.getSelectedRow() != -1 && (bl = MessageDialog.confirm((Component)this.getTopLevelAncestor(), (Object)R2RMLArb.getString("POMapListEditor.DELETE_PREDICATE_OBJECT_MAP_"), (String)R2RMLArb.getString("POMapListEditor.CONFIRM_DELETION"), null))) {
                int n = this.POMAPTable.getSelectedRow();
                this.POMAPTable.clearSelection();
                if (this.POMAPTable.isEditing()) {
                    this.POMAPTable.getCellEditor().stopCellEditing();
                }
                this.tmodel.removeRow(n);
            }
        });
        return this.toolbar;
    }
}

