/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.editor;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.rdfgraph.sparql.SPARQLArb;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class InsertRDFTermDialog
extends JPanel
implements LayoutControl,
SearchListener {
    JTable resultTable;
    DefaultTableModel resultTableModel;
    SearchField txtSearch;
    JCheckBox chkSearchPrefix;
    Connection conn;
    BasicEditorPane editor;

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public Connection getConn() {
        return this.conn;
    }

    public InsertRDFTermDialog(JFrame jFrame, String string, Connection connection, BasicEditorPane basicEditorPane) {
        this.setLayout(new GridBagLayout());
        this.conn = connection;
        this.editor = basicEditorPane;
        this.initControls();
    }

    private void initControls() {
        this.txtSearch = new SearchField();
        this.txtSearch.setStyle(SearchField.Style.SEARCH);
        this.txtSearch.addSearchListener((SearchListener)this);
        this.add((Component)this.txtSearch, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.chkSearchPrefix = new JCheckBox(SPARQLArb.getString("InsertRDFTermDialog.PREFIX"));
        this.add((Component)this.chkSearchPrefix, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        this.resultTableModel = new DefaultTableModel(new Object[]{SPARQLArb.getString("InsertRDFTermDialog.LITERAL")}, 5);
        this.resultTable = new JTable(this.resultTableModel);
        this.add((Component)new JScrollPane(this.resultTable), LayoutControl.GBC.gbc((int)0, (int)1, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY));
        JButton jButton = new JButton(SPARQLArb.getString("InsertRDFTermDialog.INSERT"));
        this.add((Component)jButton, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = InsertRDFTermDialog.this.resultTable.getSelectedColumn();
                int n2 = InsertRDFTermDialog.this.resultTable.getSelectedRow();
                String string = (String)InsertRDFTermDialog.this.resultTable.getValueAt(n2, n);
                if (string != null) {
                    InsertRDFTermDialog.this.editor.replaceSelection("");
                    int n3 = InsertRDFTermDialog.this.editor.getCaretPosition();
                    StringBuffer stringBuffer = new StringBuffer(InsertRDFTermDialog.this.editor.getText());
                    stringBuffer.insert(n3, string);
                    InsertRDFTermDialog.this.editor.setText(stringBuffer.toString());
                    InsertRDFTermDialog.this.editor.setCaretPosition(n3 + string.length());
                }
            }
        });
    }

    public void searchPerformed(SearchEvent searchEvent) {
        Object object;
        HashMap hashMap;
        String string = "";
        string = this.chkSearchPrefix.isSelected() ? "SEARCH_RDF_LITERAL_PREFIX" : "SEARCH_RDF_LITERAL";
        String string2 = searchEvent.getSearchText();
        String string3 = Utils.getQuery(this.getClass(), (Connection)this.getConn(), (String)string);
        string3 = string3.replace("##keyword##", string2);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConn());
        List list = dBUtil.executeReturnList(string3, hashMap = new HashMap());
        if (!list.isEmpty()) {
            this.resultTableModel.getDataVector().removeAllElements();
            object = list.iterator();
            while (object.hasNext()) {
                Map map = (Map)object.next();
                this.resultTableModel.addRow(map.values().toArray());
            }
            this.resultTableModel.fireTableDataChanged();
        }
        if ((object = dBUtil.getLastException()) != null) {
            ((Throwable)object).printStackTrace();
        }
        searchEvent.getSearchProgress().finish();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }
}

