/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.utils;

import java.util.Map;
import oracle.dbtools.rdfgraph.utils.BiDirectionalMap;

public class RDFPrefixManager {
    static BiDirectionalMap activePrefixes = new BiDirectionalMap();

    public static void loadDefaultPrefixes() {
        activePrefixes.put("rr", "http://www.w3.org/ns/r2rml#");
        activePrefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        activePrefixes.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        activePrefixes.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        activePrefixes.put("ex", "http://example.com/ns#");
        activePrefixes.put("ogc", "http://www.opengis.net/ont/geosparql#");
    }

    public static void reset() {
        activePrefixes.clear();
        RDFPrefixManager.loadDefaultPrefixes();
    }

    public static void addPrefix(String string, String string2) {
        activePrefixes.put(string, string2);
    }

    public static void addPrefixes(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            activePrefixes.put(entry.getKey(), entry.getValue());
        }
    }

    public static String shortenURI(String string) {
        string = string.trim();
        String string2 = null;
        String string3 = null;
        String string4 = string.startsWith("<") ? string.substring(1, string.length() - 1) : string;
        for (String string5 : activePrefixes.getValues()) {
            if (!string4.startsWith(string5)) continue;
            string2 = activePrefixes.get(string5);
            string3 = string5;
            break;
        }
        if (string2 == null) {
            return string;
        }
        return string2 + ":" + string4.substring(string3.length());
    }

    public static String shortenURI(String string, boolean bl) {
        if (bl) {
            return RDFPrefixManager.shortenURI(string);
        }
        return string;
    }

    public static String expandURI(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            return string;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = activePrefixes.get(string2);
        if (string4 == null) {
            return string;
        }
        return "<" + string4 + string3 + ">";
    }

    static {
        RDFPrefixManager.loadDefaultPrefixes();
    }
}

