/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.addin;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ReportsPreferencePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox m_closeReports = new JCheckBox();
    private JSpinner m_chartRowLimit = new JSpinner();

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        this.m_closeReports.setSelected(dBConfig.getBoolean("REPORTCLOSE"));
        this.m_chartRowLimit.setModel(new SpinnerNumberModel(dBConfig.getInt("REPORTMAXCHARTROWS"), 0, 1000000, 1));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        dBConfig.putBoolean("REPORTCLOSE", this.m_closeReports.isSelected());
        dBConfig.putInt("REPORTMAXCHARTROWS", ((Integer)this.m_chartRowLimit.getValue()).intValue());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.m_closeReports.setText(StringUtils.stripMnemonic((String)PreferencesArb.getString((String)"REPORTCLOSE")));
        this.m_closeReports.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString((String)"REPORTCLOSE")));
        this.add(this.m_closeReports, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString((String)"REPORTCHARTROWLIMIT")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString((String)"REPORTCHARTROWLIMIT")));
        jLabel.setLabelFor(this.m_chartRowLimit);
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_chartRowLimit, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JLabel(""), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public ReportsPreferencePanel() {
        this.setHelpID("f1_dbreportsparams_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

