/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.navigatorV2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.report.navigatorV2.Folder;
import oracle.dbtools.raptor.report.navigatorV2.FolderNode;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.support.MetaPackageReference;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.util.Logger;
import oracle.dbtools.xml.MetadataManifest;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class RootNode
extends DefaultContainer {
    private static final String ENCODING = "UTF-8";
    private static RootNode INSTANCE;
    private FolderNode _userReports;
    private FolderNode _sharedReports;
    ReportXMLUtil xmlUtil = new ReportXMLUtil();
    private Attributes m_attributes = new ElementAttributes();
    XLIFFHelper xliff;
    public static final String ROOTNODE_NAME;
    public static final String USER_DEFINED_REPORTS_NODE_NAME;
    public static final String SHARED_REPORTS_NODE_NAME;
    private boolean _init = false;

    public static synchronized RootNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RootNode();
        }
        return INSTANCE;
    }

    private RootNode() {
        this.setURL(URLFactory.newURL((String)"sqldev.reports", (String)ROOTNODE_NAME));
    }

    public FolderNode getUserDefined() {
        try {
            this.open();
        }
        catch (IOException iOException) {
            Logger.severe(RootNode.class, (String)iOException.getLocalizedMessage());
        }
        return this._userReports;
    }

    public FolderNode getSharedDefined() {
        try {
            this.open();
        }
        catch (IOException iOException) {
            Logger.severe(RootNode.class, (String)iOException.getLocalizedMessage());
        }
        return this._sharedReports;
    }

    public String getShortLabel() {
        return ROOTNODE_NAME;
    }

    public Icon getIcon() {
        return ReportAddin.rootIcon;
    }

    protected void openImpl() {
        this.initialize();
    }

    public void open(String string) {
        this.open(string, null, null);
    }

    public void open(String string, String string2) {
        this.open(string, string2, null);
    }

    public void open(String string, String string2, Map<String, Object> map) {
        this.initialize();
        Map map2 = null;
        DisplayModel displayModel = DisplayModelCache.getDisplayModel((String)string);
        displayModel.setQueriesBindMap(map2);
        ReportNavigatorContextMenu.getInstance().openReport(displayModel, true, string2, map);
    }

    public void initialize() {
        if (!this._init) {
            Object object;
            Object object2;
            Iterator<MetaURLReference> iterator;
            List<MetaURLReference> list;
            Object object4;
            block33: {
                object4 = new Folder(Messages.getString("RootNode.5"), Messages.getString("RootNode.6"));
                list = URLFactory.newURL((URL)this.getURL(), (String)"Data Dictionary Reports");
                iterator = new FolderNode((URL)((Object)list), (Folder)object4);
                ((FolderNode)((Object)iterator)).setEditable(false);
                this._children.add(iterator);
                object4 = new Folder(USER_DEFINED_REPORTS_NODE_NAME, USER_DEFINED_REPORTS_NODE_NAME);
                list = URLFactory.newURL((URL)this.getURL(), (String)USER_DEFINED_REPORTS_NODE_NAME);
                this._userReports = new FolderNode((URL)((Object)list), (Folder)object4);
                this._children.add(this._userReports);
                object4 = this;
                try {
                    list = RootNode.class.getClassLoader();
                    iterator = ((ClassLoader)((Object)list)).getResource("META-INF/metadata.json");
                    if (iterator == null) break block33;
                    try (InputStream object32 = ((URL)((Object)iterator)).openStream();){
                        object2 = MetadataManifest.createManifest((InputStream)object32);
                        for (Object object3 : object2.reports()) {
                            URL uRL = ((ClassLoader)((Object)list)).getResource((String)object3);
                            if (uRL != null) {
                                try (InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), ENCODING);){
                                    XLIFFHelper xLIFFHelper = new XLIFFHelper(list, (String)object3);
                                    this.xmlUtil.parseXML((DefaultContainer)object4, inputStreamReader, false, (String)object3, xLIFFHelper, (ClassLoader)((Object)list));
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            Logger.warn(RootNode.class, (String)("Could not find report file " + (String)object3));
                        }
                    }
                    catch (IOException iOException) {
                        Logger.severe(RootNode.class, (String)("Error loading metadata manifest: " + (URL)((Object)iterator)), (Throwable)iOException);
                    }
                }
                catch (Exception exception) {
                    Logger.severe(RootNode.class, (String)(Messages.getString("RootNode.10") + exception.getMessage() + "\n*****"));
                }
            }
            try {
                list = new File(ReportAddin.USER_REPORT_FILE);
                iterator = ENCODING;
                FileInputStream fileInputStream = new FileInputStream((File)((Object)list));
                object2 = new BufferedInputStream(fileInputStream);
                object = new InputStreamReader((InputStream)object2, (String)((Object)iterator));
                this.xmlUtil.parseXML(this._userReports, (InputStreamReader)object, true, RootNode.class.getClassLoader());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                Logger.severe(RootNode.class, (String)(Messages.getString("RootNode.14") + USER_DEFINED_REPORTS_NODE_NAME));
            }
            try {
                list = ReportAddin.getRegisterReport();
                if (list.size() > 0) {
                    iterator = new Folder(SHARED_REPORTS_NODE_NAME, SHARED_REPORTS_NODE_NAME);
                    URL uRL = new URL(this.getURL().toString() + "/" + SHARED_REPORTS_NODE_NAME);
                    this._sharedReports = new FolderNode(uRL, (Folder)((Object)iterator));
                    this._sharedReports.setEditable(false);
                    this.add((Element)this._sharedReports);
                    UpdateMessage.fireChildAdded((Subject)object4, (Element)this._sharedReports);
                }
                for (MetaURLReference metaURLReference : list) {
                    try {
                        Object object3;
                        object2 = metaURLReference.openInputStream();
                        object = ENCODING;
                        object3 = new InputStreamReader((InputStream)object2, (String)object);
                        this.xmlUtil.parseXML(this._sharedReports, (InputStreamReader)object3, false, metaURLReference.getReferenceClassLoader());
                    }
                    catch (Exception exception) {
                        object = metaURLReference.getURL();
                        if (((URL)object).toURI().toString().indexOf("www.oracle.com") == -1) {
                            Logger.severe(RootNode.class, (String)(Messages.getString("RootNode.17") + ((URL)object).toString()));
                            continue;
                        }
                        Logger.info(RootNode.class, (String)(Messages.getString("RootNode.17") + ((URL)object).toString()));
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(Messages.getString("RootNode.18") + SHARED_REPORTS_NODE_NAME);
            }
            list = Collections.unmodifiableList(ReportAddin.getRegisterReportPackages());
            for (MetaPackageReference metaPackageReference : list) {
                try {
                    this.addPackage(metaPackageReference);
                    UpdateMessage.fireStructureChanged((Subject)object4);
                }
                catch (Exception exception) {
                    Logger.severe(RootNode.class, (String)(Messages.getString("RootNode.19") + metaPackageReference.getPackage()));
                }
            }
            UpdateMessage.fireStructureChanged((Subject)object4);
            this.markDirty(false);
            this._init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackage(MetaPackageReference metaPackageReference) throws Exception {
        List list = metaPackageReference.getURLReferences(".xml");
        for (MetaURLReference metaURLReference : list) {
            InputStreamReader inputStreamReader = null;
            try {
                InputStream inputStream = metaURLReference.openInputStream();
                ClassLoader classLoader = metaPackageReference.getReferenceClassLoader();
                String string = ENCODING;
                inputStreamReader = new InputStreamReader(inputStream, string);
                String string2 = null;
                String string3 = metaURLReference.getURL().toExternalForm();
                string2 = string3.contains(".jar!") ? string3.substring(string3.lastIndexOf(".jar!") + 5) : string3.substring(string3.lastIndexOf("classes") + 7);
                XLIFFHelper xLIFFHelper = new XLIFFHelper(classLoader, string2);
                this.xmlUtil.parseXML(this, inputStreamReader, false, metaPackageReference.getPackage(), xLIFFHelper, classLoader);
            }
            catch (Exception exception) {
                Logger.warn(RootNode.class, (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
            }
            finally {
                if (inputStreamReader == null) continue;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }

    static {
        ROOTNODE_NAME = Messages.getString("RootNode.1");
        USER_DEFINED_REPORTS_NODE_NAME = Messages.getString("RootNode.2");
        SHARED_REPORTS_NODE_NAME = Messages.getString("RootNode.3");
    }
}

