/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.report.ui.ChildReportsNode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ReportChildPanel
extends JPanel
implements ActionListener {
    private DefaultListModel _nameModel;
    private ChildReportsNode childReportsNode;
    private JButton _btnAdd;
    private JButton _btnRemove;
    private JList _childNameList;
    private String _errMessage;
    private JPanel _addChildPanel;
    private JTextField _childName;
    private JEWTDialog _childDlg;

    public ReportChildPanel(ChildReportsNode childReportsNode) {
        this.childReportsNode = childReportsNode;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._nameModel = new DefaultListModel();
        this._childNameList = new JList();
        this._childNameList.setSelectionMode(0);
        this._childNameList.setModel(this._nameModel);
        this._childNameList.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this._childNameList, null);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._btnAdd = new JButton();
        ResourceUtils.resButton((AbstractButton)this._btnAdd, (String)ReportArb.getString("ADD_CHILD_BTN"));
        this._btnAdd.addActionListener(this);
        jPanel.add((Component)this._btnAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._btnRemove = new JButton();
        ResourceUtils.resButton((AbstractButton)this._btnRemove, (String)ReportArb.getString("REMOVE_CHILD_BTN"));
        this._btnRemove.addActionListener(this);
        jPanel.add((Component)this._btnRemove, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 0, 10, 0), 0, 0));
        this._childNameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ReportChildPanel.this.enableDisableButtons();
            }
        });
    }

    private void enableDisableButtons() {
        int n = this._childNameList.getSelectedIndex();
        this._btnRemove.setEnabled(n != -1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._btnAdd) {
            this.addChild();
        } else if (object == this._btnRemove) {
            this.removeChild();
        }
    }

    private void removeChild() {
        int n = this._childNameList.getSelectedIndex();
        String string = (String)this._childNameList.getSelectedValue();
        if (n != -1) {
            this._nameModel.removeElementAt(n);
            int n2 = this._nameModel.getSize();
            int n3 = n < n2 ? n : n2 - 1;
            this._childNameList.setSelectedIndex(n3);
            if (n3 == -1) {
                this._btnRemove.setEnabled(false);
            } else {
                this._childNameList.ensureIndexIsVisible(n3);
            }
            this.childReportsNode.removeChild(string);
        }
    }

    private boolean addChild() {
        this._childDlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.getAddChildPanel(), (Component)this._childName, (String)ReportArb.getString("ADD_CHILD"), (int)3);
        this._childDlg.setModal(true);
        this._childDlg.pack();
        this._childDlg.setMinimumSize(new Dimension(300, 200));
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._childDlg);
        boolean bl = WizardLauncher.runDialog((JDialog)this._childDlg);
        if (bl) {
            if (this._childName.getText() != null) {
                this._childName.setText(this._childName.getText().trim());
            }
            if (!this.isValidReportName(this._childName.getText())) {
                this._childName.requestFocusInWindow();
                MessageDialog.error((Component)this._childDlg, (Object)this.getErrorMessage(), (String)ReportArb.getString("ADD_CHILD"), (String)"f1_dbPDFSecurityparam_html");
                return false;
            }
            this.addChildReportName(this._childName.getText());
            int n = this._nameModel.getSize() - 1;
            this._childNameList.setSelectedIndex(n);
            this._childNameList.ensureIndexIsVisible(n);
            this.childReportsNode.addChild(this._childName.getText());
        }
        return bl;
    }

    private JPanel getAddChildPanel() {
        if (this._addChildPanel != null) {
            this._childName.setText("");
            return this._addChildPanel;
        }
        this._addChildPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._childName, (String)ReportArb.getString("CHILD_NAME"));
        this._childName = new JTextField();
        this._addChildPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 6), 0, 0));
        this._addChildPanel.add((Component)this._childName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        return this._addChildPanel;
    }

    private boolean isValidReportName(String string) {
        this._errMessage = null;
        if (string == null || string.isEmpty()) {
            this._errMessage = ReportArb.getString("CHILD_RPT_NAME_MISSING");
        } else {
            for (int i = 0; i < this._nameModel.getSize(); ++i) {
                String string2 = (String)this._nameModel.getElementAt(i);
                if (!string.equalsIgnoreCase(string2)) continue;
                this._errMessage = ReportArb.getString("CHILD_RPT_NAME_EXISTS");
                break;
            }
        }
        return this._errMessage == null;
    }

    public void setChildNames(ArrayList<String> arrayList) {
        this._nameModel.clear();
        for (String string : arrayList) {
            this._nameModel.addElement(string);
        }
        if (!this._nameModel.isEmpty()) {
            this._childNameList.setSelectedIndex(0);
        }
        this.enableDisableButtons();
    }

    private String getErrorMessage() {
        return this._errMessage;
    }

    public void addChildReportName(String string) {
        this._nameModel.addElement(string);
    }

    public void removeChildReportName(String string) {
        this._nameModel.removeElement(string);
    }
}

