/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.jce.crypto.PbeSecretKeyImpl;

public abstract class PhaosPBESecretKeyFactorySpi
extends SecretKeyFactorySpi {
    private PBEAlgorithmIdentifier pbeAlgID;
    private String algName;
    private int keysize;

    protected PhaosPBESecretKeyFactorySpi(ASN1ObjectID oid, String algName, int keysize) {
        try {
            this.pbeAlgID = new PBEAlgorithmIdentifier(oid);
        }
        catch (AlgorithmIdentifierException e) {
            throw new RuntimeException(e.toString());
        }
        this.algName = algName;
        this.keysize = keysize;
    }

    protected PhaosPBESecretKeyFactorySpi(PBEAlgorithmIdentifier pbeAlgID, String algName, int keysize) {
        this.pbeAlgID = pbeAlgID;
        this.algName = algName;
        this.keysize = keysize;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof PBEKeySpec) {
            try {
                return new PbeSecretKeyImpl(new String(((PBEKeySpec)spec).getPassword()), (AlgorithmIdentifier)this.pbeAlgID, this.algName, this.keysize);
            }
            catch (AlgorithmIdentifierException e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unsupported KeySpec received: " + spec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec.isAssignableFrom(PBEKeySpec.class)) {
            if (!(key instanceof PbeSecretKeyImpl)) {
                throw new InvalidKeySpecException("The key is not a Phaos PBE Key");
            }
            if (keySpec.isAssignableFrom(PBEKeySpec.class)) {
                return new PBEKeySpec(((PbeSecretKeyImpl)key).getPassword().toCharArray());
            }
            throw new InvalidKeySpecException("Unknown KeySpec");
        }
        throw new InvalidKeySpecException("Unsupported key spec: " + keySpec.getName());
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        throw new InvalidKeyException("Method not available for PBE Secret Key Factory");
    }
}

