/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.plusplus.connections.db.DatabaseConnectionStore;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ConnectionStoreCommand
extends CommandListener
implements IShowCommand,
IHelp {
    public static final String COMMAND_NAME = "CONNECTIONS";
    private static final String[] ALIASES = new String[]{"CONNECTIONS", "CONNS"};
    private static final Map<String, SubCommand> subcommands = new HashMap<String, SubCommand>();
    private static final SubCommand UNKNOWN = (store, ctx, parts) -> ctx.writeln(ConnectionStoreResources.format("ERROR_INVALID_OPTION", parts[1]));

    @Override
    public String getCommand() {
        return COMMAND_NAME;
    }

    @Override
    public String getHelp() {
        return ConnectionStoreResources.getString("COMMAND_USAGE");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    private static boolean checkForMatch(String s) {
        boolean match = false;
        for (String opt : ALIASES) {
            if (!opt.equalsIgnoreCase(s)) continue;
            match = true;
            break;
        }
        return match;
    }

    private static SubCommand getCommand(String s) {
        String cmdname = s.toUpperCase();
        SubCommand result = subcommands.get(cmdname);
        return result != null ? result : UNKNOWN;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean match = false;
        String[] parts = cmd.getSQLOrig().split("\\s+", 3);
        if (parts.length >= 1 && ConnectionStoreCommand.checkForMatch(parts[0])) {
            match = true;
            if (parts.length == 1) {
                ctx.writeln(this.getHelp());
            } else {
                DatabaseConnectionStore store = DatabaseConnectionStore.getInstance();
                String subcmdstring = parts[1];
                SubCommand subcmd = ConnectionStoreCommand.getCommand(subcmdstring);
                subcmd.handleSubcommand(store, ctx, parts);
            }
        }
        return match;
    }

    private static void handleLocationOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        if (parts.length <= 2) {
            try {
                store.setConnectionFile(null);
                ctx.writeln(ConnectionStoreResources.getString("LOCATION_UNSET"));
            }
            catch (StorageException ex) {
                ctx.writeln(ConnectionStoreResources.format("ERROR_UNSETTING_LOCATION", ex.getLocalizedMessage()));
            }
        } else {
            String path = parts[2];
            Path p = FileUtils.getFilePath(ctx, path);
            if (p != null) {
                Location loc = Location.createFileLocation(p);
                try {
                    if (!loc.exists()) {
                        ctx.writeln(ConnectionStoreResources.format("LOCATION_ERR_MISSING", p));
                    }
                    store.setConnectionFile(loc);
                }
                catch (StorageException e) {
                    ctx.writeln(ConnectionStoreResources.format("LOCATION_ERROR_INVALID", p));
                }
            } else {
                ctx.writeln(ConnectionStoreResources.format("LOCATION_ERROR_INVALID", path));
            }
        }
    }

    private static void handleKeyOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        if (parts.length <= 2) {
            try {
                store.setKey(null);
                ctx.writeln(ConnectionStoreResources.getString("KEY_UNSET"));
            }
            catch (StorageException e) {
                ctx.writeln(ConnectionStoreResources.format("ERROR_UNSETTING_KEY", e.getLocalizedMessage()));
            }
        } else {
            String key = parts[2];
            try {
                store.setKey(key);
            }
            catch (StorageException e) {
                ctx.writeln(ConnectionStoreResources.getString("ERROR_BAD_KEY"));
            }
        }
    }

    private static void handleStatusOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        Location loc = store.getConnectionStoreLocation();
        boolean hasKey = store.isKeySet();
        if (loc != null) {
            Collection<String> names = store.listConnections(false);
            ctx.writeln(ConnectionStoreResources.format("STATUS_LOCATION", loc, names.size()));
        } else {
            ctx.writeln(ConnectionStoreResources.getString("LOCATION_NOT_SET"));
        }
        ctx.writeln(ConnectionStoreResources.getString(hasKey ? "KEY_STATUS_SET" : "KEY_STATUS_UNSET"));
    }

    private static void handleListOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        Collection<String> names = parts.length <= 2 ? store.listConnections(false) : store.listConnections(false, parts[2]);
        ctx.writeln(ConnectionStoreResources.getString("KNOWN_CONNECTIONS"));
        names.forEach(ctx::writeln);
    }

    private static void handleShowOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        String cName;
        DatabaseConnection conn;
        if (parts.length != 3) {
            ctx.writeln(ConnectionStoreResources.getString("COMMAND_USAGE"));
        }
        if ((conn = store.lookupConnection(cName = parts[2])) != null) {
            try {
                ctx.writeln(conn.getURL());
            }
            catch (SQLException ex) {
                ctx.writeln(ex.getLocalizedMessage());
            }
        } else {
            ctx.writeln("Error loading connection " + cName);
        }
    }

    private static void handleTestOption(DatabaseConnectionStore store, ScriptRunnerContext ctx, String[] parts) {
        String cName;
        DatabaseConnection conn;
        if (parts.length != 3) {
            ctx.writeln(ConnectionStoreResources.getString("COMMAND_USAGE"));
        }
        if ((conn = store.lookupConnection(cName = parts[2])) != null) {
            long l = System.currentTimeMillis();
            try (Connection c = conn.getUniqueConnection();){
                ctx.writeln("connection succeeded in " + (System.currentTimeMillis() - l) + "ms");
            }
            catch (SQLException ex) {
                ctx.writeln("connection failed: " + ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return ALIASES;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    static {
        subcommands.put("LOCATION", ConnectionStoreCommand::handleLocationOption);
        subcommands.put("KEY", ConnectionStoreCommand::handleKeyOption);
        subcommands.put("STATUS", ConnectionStoreCommand::handleStatusOption);
        subcommands.put("LIST", ConnectionStoreCommand::handleListOption);
        subcommands.put("SHOW", ConnectionStoreCommand::handleShowOption);
        subcommands.put("TEST", ConnectionStoreCommand::handleTestOption);
    }

    private static interface SubCommand {
        public void handleSubcommand(DatabaseConnectionStore var1, ScriptRunnerContext var2, String[] var3);
    }
}

