/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderStorageFactory;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.plusplus.connections.db.ImplicitConnection;
import oracle.dbtools.plusplus.connections.db.NamedConnection;
import oracle.dbtools.util.Logger;

final class DatabaseConnectionStore
implements ConnectionStoreBridge {
    private static final ReferenceWorker NULL_WORKER = ReferenceWorker.createNullWorker();
    private final Map<String, DatabaseConnection> namedConnections = new HashMap<String, DatabaseConnection>();
    private Location loc;
    private ReferenceWorker worker = NULL_WORKER;

    DatabaseConnectionStore() {
    }

    private static ReferenceWorker createWorker(String key) {
        return ModelUtil.hasLength(key) ? ReferenceWorker.createDefaultWorker(key) : NULL_WORKER;
    }

    public static DatabaseConnectionStore getInstance() {
        return Holder.INSTANCE;
    }

    void setConnectionFile(Location loc) throws StorageException {
        this.removeConnections(this.loc);
        this.loc = loc;
        this.loadConnections();
    }

    void setKey(String key) throws StorageException {
        this.removeConnections(this.loc);
        this.worker = DatabaseConnectionStore.createWorker(key);
        this.loadConnections();
    }

    boolean isKeySet() {
        return this.worker != NULL_WORKER;
    }

    public Location getConnectionStoreLocation() {
        return this.loc;
    }

    private void removeConnections(Location oldLoc) {
        if (oldLoc != null) {
            this.namedConnections.values().removeIf(dbc -> oldLoc == dbc.getConnectionLocation());
        }
    }

    private void loadConnections() throws StorageException {
        if (this.loc != null) {
            StorageManager mgr = StorageManager.builder().location(this.loc).addEnvValue(ReferenceWorker.KEY, this.worker).build();
            Storage<DatabaseProvider> storage = mgr.getStorage("jdbc");
            DatabaseProviderStorageFactory factory = new DatabaseProviderStorageFactory();
            ArrayList<DatabaseProvider> providers = new ArrayList<DatabaseProvider>();
            for (String name : storage.listConnections()) {
                try {
                    DatabaseProvider provider = storage.getConnection(name, factory);
                    providers.add(provider);
                }
                catch (StorageException e) {
                    Logger.severe(DatabaseConnectionStore.class, e);
                }
            }
            for (DatabaseProvider provider : providers) {
                this.namedConnections.put(provider.getName(), new NamedConnection(provider, this.loc));
            }
        }
    }

    Collection<String> listConnections(boolean includeImplicit) {
        return this.listConnections(entry -> {
            DatabaseConnection conn = (DatabaseConnection)entry.getValue();
            return includeImplicit || conn.getConnectionLocation() != null;
        });
    }

    Collection<String> listConnections(boolean includeImplicit, String type) {
        return this.listConnections(entry -> {
            DatabaseConnection conn = (DatabaseConnection)entry.getValue();
            return !(!includeImplicit && conn.getConnectionLocation() == null || type != null && !type.equals(conn.getType()));
        });
    }

    Collection<String> listConnections(Predicate<Map.Entry<String, DatabaseConnection>> checker) {
        return this.namedConnections.entrySet().stream().filter(checker).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    DatabaseConnection lookupConnection(String name) {
        DatabaseConnection result = this.namedConnections.get(name);
        if (result == null && name.startsWith("\"")) {
            String url = DatabaseConnectionStore.strip(name, '\"');
            ConnectionDetails details = new ConnectionDetails(url);
            result = new ImplicitConnection(details);
            this.namedConnections.put(name, result);
        }
        return result;
    }

    DatabaseConnection lookupConnection(Connection conn) {
        DatabaseConnection result = null;
        for (DatabaseConnection db : this.namedConnections.values()) {
            if (!db.matchConnection(conn)) continue;
            result = db;
            break;
        }
        return result;
    }

    private static String strip(String connStr, char stripChar) {
        if ((connStr = connStr.trim()).charAt(0) == stripChar && connStr.charAt(connStr.length() - 1) == stripChar) {
            return connStr.substring(1, connStr.length() - 1);
        }
        return connStr;
    }

    @Override
    public void addConnection(ConnectionDetails cd) {
        ImplicitConnection conn = new ImplicitConnection(cd);
        String name = conn.getName();
        if (this.namedConnections.containsKey(name)) {
            this.namedConnections.remove(name);
        }
        this.namedConnections.put(name, conn);
    }

    @Override
    public boolean removeConnection(String name) {
        return name.startsWith("\"") && this.namedConnections.remove(name) != null;
    }

    private static final class Holder {
        private static final DatabaseConnectionStore INSTANCE = new DatabaseConnectionStore();

        private Holder() {
        }
    }
}

