/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.ora.OracleConnectionCreator;
import oracle.dbtools.db.ConnectionResolverImplementation;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.db.ConnectionSupport;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.plusplus.connections.db.DatabaseConnectionStore;
import oracle.dbtools.plusplus.connections.db.NamedConnectionResolver;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;

public final class SqlclConnectionSupport
extends ConnectionSupport {
    public ConnectionStoreBridge getConnectionStoreBridge() {
        return DatabaseConnectionStore.getInstance();
    }

    @Override
    protected LockManager lockManager() {
        return LockManagerHolder.LOCKER;
    }

    @Override
    protected ConnectionResolverImplementation connectionResolver() {
        return ResolverHolder.RESOLVER;
    }

    @Override
    protected DatabaseFeatureRegistry featureRegistry() {
        return FeatureRegistryHolder.FEATURE_REGISTRY;
    }

    @Override
    protected void installImpl() throws IllegalStateException {
        super.installImpl();
        DatabaseProvider.registerConnectionCreator("oraJDBC", OracleConnectionCreator.newInstance());
    }

    private static final class ResolverHolder {
        private static final ConnectionResolverImplementation RESOLVER = new NamedConnectionResolver(DatabaseConnectionStore.getInstance());

        private ResolverHolder() {
        }
    }

    private static final class FeatureRegistryHolder {
        private static final DatabaseFeatureRegistry FEATURE_REGISTRY = DatabaseFeatureRegistry.DEFAULT_REGISTRY;

        private FeatureRegistryHolder() {
        }
    }

    private static final class LockManagerHolder {
        private static final LockManager LOCKER = LockManager.NOOP_LOCK_MANAGER;

        private LockManagerHolder() {
        }
    }
}

