/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.ssh;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import oracle.dbtools.plusplus.ssh.SSHConsole;
import oracle.dbtools.plusplus.ssh.TunnelDescriptor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SSHConnection {
    private static final int TIMEOUT = 15000;
    ConnType m_type;
    String m_host;
    String m_user;
    String m_identityFile;
    String m_basePort;
    String m_portForward;
    String m_password;
    ClientSession session;
    TunnelDescriptor sessionDescriptor;
    ScriptRunnerContext m_ctx;

    private static SshdSocketAddress createAddress(String host, int port) {
        return host != null ? new SshdSocketAddress(host, port) : new SshdSocketAddress(port);
    }

    public SSHConnection(ScriptRunnerContext ctx, ConnType type, String host, String user, String identity, String basePort, String portf, String pass) {
        this.m_ctx = ctx;
        this.m_type = type;
        this.m_host = host;
        this.m_user = user;
        this.m_identityFile = identity;
        this.m_basePort = basePort;
        this.m_portForward = portf;
        this.m_password = pass;
    }

    public boolean connect() {
        SshClient client = Client.INSTANCE.getClient();
        SSHConsole console = new SSHConsole(this.m_ctx);
        try {
            int port = 22;
            try {
                port = Integer.parseInt(this.m_basePort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            System.out.println("Using port:" + port);
            client.setFilePasswordProvider(console.getPasswordProvider());
            this.session = (ClientSession)((ConnectFuture)client.connect(this.m_user, this.m_host, port).verify(15000L)).getSession();
            if (this.m_identityFile != null && !this.m_identityFile.equals("")) {
                File f = new File(this.m_identityFile);
                ClientIdentitiesWatcher ciw = new ClientIdentitiesWatcher(Collections.singletonList(f.toPath()), () -> ((SshClient)client).getClientIdentityLoader(), () -> ((SshClient)client).getFilePasswordProvider(), true);
                this.session.setKeyIdentityProvider((KeyIdentityProvider)ciw);
            }
            this.session.setUserInteraction(console.getUserInteraction());
            this.session.setPasswordIdentityProvider(sc -> Arrays.asList(this.session.getUserInteraction().getUpdatedPassword(this.session, "Password for " + this.session.getUsername(), "")));
            if (this.m_password != null && this.m_password.length() > 0) {
                this.session.addPasswordIdentity(this.m_password);
            }
            this.session.auth().verify(15000L);
            this.sessionDescriptor = null;
            if (this.m_portForward != null && this.m_portForward.split(":").length == 3) {
                String[] parts = this.m_portForward.split(":");
                int lport = Integer.parseInt(parts[0]);
                String rhost = parts[1];
                int rport = Integer.parseInt(parts[2]);
                SshdSocketAddress remoteAddress = SSHConnection.createAddress(rhost, rport);
                SshdSocketAddress bindAddress = this.session.startLocalPortForwarding(SSHConnection.createAddress(null, lport), remoteAddress);
                if (bindAddress != null) {
                    this.sessionDescriptor = new TunnelDescriptor(this.m_host, this.m_user, bindAddress, remoteAddress);
                }
            }
            return this.sessionDescriptor != null;
        }
        catch (IOException e) {
            this.m_ctx.write(e.getLocalizedMessage() + "\n");
            return false;
        }
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public TunnelDescriptor getSession() {
        return this.sessionDescriptor;
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.session.close(false);
            this.session = null;
            this.sessionDescriptor = null;
        }
    }

    public static enum ConnType {
        NONE,
        PASSWORD,
        KEYFILE;

    }

    public static enum Result {
        CONNECTED,
        NOTCONNECTED,
        ERROR;

    }

    private static final class Client {
        static final Client INSTANCE = new Client();
        private final SshClient sshClient = SshClient.setUpDefaultClient();

        private Client() {
            this.sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        }

        private void start() {
            this.sshClient.start();
        }

        public SshClient getClient() {
            return this.sshClient;
        }

        static {
            INSTANCE.start();
        }
    }
}

