/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.BiPredicate;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.HistoryService;

public class DefaultItemsSelector
implements BiPredicate<HistoryService, HistoryItem> {
    private boolean resolutionPending = true;
    private Boolean selectFails;
    private Integer selectLastNDays;
    private Instant threshholdInstant;

    private DefaultItemsSelector(Boolean selectFails, Integer selectLastNDays) {
        this.selectFails = selectFails;
        this.selectLastNDays = selectLastNDays;
    }

    @Override
    public boolean test(HistoryService historyService, HistoryItem item) {
        if (this.resolutionPending) {
            if (this.selectFails == null) {
                this.selectFails = historyService.isSelectFails();
            }
            if (this.selectLastNDays == null) {
                this.selectLastNDays = historyService.getSelectLastNDays();
                if (this.selectLastNDays > 0) {
                    this.threshholdInstant = Instant.now().minus(this.selectLastNDays.intValue(), ChronoUnit.DAYS);
                }
            }
            this.resolutionPending = false;
        }
        if (item.status() == HistoryItem.Status.PENDING || !this.selectFails.booleanValue() && item.status() == HistoryItem.Status.ERROR) {
            return false;
        }
        return this.threshholdInstant == null || item.time().compareTo(this.threshholdInstant) >= 0;
    }

    public static class Builder {
        private Boolean selectFails;
        private Integer selectLastNDays;

        public Builder selectFails(boolean selectFails) {
            this.selectFails = selectFails;
            return this;
        }

        public Builder selectLastNDays(int selectLastNDays) {
            this.selectLastNDays = selectLastNDays;
            return this;
        }

        public BiPredicate<HistoryService, HistoryItem> build() {
            return new DefaultItemsSelector(this.selectFails, this.selectLastNDays);
        }
    }
}

