/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.console.impl.ParseUtil;
import oracle.dbtools.raptor.console.impl.SqlclWidgets;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.jline.reader.Buffer;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.Parser;
import org.jline.utils.Log;

public class SqlclParser
implements Parser {
    private Buffer buffer;
    private SqlclWidgets widgets;
    private ScriptRunnerContext scriptRunnerContext;

    public SqlclParser jLineBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public SqlclParser scriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
        return this;
    }

    public SqlclParser widgets(SqlclWidgets widgets) {
        this.widgets = widgets;
        return this;
    }

    public boolean isEscapeChar(char ch) {
        return false;
    }

    public CompletingParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        LineParser lineParser = new LineParser(line, cursor, context);
        if (!lineParser.isComplete()) {
            if (context == Parser.ParseContext.SECONDARY_PROMPT) {
                throw new EOFError(-1, -1, "continutation required", lineParser.getSecondaryPrompt());
            }
            throw new EOFError(-1, -1, "continutation required");
        }
        return lineParser.getParsedLine();
    }

    private class LineParser {
        private final String line;
        private final int cursor;
        private final Parser.ParseContext context;
        private final boolean complete;
        private final CompletingParsedLine parsedLine;
        private final List<String> words = new LinkedList<String>();
        private int wordCursor = 0;
        private int wordIndex = -1;
        private int rawWordCursor = 0;
        private int rawWordLength = 0;

        LineParser(String line, int cursor, Parser.ParseContext context) {
            this.line = line;
            this.cursor = cursor;
            this.context = context;
            try {
                this.complete = this.parse();
                this.parsedLine = this.createParsedLine();
            }
            catch (RuntimeException ex) {
                Log.error("parser", ex);
                throw ex;
            }
        }

        boolean isComplete() {
            return this.complete;
        }

        CompletingParsedLine getParsedLine() {
            return this.parsedLine;
        }

        String getSecondaryPrompt() {
            boolean lineIsCurrent;
            int c;
            if (SqlclParser.this.buffer == null) {
                return "more";
            }
            String bufferContent = SqlclParser.this.buffer.toString();
            int bufferLength = bufferContent.length();
            int lineStart = this.cursor > bufferLength ? bufferLength : this.cursor;
            int cursorPointer = SqlclParser.this.buffer.cursor();
            int lineEnd = bufferLength;
            int lineNo = 1;
            for (c = 0; c < lineStart; ++c) {
                if (bufferContent.charAt(c) != '\n') continue;
                ++lineNo;
            }
            for (c = lineStart; c < bufferLength; ++c) {
                if (bufferContent.charAt(c) != '\n') continue;
                lineEnd = c;
                break;
            }
            boolean bl = lineIsCurrent = lineStart <= cursorPointer && cursorPointer <= lineEnd;
            return (lineNo < 10 ? "   " : (lineNo < 100 ? "  " : " ")) + lineNo + (lineIsCurrent ? "* " : "  ");
        }

        private boolean parse() {
            if (this.line != null) {
                List<LexerToken> tokens = ParseUtil.tokenize(this.line);
                StringBuilder wordBuffer = new StringBuilder();
                int tokenCount = tokens.size();
                int wordBegin = 0;
                int wordEnd = 0;
                boolean blockEnd = false;
                for (int w = 0; w < tokenCount; ++w) {
                    LexerToken token = tokens.get(w);
                    if (token.content.trim().isEmpty()) {
                        this.resetWordBuffer(wordBuffer, wordBegin, wordEnd, w < tokenCount - 1 ? tokens.get((int)(w + 1)).begin : this.rightTrimmedLength(this.line) + 1);
                        continue;
                    }
                    int endBlockTokenBegin = this.endBlockTokenBegin(token);
                    boolean bl = blockEnd = endBlockTokenBegin >= 0;
                    if (blockEnd) {
                        wordBegin = endBlockTokenBegin;
                        wordEnd = this.line.length();
                        wordBuffer.append('\n').append(token.content);
                        continue;
                    }
                    if (wordBuffer.length() == 0) {
                        wordBegin = token.begin;
                    }
                    wordEnd = token.end;
                    if (this.isLineContinuationToken(token)) continue;
                    wordBuffer.append(token.content);
                    if (token.type != Token.LINE_COMMENT) continue;
                    wordBuffer.append('\n');
                }
                this.resetWordBuffer(wordBuffer, wordBegin, wordEnd, this.rightTrimmedLength(this.line) + 1);
                if (this.words.size() > 0 && this.context != Parser.ParseContext.COMPLETE && this.context != Parser.ParseContext.SPLIT_LINE) {
                    String lastWord = this.words.get(this.words.size() - 1);
                    if (lastWord.isEmpty() && this.words.size() > 1) {
                        lastWord = this.words.get(this.words.size() - 2);
                    }
                    if (this.context == Parser.ParseContext.SECONDARY_PROMPT) {
                        return false;
                    }
                    if ((SqlclParser.this.widgets == null || !SqlclParser.this.widgets.isRunImmediately()) && (tokens.get((int)(tokens.size() - 1)).type == Token.INCOMPLETE || this.isContinuedLine() || this.isUnclosedQuoted(lastWord) || this.isPartialBlock(blockEnd, lastWord))) {
                        return false;
                    }
                }
                if (SqlclParser.this.widgets != null && this.context == Parser.ParseContext.ACCEPT_LINE) {
                    SqlclParser.this.widgets.onLineAccepted();
                }
            }
            return true;
        }

        private void resetWordBuffer(StringBuilder wordBuffer, int wordBegin, int wordEnd, int nextWordBegin) {
            int length = wordBuffer.length();
            if (length > 0) {
                boolean firstWord = this.words.isEmpty();
                if (firstWord && wordBuffer.charAt(0) == '@') {
                    if (length > 1 && wordBuffer.charAt(1) == '@') {
                        this.words.add("@@");
                        if (length > 2) {
                            this.words.add(wordBuffer.substring(2));
                            wordBegin += 2;
                        }
                    } else {
                        this.words.add("@");
                        if (length > 1) {
                            this.words.add(wordBuffer.substring(1));
                            ++wordBegin;
                        }
                    }
                } else if (firstWord && wordBuffer.charAt(0) == '!') {
                    this.words.add("!");
                    if (length > 1) {
                        this.words.add(wordBuffer.substring(1));
                        ++wordBegin;
                    }
                } else {
                    this.words.add(wordBuffer.toString());
                }
                if (this.wordIndex < 0 && this.cursor >= wordBegin && this.cursor <= wordEnd) {
                    this.wordIndex = this.words.size() - 1;
                    this.rawWordCursor = this.wordCursor = this.cursor < wordBegin ? 0 : this.cursor - wordBegin;
                    this.rawWordLength = wordEnd - wordBegin;
                }
                wordBuffer.setLength(0);
            }
        }

        private boolean isLineContinuationToken(LexerToken token) {
            if (token.content.equals("-")) {
                int lineLength = this.line.length();
                for (int next = token.end; next < lineLength; ++next) {
                    char ch = this.line.charAt(next);
                    if (ch == '\n') {
                        return true;
                    }
                    if (ch == ' ' || ch == '\t' || ch == '\r') continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        int endBlockTokenBegin(LexerToken token) {
            if (token.content.equals("/") || token.content.equals(this.getBlockTerminator())) {
                char ch;
                int lineLength = this.line.length();
                for (int next = token.end; next < lineLength; ++next) {
                    ch = this.line.charAt(next);
                    if (ch == ' ' || ch == '\t' || ch == '\r') continue;
                    return -1;
                }
                for (int prev = token.begin - 1; prev >= 0; --prev) {
                    ch = this.line.charAt(prev);
                    if (ch == '\n') {
                        return prev + 1;
                    }
                    if (ch == ' ' || ch == '\t' || ch == '\r') continue;
                    return -1;
                }
                return 0;
            }
            return -1;
        }

        private boolean isContinuedLine() {
            int lastCharIndex;
            for (int index = lastCharIndex = this.line.length() - 1; index >= 0; --index) {
                char ch = this.line.charAt(index);
                if (ch == '-') {
                    return true;
                }
                if (ch == ' ' || ch == '\t' || ch == '\r') continue;
                return false;
            }
            return false;
        }

        private boolean isUnclosedQuoted(String lastWord) {
            boolean unclosedQuoted = false;
            if (lastWord.length() > 0) {
                char firstChar = lastWord.charAt(0);
                if (firstChar == '\'') {
                    unclosedQuoted = lastWord.substring(1).indexOf(39) < 0;
                } else if (firstChar == '\"') {
                    unclosedQuoted = lastWord.substring(1).indexOf(34) < 0;
                }
            }
            return unclosedQuoted;
        }

        private int rightTrimmedLength(String line) {
            int length;
            for (length = line.length(); length > 0 && Character.isWhitespace(line.charAt(length - 1)); --length) {
            }
            return length;
        }

        private boolean isPartialBlock(boolean blockEnd, String lastWord) {
            boolean partial;
            if (blockEnd) {
                partial = false;
            } else {
                partial = false;
                ISQLCommand cmd = ParseUtil.parseLast(String.join((CharSequence)" ", this.words));
                if (cmd != null) {
                    if (cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SCRIPT && ("script".equals(lastWord) || this.line.indexOf(10) >= 0)) {
                        partial = true;
                    } else if (cmd.getStmtType() != SQLCommand.StmtType.G_C_SQLPLUS && cmd.getStmtType() != SQLCommand.StmtType.G_C_USERDEFINED) {
                        if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQL && this.treatBlankLineAsBlockTerminator() && this.line.endsWith("\n")) {
                            this.words.add("\n" + this.getBlockTerminator());
                        } else {
                            partial = cmd.getStatementTerminator() == null || cmd.getStatementTerminator().isEmpty();
                        }
                    }
                }
            }
            return partial;
        }

        private boolean treatBlankLineAsBlockTerminator() {
            return SqlclParser.this.scriptRunnerContext == null || !SqlclParser.this.scriptRunnerContext.getBooleanProperty("SQLBLANKLINES", "on", "off", false);
        }

        private String getBlockTerminator() {
            return String.valueOf(SqlclParser.this.scriptRunnerContext != null ? SqlclParser.this.scriptRunnerContext.getCharProperty("BLOCKTERMINATOR", '.') : (char)'.');
        }

        private CompletingParsedLine createParsedLine() {
            return new CompletingParsedLine(){

                public int wordIndex() {
                    return LineParser.this.wordIndex;
                }

                public String word() {
                    if (LineParser.this.wordIndex < 0 || LineParser.this.wordIndex >= LineParser.this.words.size()) {
                        return "";
                    }
                    return LineParser.this.words.get(LineParser.this.wordIndex);
                }

                public int wordCursor() {
                    return LineParser.this.wordCursor;
                }

                public List<String> words() {
                    return LineParser.this.words;
                }

                public int cursor() {
                    return LineParser.this.cursor;
                }

                public String line() {
                    return LineParser.this.line;
                }

                public CharSequence escape(CharSequence candidate, boolean complete) {
                    return candidate;
                }

                public int rawWordCursor() {
                    return LineParser.this.rawWordCursor;
                }

                public int rawWordLength() {
                    return LineParser.this.rawWordLength;
                }
            };
        }
    }
}

