/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.Logger;
import org.fusesource.jansi.AnsiRenderer;

@Restricted(level=Restricted.Level.NONE)
public class SetSQLPrompt
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_SQLPROMPT;

    public SetSQLPrompt() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String newName = "";
        newName = !cmd.getSQLOrig().equals(cmd.getModifiedSQL()) ? this.diff(cmd.getModifiedSQL().trim().replaceAll("\\s+", " "), this.getBase()) : (String)cmd.getProperty("prop_file_string");
        if (newName != null && !newName.trim().equals("") && (newName = this.resolveEntities(newName)) != null) {
            ctx.setPrompt(newName);
            String store = "";
            try {
                store = AnsiRenderer.render((String)ctx.getPrompt());
            }
            catch (Exception e) {
                Logger.finest(this.getClass(), "AnsiRenderer.render(ctx.getPrompt())" + e.getLocalizedMessage(), e);
                store = ctx.getPrompt();
            }
            ctx.setBasePrompt(store);
        }
        return true;
    }

    private String resolveEntities(String newPrompt) {
        StringBuilder buff = new StringBuilder();
        int eFrom = 0;
        int eBegin = newPrompt.indexOf("&#", eFrom);
        while (eBegin >= 0) {
            int nBegin = eBegin + 2;
            int eEnd = newPrompt.indexOf(";", nBegin);
            if (eEnd >= 0) {
                String numRep = newPrompt.substring(nBegin, eEnd);
                try {
                    int codePoint = numRep.length() > 0 && Character.toLowerCase(numRep.charAt(0)) == 'x' ? Integer.parseInt(numRep.substring(1), 16) : Integer.parseInt(numRep);
                    buff.append(newPrompt.substring(eFrom, eBegin));
                    buff.append(new String(Character.toChars(codePoint)));
                    eFrom = eEnd + 1;
                    eBegin = newPrompt.indexOf("&#", eFrom);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.out.println("invalid entity: " + newPrompt.substring(eBegin, eEnd));
                    return null;
                }
            }
            System.out.println("incomplete entity at: " + newPrompt.substring(eBegin));
            return null;
        }
        buff.append(newPrompt.substring(eFrom));
        return buff.toString();
    }

    private String getBase() {
        return "set sqlp";
    }

    private static SQLCommand.StmtSubType getType() {
        return SQLCommand.StmtSubType.G_S_SET_SQLPROMPT;
    }

    private String diff(String str1, String str2) {
        int index2;
        int index = str1.indexOf(str2);
        if (index > -1 && (index2 = str1.substring(index + str2.length()).indexOf(32)) > -1) {
            return str1.substring(index + str2.length() + index2 + 1);
        }
        return "";
    }
}

