/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.json.stream.JsonParsingException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTExtractor;
import oracle.dbtools.rest.export.RestExport;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.swagger.SwaggerImport;
import oracle.dbtools.util.Logger;
import oracle.dbtools.versions.SQLclVersion;
import oracle.jdbc.OracleConnection;

public class RESTCommand
extends CommandListener
implements IHelp {
    private static final String ALL_PRIVS_QUERY = "select NAME, LABEL, DESCRIPTION, COMMENTS from USER_ORDS_PRIVILEGES where schema_id > 1000";
    private static final String SYS_SCHEMAS_QUERY = "select s.PARSING_SCHEMA, m.PATTERN, s.STATUS  from ORDS_METADATA.ORDS_SCHEMAS s, ORDS_METADATA.ORDS_URL_MAPPINGS m where s.url_mapping_id = m.id and S.PARSING_SCHEMA <> 'ORDS_METADATA'";
    private static final String ALL_SCHEMAS_QUERY = "select PARSING_SCHEMA, PATTERN, STATUS from USER_ORDS_SCHEMAS";
    private static final String ALL_MODULES_QUERY = "select NAME, URI_PREFIX PREFIX, STATUS, ITEMS_PER_PAGE from USER_ORDS_MODULES";
    private static final String CMD = "REST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("rest")) {
            return false;
        }
        String sql = cmd.getSql();
        ArrayList<String> cmds = new ArrayList<String>();
        this.splitArgs(sql, cmds);
        if (cmds.size() == 0) return false;
        if (cmds.size() > 0 && !"rest".equalsIgnoreCase(cmds.get(0))) {
            return false;
        }
        String option = null;
        String module = null;
        if (cmds.size() < 2 || cmds.size() >= 4) {
            ctx.write(this.getHelp());
            return true;
        }
        if (cmds.size() >= 2) {
            option = cmds.get(1);
        }
        if (cmds.size() >= 3) {
            module = cmds.get(2);
        }
        if ("import".equalsIgnoreCase(option)) {
            return this.handleImport(module, ctx);
        }
        if (conn == null) {
            ctx.write(Messages.getString("ApexCmd.7"));
            return true;
        }
        if (conn == null) return false;
        if (!(conn instanceof OracleConnection)) {
            return false;
        }
        OracleConnection ocon = (OracleConnection)conn;
        try {
            if (ocon != null && (ctx.getProperty("script.runner.PRELIM_AUTH") == null || Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE)).booleanValue())) {
                if (!DBUtil.isOracleConnectionAlive((Connection)ocon)) {
                    ctx.write(Messages.getString("ApexCmd.7"));
                    return true;
                }
                boolean amILocked = LockManager.lock((Connection)ocon);
                try {
                    if (!amILocked) return true;
                    if ("modules".equalsIgnoreCase(option)) {
                        this.listAllModules((Connection)ocon, ctx);
                        return true;
                    }
                    if ("export".equalsIgnoreCase(option)) {
                        RESTExtractor caller = new RESTExtractor();
                        RESTExtractor.ExportEntity result = caller.getExport((Connection)ocon, module);
                        String schemaName = "";
                        String ordsVersion = "";
                        if (result.schema != null) {
                            schemaName = result.schema.getSchemaName();
                            ordsVersion = result.schema.getOrdsSchemaVersion();
                        }
                        RestExport restExport = new RestExport("SQLcl", SQLclVersion.getSQLclVersion(), schemaName, ordsVersion);
                        RestSchema schema = result.schema;
                        List<RestModule> modules = result.modules;
                        ArrayList<RestPrivilege> privileges = new ArrayList<RestPrivilege>();
                        ArrayList<String> rolesToCreate = new ArrayList<String>(result.rolesToCreate);
                        privileges.addAll(result.privileges.values());
                        Object generated = restExport.exportModulesRolesPrivileges(schema, modules, rolesToCreate, privileges);
                        generated = (String)generated + "\n";
                        ctx.write((String)generated);
                        return true;
                    }
                    if ("privileges".equalsIgnoreCase(option)) {
                        this.listAllPrivs((Connection)ocon, ctx);
                        return true;
                    }
                    if ("schemas".equalsIgnoreCase(option)) {
                        this.listAllSchemas((Connection)ocon, ctx);
                        return true;
                    }
                    ctx.write(this.getHelp());
                    boolean caller = true;
                    return caller;
                }
                finally {
                    if (amILocked) {
                        LockManager.unlock((Connection)ocon);
                    }
                }
            }
            ctx.write(Messages.getString("ApexCmd.7"));
            return true;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                System.err.println("ORDS is not installed in the current schema.");
                return true;
            }
            Logger.finest(this.getClass(), e.getLocalizedMessage(), e);
            ctx.write(e.getLocalizedMessage() + "\n");
            return true;
        }
        catch (IOException f) {
            Logger.finest(this.getClass(), f.getLocalizedMessage(), f);
            return true;
        }
        catch (RESTExtractor.ModuleNotFoundException g) {
            RESTExtractor.ModuleSearchOrigin origin = g.getOrigin();
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.ALL.name())) {
                System.err.println("No modules found in the current schema.");
                return true;
            }
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.NAME.name())) {
                System.err.println("No module named: " + g.getModuleName());
                return true;
            }
            if (origin.name().equals(RESTExtractor.ModuleSearchOrigin.PATH.name())) {
                if ("/".equals(g.getModulePath())) {
                    System.err.println("No module found with an empty prefix");
                    return true;
                } else {
                    System.err.println("No module found with the name or path specified.");
                }
                return true;
            }
            System.err.println("Unknown module origin");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleImport(String filename, ScriptRunnerContext ctx) {
        String contents;
        block8: {
            if (filename == null) {
                System.err.println("A filename is required.");
                return true;
            }
            contents = this.readFile(filename);
            if (contents != null) break block8;
            boolean bl = true;
            return bl;
        }
        try {
            SwaggerImport importer = new SwaggerImport();
            String result = importer.importSwagger(contents);
            ctx.write(result);
        }
        catch (IOException f) {
            Logger.finest(this.getClass(), f.getLocalizedMessage(), f);
            boolean bl = true;
            return bl;
        }
        catch (JsonParsingException e) {
            System.err.println("JSON conents are invalid.");
        }
        return true;
    }

    private String readFile(String fileName) throws IOException {
        Path file = Paths.get(fileName, new String[0]);
        boolean fileExists = Files.exists(file, new LinkOption[0]);
        if (!fileExists) {
            System.err.println("The provided file does not exist: " + fileName);
            return null;
        }
        List<String> readLines = Files.readAllLines(file);
        StringBuilder contents = new StringBuilder();
        for (String line : readLines) {
            contents.append(line);
        }
        return contents.toString();
    }

    private void listAllModules(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement(ALL_MODULES_QUERY);
        this.executeGenericCall(ctx, stmt);
    }

    private void listAllSchemas(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        block2: {
            OracleConnection ocon = (OracleConnection)conn;
            PreparedStatement stmt = ocon.prepareStatement(SYS_SCHEMAS_QUERY);
            try {
                this.executeGenericCall(ctx, stmt);
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 942) break block2;
                stmt = ocon.prepareStatement(ALL_SCHEMAS_QUERY);
                this.executeGenericCall(ctx, stmt);
            }
        }
    }

    private void listAllPrivs(Connection conn, ScriptRunnerContext ctx) throws SQLException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = ocon.prepareStatement(ALL_PRIVS_QUERY);
        this.executeGenericCall(ctx, stmt);
    }

    private void executeGenericCall(ScriptRunnerContext ctx, PreparedStatement statement) throws SQLException, IOException {
        ResultSet result = statement.executeQuery();
        SQLPLUSCmdFormatter formatter = new SQLPLUSCmdFormatter(ctx);
        formatter.rset2sqlplusShrinkToSize(result, ctx.getBaseConnection(), ctx.getOutputStream());
    }

    protected boolean splitArgs(String commandline, ArrayList<String> args) {
        int lineLength = commandline.length();
        int terminalIndex = lineLength - 1;
        boolean nullChar = false;
        StringBuilder arg = new StringBuilder();
        StringBuilder quoted = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < lineLength; ++i) {
            char ch = commandline.charAt(i);
            if (quoteChar != '\u0000') {
                quoted.append(ch);
                if (ch == quoteChar) {
                    arg.append((CharSequence)quoted);
                    quoted = new StringBuilder();
                    quoteChar = '\u0000';
                }
            } else if (ch == '\"' || ch == '\'') {
                quoted.append(ch);
                quoteChar = ch;
            } else if (Character.isWhitespace(ch)) {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg = new StringBuilder();
                }
            } else {
                arg.append(ch);
            }
            if (i != terminalIndex || quoteChar == '\u0000') continue;
            arg.append(quoteChar);
            i -= quoted.length() - 1;
            quoted = new StringBuilder();
            quoteChar = '\u0000';
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
    }
}

