/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.rest;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitable;
import oracle.dbtools.raptor.scriptrunner.commands.rest.RESTVisitor;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.util.StreamCopy;
import oracle.jdbc.OracleConnection;

public class RESTExtractor {
    private static final String PRIVILEGES_QUERY = "select x.*,  (select listagg(y.pattern,'|^|') within group (order by y.pattern) from USER_ORDS_PRIVILEGE_MAPPINGS y where x.name=y.name) as patterns from USER_ORDS_PRIVILEGE_MODULES pm, USER_ORDS_PRIVILEGES x where pm.module_name = ? and pm.privilege_id = x.id";
    private static final String LEGACY_PRIVILEGES_QUERY = "select x.*,  (select listagg(y.pattern,'|^|') within group (order by y.pattern) from USER_ORDS_PRIVILEGE_MAPPINGS y where x.name=y.name) as patterns from USER_ORDS_PRIVILEGE_MODULES pm, USER_ORDS_PRIVILEGES x where pm.module_name = ? and pm.privilege_id = x.id".replace("USER_", "ALL_");
    private static final String EXTRACT_MODULES_QUERY = "select * from USER_ORDS_MODULES ";
    private static final String PRIVILEGE_ROLES_QUERY = "select pr.role_name, r.schema_id role_owner_id from USER_ORDS_PRIVILEGE_ROLES pr, USER_ORDS_ROLES r where pr.privilege_name = ? and pr.role_id = r.id";
    private static final String LEGACY_PRIVILEGE_ROLES_QUERY = "select pr.role_name, r.schema_id role_owner_id from USER_ORDS_PRIVILEGE_ROLES pr, USER_ORDS_ROLES r where pr.privilege_name = ? and pr.role_id = r.id".replace("USER_", "ALL_");
    private static final String SCHEMA_INFO_SQL = "select parsing_schema, type, pattern, status, auto_rest_auth, ords.installed_version ords_version from user_ords_schemas";

    public ExportEntity getExport(Connection conn, String moduleName) throws SQLException, IOException, ModuleNotFoundException {
        HashSet<String> rolesToCreate = new HashSet<String>();
        List<RestModule> modules = this.getModules(conn, moduleName, rolesToCreate);
        Map<String, RestPrivilege> privileges = this.getPrivileges(conn, modules, rolesToCreate, false);
        boolean isRequestingAllModules = moduleName == null || "".equals(moduleName);
        boolean isModulePath = false;
        if (moduleName != null) {
            isModulePath = moduleName.startsWith("/");
        }
        ExportEntity entity = new ExportEntity();
        entity.modules = modules;
        entity.privileges = privileges;
        entity.isRequestionAllModules = isRequestingAllModules;
        entity.isModulePath = isModulePath;
        entity.moduleFilter = moduleName;
        entity.rolesToCreate = rolesToCreate;
        entity.schema = this.getSchema(conn);
        return entity;
    }

    private String getCanonicalPath(String modulePath) {
        Object res = modulePath;
        if (modulePath == null || "".equals(modulePath)) {
            return modulePath;
        }
        if ("/".equals(modulePath)) {
            return modulePath;
        }
        if (!((String)res).startsWith("/")) {
            res = "/" + (String)res;
        }
        if (!((String)res).endsWith("/")) {
            res = (String)res + "/";
        }
        return res;
    }

    private RestSchema getSchema(Connection conn) throws SQLException {
        RestSchema schema = null;
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = ocon.prepareStatement(SCHEMA_INFO_SQL);
            result = stmt.executeQuery();
            if (result.next()) {
                String parsingSchema = result.getString("parsing_schema");
                String type = result.getString("type");
                String pattern = result.getString("pattern");
                String status = result.getString("status");
                String autoRestAuth = result.getString("auto_rest_auth");
                String ordsVersion = result.getString("ords_version");
                schema = new RestSchema(parsingSchema, type, pattern, status, autoRestAuth, ordsVersion);
            }
        }
        catch (SQLException f) {
            throw f;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return schema;
    }

    private List<RestModule> getModules(Connection conn, String moduleName, Set<String> rolesToCreate) throws SQLException, ModuleNotFoundException, IOException {
        List<RestModule> modules = null;
        try {
            modules = this.getModules(conn, moduleName, rolesToCreate, false);
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            // empty catch block
        }
        if (modules == null || modules.isEmpty()) {
            modules = this.getModules(conn, this.getCanonicalPath(moduleName), rolesToCreate, true);
        }
        return modules;
    }

    private List<RestModule> getModules(Connection conn, String moduleName, Set<String> rolesToCreate, Boolean isPrefixSearch) throws SQLException, ModuleNotFoundException, IOException {
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        ResultSet result = null;
        boolean isRequestingAllModules = moduleName == null || "".equals(moduleName);
        boolean isModulePath = false;
        ArrayList<RestModule> modules = new ArrayList<RestModule>();
        try {
            if (isRequestingAllModules) {
                stmt = ocon.prepareStatement("select * from USER_ORDS_MODULES  order by name");
            } else {
                Object baseStatement = EXTRACT_MODULES_QUERY;
                isModulePath = isPrefixSearch;
                if (isModulePath) {
                    if ("/".equals(moduleName)) {
                        baseStatement = (String)baseStatement + " where uri_prefix is null";
                        stmt = ocon.prepareStatement((String)baseStatement);
                    } else {
                        baseStatement = (String)baseStatement + " where uri_prefix = ?";
                        baseStatement = (String)baseStatement + " or uri_prefix = ?";
                        baseStatement = (String)baseStatement + " or uri_prefix = ?";
                        baseStatement = (String)baseStatement + " or uri_prefix = ? order by name";
                        stmt = ocon.prepareStatement((String)baseStatement);
                        stmt.setString(1, moduleName);
                        stmt.setString(2, moduleName.substring(1, moduleName.length()));
                        stmt.setString(3, moduleName.substring(1, moduleName.length() - 1));
                        stmt.setString(4, moduleName.substring(0, moduleName.length() - 1));
                    }
                } else {
                    baseStatement = (String)baseStatement + " where name = ? order by name";
                    stmt = ocon.prepareStatement((String)baseStatement);
                    stmt.setString(1, moduleName);
                }
            }
            result = stmt.executeQuery();
            boolean hasModules = false;
            while (result.next()) {
                hasModules = true;
                String name = result.getString("NAME");
                String prefix = result.getString("URI_PREFIX");
                Integer items = result.getInt("ITEMS_PER_PAGE");
                String status = result.getString("STATUS");
                String comments = result.getString("COMMENTS");
                Integer moduleId = result.getInt("ID");
                RestModule newModule = new RestModule();
                newModule.setName(name);
                newModule.setURIPrefix(prefix);
                newModule.setPaginationSize(items.intValue());
                newModule.setPublished(status);
                newModule.setComments(comments);
                newModule.setTemplates(this.getTemplates(conn, moduleId));
                modules.add(newModule);
            }
            if (!hasModules && !isRequestingAllModules) {
                if (isModulePath) {
                    throw new ModuleNotFoundException(ModuleSearchOrigin.PATH, moduleName);
                }
                throw new ModuleNotFoundException(ModuleSearchOrigin.NAME, moduleName);
            }
            if (!hasModules) {
                throw new ModuleNotFoundException(ModuleSearchOrigin.ALL);
            }
        }
        catch (SQLException f) {
            throw f;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return modules;
    }

    private Map<String, RestPrivilege> getPrivileges(Connection conn, List<RestModule> modules, Set<String> rolesToCreate, boolean legacy) throws SQLException {
        HashMap<String, RestPrivilege> privs = new HashMap<String, RestPrivilege>();
        if (modules == null) {
            return privs;
        }
        OracleConnection ocon = (OracleConnection)conn;
        for (RestModule module : modules) {
            String moduleName = module.getName();
            PreparedStatement stmt = null;
            stmt = legacy ? ocon.prepareStatement(LEGACY_PRIVILEGES_QUERY) : ocon.prepareStatement(PRIVILEGES_QUERY);
            stmt.setString(1, moduleName);
            ResultSet result = null;
            try {
                result = stmt.executeQuery();
                while (result.next()) {
                    String name = result.getString("name");
                    if (privs.containsKey(name)) {
                        ((RestPrivilege)privs.get(name)).getModules().add(moduleName);
                        continue;
                    }
                    String label = result.getString("label");
                    String description = result.getString("description");
                    String comments = result.getString("comments");
                    String unparsedPatterns = result.getString("patterns");
                    List<String> roles = this.getPrivilegeRoles(conn, name, rolesToCreate, legacy);
                    ArrayList<String> privilegeModules = new ArrayList<String>();
                    ArrayList<String> patterns = new ArrayList<String>();
                    privilegeModules.add(moduleName);
                    RestPrivilege privilege = new RestPrivilege();
                    privilege.setName(name);
                    privilege.setTitle(label);
                    privilege.setDescription(description);
                    privilege.setComments(comments);
                    privilege.setRoles(roles);
                    privilege.setModules(privilegeModules);
                    if (unparsedPatterns != null && unparsedPatterns.length() > 0) {
                        String[] tokens = unparsedPatterns.split("\\|\\^\\|");
                        for (int i = 0; i < tokens.length; ++i) {
                            patterns.add(tokens[i]);
                        }
                    }
                    privilege.setURIPatterns(patterns);
                    privs.put(name, privilege);
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 942 && !legacy) {
                    Map<String, RestPrivilege> map = this.getPrivileges(conn, modules, rolesToCreate, true);
                    return map;
                }
                throw e;
            }
            finally {
                if (result != null) {
                    result.close();
                }
                if (stmt == null) continue;
                stmt.close();
            }
        }
        return privs;
    }

    private List<String> getPrivilegeRoles(Connection conn, String privilegeName, Set<String> rolesToCreate, boolean legacy) throws SQLException {
        ArrayList<String> roles = new ArrayList<String>();
        if (privilegeName == null || privilegeName.equals("")) {
            return roles;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        stmt = legacy ? ocon.prepareStatement(LEGACY_PRIVILEGE_ROLES_QUERY) : ocon.prepareStatement(PRIVILEGE_ROLES_QUERY);
        stmt.setString(1, privilegeName);
        ResultSet result = null;
        try {
            result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString("role_name");
                Integer roleOwner = result.getInt("role_owner_id");
                roles.add(name);
                if (roleOwner <= 10) continue;
                rolesToCreate.add(name);
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942 && !legacy) {
                List<String> list = this.getPrivilegeRoles(conn, privilegeName, rolesToCreate, true);
                return list;
            }
            throw e;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return roles;
    }

    private List<RestTemplate> getTemplates(Connection conn, Integer id) throws SQLException, IOException {
        ArrayList<RestTemplate> templates = new ArrayList<RestTemplate>();
        if (id == null) {
            return templates;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = ocon.prepareStatement("select * from USER_ORDS_TEMPLATES where module_id = ? order by uri_template");
            stmt.setInt(1, id);
            result = stmt.executeQuery();
            while (result.next()) {
                String uriTemplate = result.getString("URI_TEMPLATE");
                Integer priority = result.getInt("PRIORITY");
                String etagType = result.getString("ETAG_TYPE");
                String etagQuery = result.getString("ETAG_QUERY");
                String comments = result.getString("COMMENTS");
                Integer templateId = result.getInt("ID");
                RestTemplate newTemplate = new RestTemplate();
                newTemplate.setURIPattern(uriTemplate);
                newTemplate.setPriority(priority);
                newTemplate.setEntityTag(etagType);
                newTemplate.setEntityTagQuery(etagQuery);
                newTemplate.setComments(comments);
                newTemplate.setResourceHandlers(this.getHandlers(conn, templateId));
                templates.add(newTemplate);
            }
        }
        catch (SQLException f) {
            throw f;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return templates;
    }

    private List<RestResourceHandler> getHandlers(Connection conn, Integer id) throws SQLException, IOException {
        ArrayList<RestResourceHandler> handlers = new ArrayList<RestResourceHandler>();
        if (id == null) {
            return handlers;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = ocon.prepareStatement("select * from USER_ORDS_HANDLERS where template_id = ? order by method");
            stmt.setInt(1, id);
            result = stmt.executeQuery();
            while (result.next()) {
                String sourceType = result.getString("SOURCE_TYPE");
                String method = result.getString("METHOD");
                String mimesAllowed = result.getString("MIMES_ALLOWED");
                Integer itemsPerPage = result.getInt("ITEMS_PER_PAGE");
                Clob source = result.getClob("SOURCE");
                String comments = result.getString("COMMENTS");
                StringBuilder ce = new StringBuilder();
                StreamCopy.drain(source.getCharacterStream(), ce);
                InputStream clob = StreamCopy.toInputStream(ce.toString());
                RestResourceHandler handler = new RestResourceHandler();
                ArrayList<String> mimeTypes = new ArrayList<String>();
                String[] mimes = null;
                if (mimesAllowed != null && (mimes = mimesAllowed.split(",")) != null) {
                    for (int i = 0; i < mimes.length; ++i) {
                        String mime = mimes[i];
                        if (mime == null) continue;
                        mimeTypes.add(mime.trim());
                    }
                }
                handler.setSourceType(sourceType);
                handler.setMethodType(method);
                handler.setMimeTypes(mimeTypes);
                handler.setPaginationSize(itemsPerPage.intValue());
                handler.setComments(comments);
                handler.setSQL(StreamCopy.string(clob));
                Integer handlerId = result.getInt("ID");
                handler.setParameters(this.getParameters(conn, handlerId));
                handlers.add(handler);
            }
        }
        catch (SQLException f) {
            throw f;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return handlers;
    }

    private List<RestHandlerParameter> getParameters(Connection conn, Integer id) throws SQLException {
        ArrayList<RestHandlerParameter> parameters = new ArrayList<RestHandlerParameter>();
        if (id == null) {
            return parameters;
        }
        OracleConnection ocon = (OracleConnection)conn;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = ocon.prepareStatement("select * from USER_ORDS_PARAMETERS where handler_id = ? order by name");
            stmt.setInt(1, id);
            result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString("NAME");
                String bindName = result.getString("BIND_VARIABLE_NAME");
                String sourceType = result.getString("SOURCE_TYPE");
                String accessMethod = result.getString("ACCESS_METHOD");
                String paramType = result.getString("PARAM_TYPE");
                String comments = result.getString("COMMENTS");
                RestHandlerParameter parameter = new RestHandlerParameter();
                parameter.setName(name);
                parameter.setBindVariable(bindName);
                parameter.setSourceType(sourceType);
                parameter.setAccessMethod(accessMethod);
                parameter.setDataType(paramType);
                parameter.setComments(comments);
                parameters.add(parameter);
            }
        }
        catch (SQLException f) {
            throw f;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return parameters;
    }

    class ExportEntity
    implements RESTVisitable {
        public RestSchema schema;
        public Set<String> rolesToCreate;
        public String moduleFilter;
        public boolean isModulePath;
        public boolean isRequestionAllModules;
        List<RestModule> modules;
        Map<String, RestPrivilege> privileges;

        ExportEntity() {
        }

        @Override
        public void accept(RESTVisitor visitor) throws IOException {
            visitor.visit(this);
        }
    }

    public static enum ModuleSearchOrigin {
        NAME,
        PATH,
        ALL;

    }

    class ModuleNotFoundException
    extends Throwable {
        private static final long serialVersionUID = 1548710029851198208L;
        private ModuleSearchOrigin origin;
        private String moduleName;
        private String modulePath;

        ModuleNotFoundException(ModuleSearchOrigin origin) {
            this.origin = null;
            this.moduleName = null;
            this.modulePath = null;
            this.origin = origin;
        }

        ModuleNotFoundException(ModuleSearchOrigin origin, String originName) {
            this(origin, originName, null);
        }

        ModuleNotFoundException(ModuleSearchOrigin origin, String originName, Throwable t) {
            super(t);
            this.origin = null;
            this.moduleName = null;
            this.modulePath = null;
            this.origin = origin;
            if (ModuleSearchOrigin.NAME.equals((Object)origin)) {
                this.moduleName = originName;
            }
            if (ModuleSearchOrigin.PATH.equals((Object)origin)) {
                this.modulePath = originName;
            }
        }

        public ModuleSearchOrigin getOrigin() {
            return this.origin;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModulePath() {
            return this.modulePath;
        }
    }
}

