/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.TemplateData;

class TemplateFactory {
    static TemplateFactory impl_;

    TemplateFactory() {
    }

    static synchronized TemplateFactory getInstance() {
        if (impl_ == null) {
            impl_ = new TemplateFactory();
        }
        return impl_;
    }

    AbstractTemplate createTemplate(HashStructure hash) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String clazz = hash.getString("templateClass");
        Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        Constructor<?> ctor = c.getConstructor(HashStructure.class);
        return (AbstractTemplate)ctor.newInstance(hash);
    }

    AbstractTemplate createTemplateFromExtensionHook(HashStructure hash, Class def, TemplateData lookup) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String clazzKey = "templateClass/#text";
        String idKey = "templateId/#text";
        String clazz = hash.getString(clazzKey);
        if (clazz == null && def != null) {
            clazz = def.getName();
        }
        if (clazz == null) {
            throw new InstantiationException("Template hash does not define value for " + clazzKey);
        }
        String id = hash.getString(idKey);
        if (id == null) {
            throw new InstantiationException("Template hash does not define value for " + idKey);
        }
        AbstractTemplate original = lookup.findTemplateById(id);
        HashStructure newHash = HashStructure.newInstance();
        if (original != null) {
            original.getData().copyTo(newHash);
        }
        newHash.putString("templateClass", clazz);
        AbstractTemplate template = this.createTemplate(newHash);
        template.initializeFromExtensionHook(hash, lookup);
        return template;
    }

    String getTemplateId(HashStructure templateHash) {
        String idKey = "templateId/#text";
        return templateHash.getString(idKey);
    }
}

