/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.CommandLineField;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserListTable;
import oracle.ideimpl.webbrowser.BrowserOptions;
import oracle.ideimpl.webbrowser.BrowserOptionsTableModel;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.PlatformUtils;

public final class BrowserOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JButton addButton;
    private JButton removeButton;
    private JButton resetButton;
    private static final String PARENT_TEXT_FIELD = "parent";
    private static final String[] BROWSER_ICONS = new String[]{BrowserOptions.BrowserIconId.IE.toString(), BrowserOptions.BrowserIconId.FIREFOX.toString(), BrowserOptions.BrowserIconId.SAFARI.toString(), BrowserOptions.BrowserIconId.CHROME.toString(), BrowserOptions.BrowserIconId.OPERA.toString(), BrowserOptions.BrowserIconId.SEAMONKEY.toString(), BrowserOptions.BrowserIconId.GENERIC.toString()};
    private JTextField browserNameTextfield;
    private CommandLineField browserPathTextfield;
    private JButton browserPathLookUpButton;
    private JTextField browserParamTextfield;
    private JComboBox iconsCombo;
    private BrowserListTable browserTable;
    private BrowserOptionsTableModel browserTableModel;

    public BrowserOptionsPanel() {
        this.setHelpID("f1_prefweb_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private BrowserOptions findBrowserOptions(TraversableContext tc) {
        return BrowserOptions.getInstance(tc.getPropertyStorage());
    }

    private void initBrowserTableModel(BrowserOptions browserOptions) {
        ListStructure isDefaultList = browserOptions.getBrowserIsDefaultList();
        ListStructure nameList = browserOptions.getBrowserNameList();
        ListStructure pathList = browserOptions.getBrowserPathList();
        ListStructure paramList = browserOptions.getBrowserParamList();
        ListStructure iconList = browserOptions.getBrowserIconList();
        this.browserTableModel.clear();
        if (isDefaultList != null) {
            int rowCount = isDefaultList.size();
            int defaultRowIdx = -1;
            for (int row = 0; row < rowCount; ++row) {
                this.browserTableModel.addRow((Boolean)isDefaultList.get(row), (String)nameList.get(row), (String)pathList.get(row), (String)paramList.get(row), (String)iconList.get(row));
                if (!((Boolean)isDefaultList.get(row)).booleanValue()) continue;
                defaultRowIdx = row;
            }
            if (defaultRowIdx == -1 && this.browserTableModel.getRowCount() > 0) {
                this.browserTableModel.setValueAt(Boolean.TRUE, 0, 0);
            }
        }
        if (this.browserTable.getRowCount() > 0) {
            int defaultBrowserIdx = browserOptions.getDefaultBrowserIndex();
            this.browserTable.getSelectionModel().setSelectionInterval(defaultBrowserIdx, defaultBrowserIdx);
        }
    }

    public void onEntry(TraversableContext tc) {
        BrowserOptions browserOptions = this.findBrowserOptions(tc);
        this.initBrowserTableModel(browserOptions);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        BrowserOptions browserOptions = this.findBrowserOptions(tc);
        ListStructure browserIsDefaultList = ListStructure.newInstance();
        ListStructure browserNameList = ListStructure.newInstance();
        ListStructure browserPathList = ListStructure.newInstance();
        ListStructure browserParamList = ListStructure.newInstance();
        ListStructure browserIconList = ListStructure.newInstance();
        if (this.browserTableModel.getRowCount() == 0) {
            int rtn = JOptionPane.showConfirmDialog((Component)((Object)this), BrowserArb.getString(36), BrowserArb.getString(37), 2, 2);
            if (rtn == 0) {
                this.initBrowserTableModel(browserOptions);
            }
            throw new TraversalException(null);
        }
        String defaultBrowserPath = "";
        String defaultBrowserParam = "";
        for (int row = 0; row < this.browserTableModel.getRowCount(); ++row) {
            Vector data = this.browserTableModel.getFullRow(row);
            browserIsDefaultList.add(data.get(0));
            browserNameList.add(data.get(1));
            browserPathList.add(data.get(2));
            browserParamList.add(data.get(3));
            browserIconList.add(data.get(4));
            if (!((Boolean)data.get(0)).booleanValue()) continue;
            defaultBrowserPath = (String)data.get(2);
            defaultBrowserParam = (String)data.get(3);
        }
        this.warnEmptyBrowserPath(browserNameList, browserPathList);
        this.warnNonExistingBrowserPath(browserNameList, browserPathList);
        this.warnBrowserIconConflict(browserNameList, browserIconList);
        browserOptions.setBrowserCmdLine(defaultBrowserPath, defaultBrowserParam);
        browserOptions.setBrowserIsDefaultList(browserIsDefaultList);
        browserOptions.setBrowserNameList(browserNameList);
        browserOptions.setBrowserPathList(browserPathList);
        browserOptions.setBrowserParamList(browserParamList);
        browserOptions.setBrowserIconList(browserIconList);
        browserOptions.setUseEmbeddedBrowserForPreview(false);
    }

    private void warnEmptyBrowserPath(ListStructure browserNameList, ListStructure browserPathList) throws TraversalException {
        int indexOfBrowserWithEmptyPath = this.areAllBrowserPathFieldsCompleted((List<String>)browserPathList);
        if (indexOfBrowserWithEmptyPath != -1) {
            String invalidBrowserName = (String)browserNameList.get(indexOfBrowserWithEmptyPath);
            String msg = BrowserArb.format(7, invalidBrowserName);
            JOptionPane.showConfirmDialog((Component)((Object)this), msg, BrowserArb.getString(4), -1, 0);
            this.browserTable.getSelectionModel().setSelectionInterval(indexOfBrowserWithEmptyPath, indexOfBrowserWithEmptyPath);
            this.browserPathTextfield.requestFocus();
            throw new TraversalException(null);
        }
    }

    private void warnNonExistingBrowserPath(ListStructure browserNameList, ListStructure browserPathList) throws TraversalException {
        int indexOfBrowserInvalidPath = this.isBrowserPathListValid((List<String>)browserPathList);
        if (indexOfBrowserInvalidPath != -1) {
            String invalidBrowserName = (String)browserNameList.get(indexOfBrowserInvalidPath);
            String invalidBrowserPath = (String)browserPathList.get(indexOfBrowserInvalidPath);
            String msg = BrowserArb.format(8, invalidBrowserPath, invalidBrowserName);
            int rtn = JOptionPane.showConfirmDialog((Component)((Object)this), msg, BrowserArb.getString(5), 0, 2);
            if (rtn != 0) {
                this.browserTable.getSelectionModel().setSelectionInterval(indexOfBrowserInvalidPath, indexOfBrowserInvalidPath);
                this.browserPathTextfield.requestFocus();
                throw new TraversalException(null);
            }
        }
    }

    private void warnBrowserIconConflict(ListStructure browserNameList, ListStructure browserIconList) throws TraversalException {
        Integer[] indexesWithConflict = this.isIconAssignmentValid((List<String>)browserIconList);
        if (indexesWithConflict.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < indexesWithConflict.length; ++i) {
                String browserWithConflict = (String)browserNameList.get(indexesWithConflict[i].intValue());
                sb.append(browserWithConflict);
                if (i == indexesWithConflict.length - 1) continue;
                sb.append(", ");
            }
            String msg = BrowserArb.format(10, Integer.toString(indexesWithConflict.length), sb.toString());
            int rtn = JOptionPane.showConfirmDialog((Component)((Object)this), msg, BrowserArb.getString(6), 0, 2);
            if (rtn != 0) {
                int firstIndexWithConflict = indexesWithConflict[0];
                this.browserTable.getSelectionModel().setSelectionInterval(firstIndexWithConflict, firstIndexWithConflict);
                this.browserPathTextfield.requestFocus();
                throw new TraversalException(null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addButton) {
            if (this.browserTable.isEditing()) {
                this.browserTable.getCellEditor().stopCellEditing();
            }
            boolean isDefault = this.browserTableModel.getRowCount() == 0;
            this.browserTableModel.addRow(isDefault, BrowserArb.getString(11), "", "", BrowserOptions.BrowserIconId.GENERIC.toString());
            int lastAddedRowIdx = this.browserTableModel.getRowCount() - 1;
            this.browserTable.getSelectionModel().setSelectionInterval(lastAddedRowIdx, lastAddedRowIdx);
            this.browserTable.scrollToVisible(lastAddedRowIdx, 0);
        }
        if (source == this.removeButton) {
            int selectedRowIdx;
            if (this.browserTable.isEditing()) {
                this.browserTable.getCellEditor().stopCellEditing();
            }
            if ((selectedRowIdx = this.browserTable.getSelectedRow()) >= 0) {
                boolean setDefaultOnNewSelection = false;
                if (this.browserTableModel.isDefault(selectedRowIdx)) {
                    setDefaultOnNewSelection = true;
                }
                this.browserTableModel.removeRow(selectedRowIdx);
                int newSelectedIdx = Math.min(selectedRowIdx, this.browserTableModel.getRowCount() - 1);
                if (newSelectedIdx >= 0) {
                    this.browserTable.getSelectionModel().setSelectionInterval(newSelectedIdx, newSelectedIdx);
                    if (setDefaultOnNewSelection) {
                        this.browserTableModel.setValueAt(true, newSelectedIdx, 0);
                    }
                }
            }
        }
        if (source == this.resetButton) {
            int rtn;
            if (this.browserTable.isEditing()) {
                this.browserTable.getCellEditor().stopCellEditing();
            }
            if ((rtn = JOptionPane.showConfirmDialog((Component)((Object)this), BrowserArb.getString(34), BrowserArb.getString(35), 0)) != 0) {
                return;
            }
            this.browserTableModel.clear();
            Object[][] browsers = BrowserOptions.getAvailableBrowserList();
            int defaultBrowserIdx = 0;
            for (int i = 0; i < browsers.length; ++i) {
                Object[] browser = browsers[i];
                if (((Boolean)browser[0]).booleanValue()) {
                    defaultBrowserIdx = i;
                }
                this.browserTableModel.addRow((Boolean)browser[0], (String)browser[1], (String)browser[2], (String)browser[3], (String)browser[4]);
            }
            this.browserTable.getSelectionModel().setSelectionInterval(defaultBrowserIdx, defaultBrowserIdx);
        }
        if (source == this.browserPathLookUpButton) {
            String path;
            URL url;
            int result;
            String title = BrowserArb.getString(3);
            String fileName = this.browserPathTextfield.getText();
            URL defaultURL = fileName != null && fileName.length() > 0 ? URLFactory.newFileURL((String)fileName) : null;
            URLChooser chooser = DialogUtil.newURLChooser(defaultURL);
            if (PlatformUtils.isWindows()) {
                String ext1 = BrowserArb.getString(82);
                String ext2 = BrowserArb.getString(83);
                String ext3 = BrowserArb.getString(84);
                chooser.setURLFilter((URLFilter)new DefaultURLFilter(BrowserArb.getString(81), new String[]{ext1, ext2, ext3}));
            }
            if ((result = chooser.showOpenDialog((Component)((Object)this), title)) == 0 && (url = chooser.getSelectedURL()) != null && (path = URLFileSystem.getPlatformPathName((URL)url)) != null) {
                this.browserPathTextfield.setText(path);
            }
        }
    }

    private void initializeComponent() {
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets browserListInsets = new Insets(5, 5, 5, 5);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets labelInsets = new Insets(7, 5, 2, 5);
        BrowserDetailsEditHandler detailsEditHandler = new BrowserDetailsEditHandler();
        this.addButton = new JButton();
        this.addButton.addActionListener(this);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(this);
        this.resetButton = new JButton();
        this.resetButton.addActionListener(this);
        this.addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.resetButton.setIcon(OracleIcons.getIcon((String)"undo.png"));
        this.addButton.setToolTipText(BrowserArb.getString(30));
        this.removeButton.setToolTipText(BrowserArb.getString(31));
        this.resetButton.setToolTipText(BrowserArb.getString(32));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this.addButton);
        controlBar.add((Component)this.removeButton);
        this.browserTableModel = new BrowserOptionsTableModel();
        this.browserTable = new BrowserListTable(this.browserTableModel);
        this.browserTable.setSelectionMode(0);
        ListSelectionModel browserSelModel = this.browserTable.getSelectionModel();
        JScrollPane scrollpane = new JScrollPane(this.browserTable);
        browserSelModel.addListSelectionListener(detailsEditHandler);
        JLabel tableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)tableLabel, (Component)scrollpane, (String)BrowserArb.getString(23));
        ComponentWithTitlebar browserListPanel = new ComponentWithTitlebar((JComponent)scrollpane, tableLabel, controlBar);
        browserListPanel.setMinimumSize(new Dimension(200, 0));
        JPanel browserDetailPanel = new JPanel(new GridBagLayout());
        JLabel browserNameLabel = new JLabel();
        this.browserNameTextfield = new JTextField();
        ResourceUtils.resLabel((JLabel)browserNameLabel, (Component)this.browserNameTextfield, (String)BrowserArb.getString(26));
        this.browserNameTextfield.getDocument().putProperty(PARENT_TEXT_FIELD, this.browserNameTextfield);
        this.browserNameTextfield.getDocument().addDocumentListener(detailsEditHandler);
        JLabel browserPathLabel = new JLabel();
        this.browserPathTextfield = new CommandLineField();
        ResourceUtils.resLabel((JLabel)browserPathLabel, (Component)((Object)this.browserPathTextfield), (String)BrowserArb.getString(27));
        this.browserPathTextfield.getDocument().putProperty(PARENT_TEXT_FIELD, (Object)this.browserPathTextfield);
        this.browserPathTextfield.getDocument().addDocumentListener(detailsEditHandler);
        JLabel browserParamLabel = new JLabel();
        this.browserParamTextfield = new JTextField();
        ResourceUtils.resLabel((JLabel)browserParamLabel, (Component)this.browserParamTextfield, (String)BrowserArb.getString(28));
        this.browserParamTextfield.getDocument().putProperty(PARENT_TEXT_FIELD, this.browserParamTextfield);
        this.browserParamTextfield.getDocument().addDocumentListener(detailsEditHandler);
        JLabel browserIconLabel = new JLabel();
        this.iconsCombo = new JComboBox<String>(BROWSER_ICONS);
        ResourceUtils.resLabel((JLabel)browserIconLabel, (Component)this.iconsCombo, (String)BrowserArb.getString(29));
        this.iconsCombo.setRenderer(new IconComboBoxItemRender());
        this.iconsCombo.addItemListener(detailsEditHandler);
        ControlBar browserPathLookUpControlBar = new ControlBar();
        this.browserPathLookUpButton = new JButton();
        this.browserPathLookUpButton.setToolTipText(BrowserArb.getString(33));
        this.browserPathLookUpButton.setIcon(OracleIcons.getIcon((String)"lov.png"));
        this.browserPathLookUpButton.addActionListener(this);
        browserPathLookUpControlBar.add((Component)this.browserPathLookUpButton);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
        browserDetailPanel.add((Component)browserNameLabel, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        browserDetailPanel.add((Component)this.browserNameTextfield, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
        browserDetailPanel.add((Component)browserPathLabel, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        browserDetailPanel.add((Component)((Object)this.browserPathTextfield), constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0);
        browserDetailPanel.add((Component)browserPathLookUpControlBar, constraints);
        constraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
        browserDetailPanel.add((Component)browserParamLabel, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        browserDetailPanel.add((Component)this.browserParamTextfield, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
        browserDetailPanel.add((Component)browserIconLabel, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        browserDetailPanel.add((Component)this.iconsCombo, constraints);
        constraints = new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 17, 0, defaultInsets, 0, 0);
        browserDetailPanel.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, browserListInsets, 0, 0);
        this.add((Component)browserListPanel, constraints);
        constraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, defaultInsets, 0, 0);
        this.add(browserDetailPanel, constraints);
    }

    private boolean isBrowserPathValid(String commandLine) {
        if (commandLine != null && commandLine.length() > 0) {
            String command = CommandLineField.getCommand(commandLine);
            File existingFile = null;
            if (new File(command).exists()) {
                existingFile = new File(command);
            } else if (new File(commandLine).exists()) {
                existingFile = new File(commandLine);
            }
            if (existingFile != null) {
                if (PlatformUtils.isWindows()) {
                    String ext1 = BrowserArb.getString(82);
                    String ext2 = BrowserArb.getString(83);
                    String ext3 = BrowserArb.getString(84);
                    String fileName = existingFile.getName().toLowerCase();
                    if (fileName.endsWith(ext1) || fileName.endsWith(ext2) || fileName.endsWith(ext3)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private int areAllBrowserPathFieldsCompleted(List<String> browserPathList) {
        for (int i = 0; i < browserPathList.size(); ++i) {
            String browserPath = browserPathList.get(i);
            if (!browserPath.trim().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private int isBrowserPathListValid(List<String> browserPathList) {
        for (int i = 0; i < browserPathList.size(); ++i) {
            String browserPath = browserPathList.get(i);
            if (this.isBrowserPathValid(browserPath)) continue;
            return i;
        }
        return -1;
    }

    private Integer[] isIconAssignmentValid(List<String> browserIconList) {
        ArrayList<Integer> indexesWithConflict = new ArrayList<Integer>();
        ArrayList<String> knownBrowserIconList = new ArrayList<String>();
        String browserIconWithConflict = null;
        for (int i = 0; i < browserIconList.size(); ++i) {
            String browserIcon = browserIconList.get(i);
            if (browserIconWithConflict == null) {
                if (knownBrowserIconList.contains(browserIcon)) {
                    indexesWithConflict.add(knownBrowserIconList.indexOf(browserIcon));
                    indexesWithConflict.add(i);
                    browserIconWithConflict = browserIcon;
                }
                knownBrowserIconList.add(browserIcon);
                continue;
            }
            if (!browserIconWithConflict.equals(browserIcon)) continue;
            indexesWithConflict.add(i);
        }
        return indexesWithConflict.toArray(new Integer[indexesWithConflict.size()]);
    }

    private class IconComboBoxItemRender
    extends DefaultListCellRenderer {
        IconComboBoxItemRender() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iconId = (String)value;
            Icon icon = BrowserOptions.getOracleIcon(iconId);
            return super.getListCellRendererComponent((JList<?>)list, icon, index, isSelected, cellHasFocus);
        }
    }

    private class BrowserDetailsEditHandler
    implements ItemListener,
    DocumentListener,
    ListSelectionListener {
        private boolean enabled = false;

        private BrowserDetailsEditHandler() {
        }

        public void handleTextFieldChange(JTextField source) {
            int columnIdx;
            if (BrowserOptionsPanel.this.browserNameTextfield == source) {
                columnIdx = 1;
            } else if (BrowserOptionsPanel.this.browserPathTextfield == source) {
                columnIdx = 2;
            } else if (BrowserOptionsPanel.this.browserParamTextfield == source) {
                columnIdx = 3;
            } else {
                return;
            }
            String text = source.getText();
            int rowIdx = BrowserOptionsPanel.this.browserTable.getSelectedRow();
            if (rowIdx >= 0) {
                BrowserOptionsPanel.this.browserTableModel.setValueAt(text, rowIdx, columnIdx);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (BrowserOptionsPanel.this.iconsCombo != e.getSource()) {
                return;
            }
            int columnIdx = 4;
            String text = (String)((JComboBox)e.getSource()).getSelectedItem();
            int rowIdx = BrowserOptionsPanel.this.browserTable.getSelectedRow();
            if (rowIdx >= 0) {
                BrowserOptionsPanel.this.browserTableModel.setValueAt(text, rowIdx, columnIdx);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.isEnabled()) {
                JTextField source = (JTextField)e.getDocument().getProperty(BrowserOptionsPanel.PARENT_TEXT_FIELD);
                this.handleTextFieldChange(source);
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(false);
            int selectedIdx = BrowserOptionsPanel.this.browserTable.getSelectedRow();
            if (BrowserOptionsPanel.this.browserTable.isEditing()) {
                BrowserOptionsPanel.this.browserTable.getCellEditor().stopCellEditing();
            }
            if (selectedIdx >= 0) {
                Vector data = BrowserOptionsPanel.this.browserTableModel.getFullRow(selectedIdx);
                BrowserOptionsPanel.this.browserNameTextfield.setText((String)data.get(1));
                BrowserOptionsPanel.this.browserPathTextfield.setText((String)data.get(2));
                BrowserOptionsPanel.this.browserParamTextfield.setText((String)data.get(3));
                BrowserOptionsPanel.this.iconsCombo.setSelectedItem(data.get(4));
                if (!BrowserOptionsPanel.this.iconsCombo.getSelectedItem().equals(data.get(4))) {
                    String genericIconId = BrowserOptions.BrowserIconId.GENERIC.toString();
                    BrowserOptionsPanel.this.iconsCombo.setSelectedItem(genericIconId);
                }
            } else {
                BrowserOptionsPanel.this.browserNameTextfield.setText("");
                BrowserOptionsPanel.this.browserPathTextfield.setText("");
                BrowserOptionsPanel.this.browserParamTextfield.setText("");
                BrowserOptionsPanel.this.iconsCombo.setSelectedIndex(0);
            }
            this.setEnabled(true);
        }
    }
}

