/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;

public class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final String NS_PROXY_AUTO_CONFIG_URL = "nbinst://org.netbeans.core/modules/ext/nsProxyAutoConfig.js";
    private static final Logger LOGGER = Logger.getLogger(ProxyAutoConfig.class.getName());
    private Invocable inv = null;
    private final RequestProcessor.Task initTask;
    private final URI pacURI;
    public static final String DIRECT = "DIRECT";

    public static synchronized ProxyAutoConfig get(String pacFile) {
        if (file2pac.get(pacFile) == null) {
            LOGGER.fine("Init ProxyAutoConfig for " + pacFile);
            ProxyAutoConfig instance = null;
            try {
                instance = new ProxyAutoConfig(pacFile);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ProxyAutoConfig.class.getName()).warning("Parsing " + pacFile + " to URI throws " + ex);
            }
            finally {
                file2pac.put(pacFile, instance);
            }
        }
        return file2pac.get(pacFile);
    }

    private ProxyAutoConfig(String pacURL) throws URISyntaxException {
        assert (file2pac.get(pacURL) == null) : "Only once object for " + pacURL + " must exist.";
        final String normPAC = this.normalizePAC(pacURL);
        this.pacURI = new URI(normPAC);
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                ProxyAutoConfig.this.initEngine(normPAC);
            }
        });
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine(String pacURL) {
        ScriptEngine eng;
        InputStream pacIS;
        try {
            pacIS = ProxyAutoConfig.downloadPAC(pacURL);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "InputStream for " + pacURL + " throws " + ex, ex);
            return;
        }
        if (pacIS == null) {
            return;
        }
        String utils = ProxyAutoConfig.downloadUtils();
        try {
            eng = ProxyAutoConfig.evalPAC(pacIS, utils);
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.FINE, "While constructing ProxyAutoConfig thrown " + ex, ex);
            return;
        }
        catch (ScriptException ex) {
            LOGGER.log(Level.FINE, "While constructing ProxyAutoConfig thrown " + ex, ex);
            return;
        }
        finally {
            if (pacIS != null) {
                try {
                    pacIS.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "While closing PAC input stream thrown " + ex, ex);
                }
            }
        }
        if (eng == null) {
            LOGGER.log(Level.WARNING, "JavaScript engine cannot be null");
            return;
        }
        this.inv = (Invocable)((Object)eng);
    }

    public List<Proxy> findProxyForURL(URI u) {
        assert (this.initTask != null) : "initTask has be to posted.";
        if (!this.initTask.isFinished()) {
            while (!this.initTask.isFinished()) {
                try {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).waitFinished(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINEST, ex.getMessage(), ex);
                }
            }
        }
        if (this.inv == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        Object proxies = null;
        try {
            proxies = this.inv.invokeFunction("FindProxyForURL", u.toString(), u.getHost());
        }
        catch (ScriptException ex) {
            LOGGER.log(Level.FINE, "While invoking FindProxyForURL(" + u + ", " + u.getHost() + " thrown " + ex, ex);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINE, "While invoking FindProxyForURL(" + u + ", " + u.getHost() + " thrown " + ex, ex);
        }
        List<Proxy> res = this.analyzeResult(u, proxies);
        if (res == null) {
            LOGGER.info("findProxyForURL(" + u + ") returns null.");
            res = Collections.emptyList();
        }
        LOGGER.fine("findProxyForURL(" + u + ") returns " + Arrays.asList(res));
        return res;
    }

    private static InputStream downloadPAC(String pacURL) throws IOException {
        InputStream is = null;
        URL url = null;
        try {
            url = new URL(pacURL);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, "Malformed " + pacURL, ex);
            return null;
        }
        URLConnection conn = url.openConnection(Proxy.NO_PROXY);
        is = conn.getInputStream();
        return is;
    }

    private static ScriptEngine evalPAC(InputStream is, String utils) throws FileNotFoundException, ScriptException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        InputStreamReader pacReader = new InputStreamReader(is);
        engine.eval(pacReader);
        engine.eval(utils);
        return engine;
    }

    private List<Proxy> analyzeResult(URI uri, Object proxiesString) {
        if (proxiesString == null) {
            LOGGER.fine("Null result for " + uri);
            return null;
        }
        String protocol = uri.getScheme();
        if (protocol == null) {
            return null;
        }
        Proxy.Type proxyType = "http".equals(protocol) || "https".equals(protocol) ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
        StringTokenizer st = new StringTokenizer(proxiesString.toString(), ";");
        LinkedList<Proxy> proxies = new LinkedList<Proxy>();
        while (st.hasMoreTokens()) {
            String proxy = st.nextToken();
            if (DIRECT.equals(proxy.trim())) {
                proxies.add(Proxy.NO_PROXY);
                continue;
            }
            String host = ProxyAutoConfig.getHost(proxy);
            Integer port = ProxyAutoConfig.getPort(proxy);
            if (host == null || port == null) continue;
            proxies.add(new Proxy(proxyType, new InetSocketAddress(host, (int)port)));
        }
        return proxies;
    }

    private static String getHost(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            LOGGER.info("No port in " + proxy);
            return null;
        }
        String host = proxy.substring(0, i);
        return ProxyAutoConfig.normalizeProxyHost(host);
    }

    private static Integer getPort(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            LOGGER.info("No port in " + proxy);
            return null;
        }
        String port = proxy.substring(i + 1);
        if (port.indexOf(47) >= 0) {
            port = port.substring(0, port.indexOf(47));
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadUtils() {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        FileObject fo = null;
        try {
            try {
                fo = URLMapper.findFileObject((URL)new URL(NS_PROXY_AUTO_CONFIG_URL));
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
            }
            reader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fo)));
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
        }
        try {
            String line = null;
            boolean doAppend = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("var pacUtils =")) {
                    doAppend = true;
                }
                if (!doAppend) continue;
                if (line.endsWith("+")) {
                    line = line.substring(0, line.length() - 1);
                }
                builder.append(line.replaceAll("\"", "").replaceAll("\\\\n", "").replaceAll("\\\\\\\\", "\\\\"));
                builder.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "While downloading nsProxyAutoConfig.js thrown " + ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, ex.getMessage(), ex);
                }
            }
        }
        return builder.toString();
    }

    private String normalizePAC(String pacURL) {
        int index = pacURL.indexOf("\n");
        if (index != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((index = pacURL.indexOf("\r")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((index = pacURL.indexOf(" ")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        return pacURL.trim();
    }

    public static String normalizeProxyHost(String proxyHost) {
        if (proxyHost.toLowerCase(Locale.US).startsWith("http://")) {
            return proxyHost.substring(7, proxyHost.length());
        }
        return proxyHost;
    }
}

