/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayOutputStream;
import java.util.Properties;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.SignatureProperties;
import oracle.security.digsig.Verifier;
import oracle.security.digsig.VerifierSPI;

class SPIVerifier
extends Verifier {
    private VerifierSPI spiVerifierImpl;

    SPIVerifier(KeyStoreWrapper pKeyStore, CertificateMapper pCertMapper, Properties pConfig, String providerClass) throws DigitalSignatureException {
        try {
            Class<?> c = Class.forName(providerClass);
            this.spiVerifierImpl = (VerifierSPI)c.newInstance();
            this.spiVerifierImpl.init(pKeyStore, pCertMapper, pConfig);
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Cannot load Verifier provider class " + providerClass + " " + e);
        }
    }

    @Override
    public void start() {
        this.spiVerifierImpl.engineStart();
    }

    @Override
    public boolean isAttached() throws DigitalSignatureException {
        return this.spiVerifierImpl.engineIsAttached();
    }

    @Override
    public int getSignatureFormat() throws DigitalSignatureException {
        return this.spiVerifierImpl.engineGetSignatureFormat();
    }

    @Override
    public SignatureProperties getSignatureProperties() throws DigitalSignatureException {
        return this.spiVerifierImpl.engineGetSignatureProperties();
    }

    @Override
    public void getDocument(ByteArrayOutputStream baos) throws DigitalSignatureException {
        this.spiVerifierImpl.engineGetDocument(baos);
    }

    @Override
    public void updateSignature(String SignatureData) throws DigitalSignatureException {
        this.spiVerifierImpl.engineUpdateSignature(SignatureData, 0, SignatureData.length());
    }

    @Override
    public void updateSignature(String SignatureData, int offset, int length) throws DigitalSignatureException {
        this.spiVerifierImpl.engineUpdateSignature(SignatureData, offset, length);
    }

    @Override
    public void update(byte document) throws DigitalSignatureException {
        byte[] doc = new byte[]{document};
        this.spiVerifierImpl.engineUpdate(doc, 0, 1);
    }

    @Override
    public void update(byte[] document) throws DigitalSignatureException {
        this.spiVerifierImpl.engineUpdate(document, 0, document.length);
    }

    @Override
    public void update(byte[] document, int offset, int length) throws DigitalSignatureException {
        this.spiVerifierImpl.engineUpdate(document, offset, length);
    }

    @Override
    public int getSignatureMode() {
        return this.spiVerifierImpl.engineGetSignatureMode();
    }

    @Override
    public String getErrorMsg() throws DigitalSignatureException {
        return this.spiVerifierImpl.engineGetErrorMsg();
    }

    @Override
    public boolean finish() throws DigitalSignatureException {
        return this.spiVerifierImpl.engineFinish();
    }
}

