/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import com.oracle.jrockit.jfr.DynamicEventToken;
import com.oracle.jrockit.jfr.DynamicValue;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import javax.management.InstanceNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

class QuickTraceRecording {
    static final int INIT_POOL_SIZE = 10240;
    static final int MAX_POOL_SIZE = 102400;
    private static final int FIELD_LOG_LEVEL_ID = 0;
    private static final int FIELD_LOGGER_NAME_ID = 1;
    private static final int FIELD_THREAD_ID = 2;
    private static final int FIELD_MESSAGE_ID = 3;
    private static final int FIELD_COMP_ID = 4;
    private static final int FIELD_ECID_ID = 5;
    private static final int FIELD_USER_ID = 6;
    private static final int FIELD_DC_ID = 7;
    private static final int FIELD_SRCCLASS_ID = 8;
    private static final int FIELD_SRCMETHOD_ID = 9;
    private static final int FIELD_APP_ID = 10;
    static final String COMPIDPOOL = "COMPIDPOOL";
    static final String LOGLEVELPOOL = "LOGLEVELPOOL";
    static final String LOGGERNAMEPOOL = "LOGGERNAMEPOOL";
    static final String CLASSNAMEPOOL = "CLASSNAMEPOOL";
    static final String METHODNAMEPOOL = "METHODNAMEPOOL";
    static final String APPNAMEPOOL = "APPNAMEPOOL";
    static final String THREADIDPOOL = "THREADIDPOOL";
    private static final String[] DEF_FIELDS = new String[]{"LOG_LEVEL", "LOGGER_NAME", "THREADID", "MESSAGE", "COMP_ID", "ECID", "USER_ID", "DC_ID", "SRC_CLASS", "SRC_METHOD", "APP"};
    private static final String RECORDING_NAME_PREFIX = "ODL";
    String name_;
    FlightRecorderClient recorder_ = new FlightRecorderClient();
    FlightRecordingClient recording_;
    DynamicEventToken[] evTokens_;
    boolean recordingStarted_;
    long duration_;
    long maxAge_;
    long maxSize_;
    Producer producer_;
    LinkedList<DynamicValue> fieldList_;
    DynamicValue[] std_flds;
    String[] suppAttrs_;
    byte[] lock_;

    QuickTraceRecording(String name, String handlerName, long duration, long maxAge, long maxSize, String[] suppAttrs) throws NoSuchRecordingException, InstanceNotFoundException, IOException {
        this.name_ = name == null ? handlerName : name + "-" + handlerName;
        this.duration_ = duration;
        this.maxAge_ = maxAge;
        this.maxSize_ = maxSize;
        this.suppAttrs_ = suppAttrs;
        this.recording_ = this.recorder_.createRecordingObject("ODL-" + name);
        this.recording_.setDuration(this.duration_);
        this.recording_.setMaxAge(this.maxAge_);
        this.recording_.setMaxSize(this.maxSize_);
        this.recordingStarted_ = false;
        this.lock_ = new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createDynamicEventTokens(boolean inclThreadInfo, boolean inclStacktrace) throws InvalidEventDefinitionException {
        byte[] byArray = this.lock_;
        synchronized (this.lock_) {
            this.evTokens_ = new DynamicEventToken[1];
            this.evTokens_[0] = this.producer_.createDynamicInstantEvent("ODL logging", "ODL JFR Logging Handler for " + this.name_, "odl/log/" + this.name_ + "/", inclThreadInfo, inclStacktrace, this.fieldList_.toArray(new DynamicValue[this.fieldList_.size()]));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    void initStandardFields() throws Exception {
        this.std_flds = new DynamicValue[DEF_FIELDS.length];
        this.std_flds[4] = new DynamicValue("Component ID", "Component ID", "Component ID", "http://www.oracle.com/odl/compid", COMPIDPOOL, String.class);
        this.std_flds[5] = new DynamicValue("ECID", "ECID", "The DMS execution context ID in placeat the time of the event.", "http://www.oracle.com/fmw/ECID", null, String.class);
        this.std_flds[6] = new DynamicValue("USERID", "USERID", "User ID", "http://www.oracle.com/fmw/userid", null, String.class);
        this.std_flds[7] = new DynamicValue("DCID", "DCID", "Downstream Context ID", "http://www.oracle.com/fmw/dcid", null, String.class);
        this.std_flds[8] = new DynamicValue("SRC_CLASS", "SRC_CLASS", "Name of the class", "http://www.oracle.com/odl/srcclass", CLASSNAMEPOOL, String.class);
        this.std_flds[9] = new DynamicValue("SRC_METHOD", "SRC_METHOD", "Name of the method", "http://www.oracle.com/odl/srcmethod", METHODNAMEPOOL, String.class);
        this.std_flds[10] = new DynamicValue("APP", "APP", "Application", "http://www.oracle.com/odl/app", APPNAMEPOOL, String.class);
        this.std_flds[0] = new DynamicValue("LogLevel", "LogLevel", "Log Level", "http://www.oracle.com/odl/loglevel", LOGLEVELPOOL, String.class);
        this.std_flds[1] = new DynamicValue("Logger", "Logger", "Name of the Logger", "http://www.oracle.com/odl/logger", LOGGERNAMEPOOL, String.class);
        this.std_flds[2] = new DynamicValue("ThreadID", "ThreadID", "Thread ID", "http://www.oracle.com/odl/threadId", THREADIDPOOL, String.class);
        this.std_flds[3] = new DynamicValue("LogMessage", "LogMessage", "Log message body", String.class);
        this.fieldList_ = new LinkedList();
        for (DynamicValue dynamicValue : this.std_flds) {
            this.fieldList_.add(dynamicValue);
        }
        for (String string : this.suppAttrs_) {
            DynamicValue dValue = new DynamicValue(string, string, string, "http://www.oracle.com/odl/" + string, null, String.class);
            this.fieldList_.add(dValue);
        }
    }

    void disableOtherEvents() throws NoSuchEventException {
        try {
            CompositeData[] events = null;
            for (CompositeData pd : this.recorder_.getProducers()) {
                for (CompositeData d : events = (CompositeData[])pd.get("events")) {
                    int id = (Integer)d.get("id");
                    this.recording_.setEventEnabled(id, false);
                }
            }
        }
        catch (OpenDataException odex) {
            Object var1_3 = null;
        }
    }

    void initProducer() throws Exception {
        this.producer_ = new Producer("ODL Producer-" + this.name_, "ODL Producer-" + this.name_, "http://www.oracle.com/odl/" + this.name_);
        this.producer_.createConstantPool(String.class, LOGGERNAMEPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, LOGLEVELPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, THREADIDPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, COMPIDPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, CLASSNAMEPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, METHODNAMEPOOL, 10240, 102400, true);
        this.producer_.createConstantPool(String.class, APPNAMEPOOL, 10240, 102400, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws NoSuchEventException {
        byte[] byArray = this.lock_;
        synchronized (this.lock_) {
            this.producer_.register();
            this.disableOtherEvents();
            this.recording_.start();
            this.recordingStarted_ = true;
            this.recordingStarted_ = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        byte[] byArray = this.lock_;
        synchronized (this.lock_) {
            if (this.recordingStarted_) {
                try {
                    this.recording_.stop();
                    this.recording_ = null;
                    this.recordingStarted_ = false;
                }
                catch (IOException e) {
                    this.recordingStarted_ = false;
                }
            }
            this.producer_.unregister();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstantEvent createInstantEvent() throws NoSuchEventException {
        InstantEvent event = null;
        byte[] byArray = this.lock_;
        synchronized (this.lock_) {
            event = this.evTokens_[0].newInstantEvent();
            this.recording_.setEventEnabled(event.getEventInfo().getId(), true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(File destination, boolean flushOnDump) {
        final String recPath = destination.getAbsolutePath();
        boolean discardRecording = flushOnDump;
        byte[] byArray = this.lock_;
        synchronized (this.lock_) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        QuickTraceRecording.this.recording_.stop();
                        QuickTraceRecording.this.recording_.copyTo(recPath);
                        QuickTraceRecording.this.recording_.close();
                        QuickTraceRecording.this.recording_ = QuickTraceRecording.this.recorder_.createRecordingObject("ODL-" + QuickTraceRecording.this.name_);
                        QuickTraceRecording.this.recording_.setDuration(QuickTraceRecording.this.duration_);
                        QuickTraceRecording.this.recording_.setMaxAge(QuickTraceRecording.this.maxAge_);
                        QuickTraceRecording.this.recording_.setMaxSize(QuickTraceRecording.this.maxSize_);
                        QuickTraceRecording.this.disableOtherEvents();
                        QuickTraceRecording.this.recording_.start();
                        QuickTraceRecording.this.recordingStarted_ = true;
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof PrivilegedActionException) {
                    t = ((PrivilegedActionException)e).getCause();
                }
                throw new RuntimeException(t);
            }
            return;
        }
    }
}

