/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.messages.Msgs;
import oracle.core.ojdl.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoggingConfigurationDocument
implements Cloneable {
    private Document m_document;
    private static final String IND1 = " ";
    private static final String IND2 = "  ";
    private static final String LSEP = System.getProperty("line.separator");

    public LoggingConfigurationDocument() throws ParserConfigurationException {
        DocumentBuilder docBuilder = this.getDocumentBuilder();
        this.m_document = docBuilder.newDocument();
        Element root = this.m_document.createElement("logging_configuration");
        this.m_document.appendChild(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingConfigurationDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = this.getDocumentBuilder();
        try {
            this.m_document = docBuilder.parse(in);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public LoggingConfigurationDocument(Document doc) {
        this.m_document = doc;
    }

    public void writeDocument(OutputStream out) throws IOException {
        this.writeDocument(out, null);
    }

    public LoggingConfigurationDocument clone() {
        LoggingConfigurationDocument cl;
        try {
            cl = (LoggingConfigurationDocument)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        cl.m_document = (Document)this.m_document.cloneNode(true);
        return cl;
    }

    public void merge(LoggingConfigurationDocument src) {
        LoggingConfigurationDocument dst = this;
        List<String> srcHandlers = src.getHandlerNames();
        List<String> dstHandlers = dst.getHandlerNames();
        for (String srcHandler : srcHandlers) {
            if (!dstHandlers.contains(srcHandler)) continue;
            throw new IllegalArgumentException(Msgs.get("ODL-52064", srcHandler));
        }
        List<String> srcLoggers = src.getLoggerNames();
        List<String> dstLoggers = dst.getLoggerNames();
        for (String srcLogger : srcLoggers) {
            for (String dstLogger : dstLoggers) {
                if (!dstLogger.startsWith(srcLogger)) continue;
                throw new IllegalArgumentException(Msgs.get("ODL-52065", srcLogger));
            }
        }
        for (String srcHandler : srcHandlers) {
            Properties props;
            String encoding;
            String formatter;
            String filter;
            String errorMgr;
            String className = src.getHandlerClass(srcHandler);
            dst.addHandler(srcHandler, className);
            String level = src.getHandlerLevel(srcHandler);
            if (level != null && level.length() > 0) {
                dst.setHandlerLevel(srcHandler, level);
            }
            if ((errorMgr = src.getHandlerErrorManager(srcHandler)) != null && errorMgr.length() > 0) {
                dst.setHandlerErrorManager(srcHandler, errorMgr);
            }
            if ((filter = src.getHandlerFilter(srcHandler)) != null && filter.length() > 0) {
                dst.setHandlerFilter(srcHandler, filter);
            }
            if ((formatter = src.getHandlerFormatter(srcHandler)) != null && formatter.length() > 0) {
                dst.setHandlerFormatter(srcHandler, formatter);
            }
            if ((encoding = src.getHandlerEncoding(srcHandler)) != null && encoding.length() > 0) {
                dst.setHandlerEncoding(srcHandler, encoding);
            }
            if ((props = src.getHandlerProperties(srcHandler)) == null || props.size() <= 0) continue;
            for (String p : props.stringPropertyNames()) {
                dst.setHandlerProperty(srcHandler, p, props.getProperty(p));
            }
        }
        for (String srcLogger : srcLoggers) {
            List<String> handlers;
            dst.addLogger(srcLogger);
            String level = src.getLoggerLevel(srcLogger);
            if (level != null && level.length() > 0) {
                dst.setLoggerLevel(srcLogger, level);
            }
            boolean uph = src.getLoggerUseParentHandlers(srcLogger);
            dst.setLoggerUseParentHandlers(srcLogger, uph);
            String filter = src.getLoggerFilter(srcLogger);
            if (filter != null && filter.length() > 0) {
                dst.setLoggerFilter(srcLogger, filter);
            }
            if ((handlers = src.getLoggerHandlers(srcLogger)) == null || handlers.size() <= 0) continue;
            for (String h : handlers) {
                dst.addHandlerToLogger(srcLogger, h);
            }
        }
    }

    public List<String> getLoggerNames() {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("loggers");
        ArrayList<String> list = new ArrayList<String>();
        if (nl.getLength() == 0) {
            return list;
        }
        Element loggers = (Element)nl.item(0);
        nl = loggers.getElementsByTagName("logger");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element logger = (Element)nl.item(i);
            list.add(logger.getAttribute("name"));
        }
        return list;
    }

    public boolean hasLogger(String loggerName) {
        return this.getLoggerElement(loggerName) != null;
    }

    public void addLogger(String loggerName) {
        if (this.getLoggerElement(loggerName) != null) {
            throw new IllegalArgumentException(Msgs.get("ODL-52054", loggerName));
        }
        this.addLoggerElement(loggerName);
    }

    public void removeLogger(String loggerName) {
        Element logger = this.getDefinedLogger(loggerName);
        this.removeElement(logger);
    }

    public String getLoggerLevel(String loggerName) {
        Element logger = this.getDefinedLogger(loggerName);
        return this.getAttribute(logger, "level", null);
    }

    public void setLoggerLevel(String loggerName, String levelName) {
        Element logger = this.getDefinedLogger(loggerName);
        this.checkLevel(levelName);
        if (levelName != null && levelName.length() > 0 && !"null".equalsIgnoreCase(levelName)) {
            logger.setAttribute("level", levelName);
        } else {
            logger.removeAttribute("level");
        }
    }

    public boolean getLoggerUseParentHandlers(String loggerName) {
        Element logger = this.getDefinedLogger(loggerName);
        return this.getAttribute(logger, "useParentHandlers", "true").equalsIgnoreCase("true");
    }

    public void setLoggerUseParentHandlers(String loggerName, boolean useParentHandlers) {
        Element logger = this.getDefinedLogger(loggerName);
        logger.setAttribute("useParentHandlers", Boolean.toString(useParentHandlers));
    }

    public String getLoggerFilter(String loggerName) {
        Element logger = this.getDefinedLogger(loggerName);
        return this.getAttribute(logger, "filter", null);
    }

    public void setLoggerFilter(String loggerName, String filterClass) {
        Element logger = this.getDefinedLogger(loggerName);
        if (filterClass != null && filterClass.length() > 0) {
            logger.setAttribute("filter", filterClass);
        } else {
            logger.removeAttribute("filter");
        }
    }

    public List<String> getLoggerHandlers(String loggerName) {
        Element logger = this.getDefinedLogger(loggerName);
        return this.getLoggerHandlers(logger);
    }

    public void addHandlerToLogger(String loggerName, String handlerName) {
        Element logger = this.getDefinedLogger(loggerName);
        Element handler = this.getDefinedHandler(handlerName);
        this.addHandlerToLogger(logger, handlerName);
    }

    public void removeHandlerFromLogger(String loggerName, String handlerName) {
        Element logger = this.getDefinedLogger(loggerName);
        this.removeHandlerFromLogger(logger, handlerName);
    }

    public boolean getAddJvmNumber() {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() == 1) {
            Element elem = (Element)nl.item(0);
            return "true".equalsIgnoreCase(elem.getAttribute("addJvmNumber"));
        }
        return false;
    }

    public void setAddJvmNumber(boolean addJvmNumber) {
        Element elem;
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() < 1) {
            elem = this.m_document.createElement("log_handlers");
            root.appendChild(elem);
        } else {
            elem = (Element)nl.item(0);
        }
        elem.setAttribute("addJvmNumber", Boolean.toString(addJvmNumber));
    }

    public List<String> getHandlerNames() {
        NodeList nl = this.getHandlerElements();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            ret.add(((Element)nl.item(i)).getAttribute("name"));
        }
        return ret;
    }

    public void addHandler(String handlerName, String handlerClass) {
        Element handler = this.getHandlerElement(handlerName);
        if (handler != null) {
            throw new IllegalArgumentException(Msgs.get("ODL-52055", handlerName));
        }
        this.addHandlerElement(handlerName, handlerClass);
    }

    public void removeHandler(String handlerName) {
        Element handlerEl = this.getDefinedHandler(handlerName);
        List<String> loggers = this.getLoggerNames();
        for (String logger : this.getLoggerNames()) {
            for (String handler : this.getLoggerHandlers(logger)) {
                if (!handlerName.equals(handler)) continue;
                throw new IllegalArgumentException(Msgs.get("ODL-52058", handlerName, logger));
            }
        }
        this.removeElement(handlerEl);
    }

    public String getHandlerClass(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "class");
    }

    public void setHandlerClass(String handlerName, String className) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "class", className);
    }

    public String getHandlerLevel(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "level");
    }

    public void setHandlerLevel(String handlerName, String levelName) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "level", levelName);
    }

    public String getHandlerErrorManager(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "errorManager");
    }

    public void setHandlerErrorManager(String handlerName, String errorManagerClass) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "errorManager", errorManagerClass);
    }

    public String getHandlerFilter(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "filter");
    }

    public void setHandlerFilter(String handlerName, String filterClass) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "filter", filterClass);
    }

    public String getHandlerFormatter(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "formatter");
    }

    public void setHandlerFormatter(String handlerName, String formatterClass) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "formatter", formatterClass);
    }

    public String getHandlerEncoding(String handlerName) throws IllegalArgumentException {
        return this.getHandlerAttribute(handlerName, "encoding");
    }

    public void setHandlerEncoding(String handlerName, String encoding) throws IllegalArgumentException {
        this.setHandlerAttribute(handlerName, "encoding", encoding);
    }

    public Properties getHandlerProperties(String handlerName) {
        Element handler = this.getDefinedHandler(handlerName);
        return this.getHandlerProperties(handler);
    }

    public void setHandlerProperty(String handlerName, String propertyName, String propertyValue) {
        Element handler = this.getDefinedHandler(handlerName);
        this.addHandlerProperty(handler, propertyName, propertyValue);
    }

    public void removeHandlerProperty(String handlerName, String propertyName) {
        Element handler = this.getDefinedHandler(handlerName);
        this.removeHandlerProperty(handler, propertyName);
    }

    public Properties getLoggingProperties() {
        Element lp = this.getLoggingPropertiesElement();
        if (lp == null) {
            return new Properties();
        }
        return this.getProperties(lp);
    }

    public void setLoggingProperty(String propertyName, String propertyValue) {
        Element lp = this.getLoggingPropertiesElement();
        if (lp == null) {
            lp = this.addLoggingPropertiesElement();
        }
        this.setProperty(lp, propertyName, propertyValue);
    }

    public void removeLoggingProperty(String propertyName) {
        Element p;
        Element lp = this.getLoggingPropertiesElement();
        if (lp != null && (p = this.getPropertyElement(lp, propertyName)) != null) {
            this.removeElement(p);
            return;
        }
        throw new IllegalArgumentException("Logging property not found: " + propertyName);
    }

    private Element getHandlerDefaultsElement() {
        Element handlers;
        NodeList nl2;
        Element result = null;
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() > 0 && (nl2 = (handlers = (Element)nl.item(0)).getElementsByTagName("default_properties")).getLength() > 0) {
            result = (Element)nl2.item(0);
        }
        return result;
    }

    private Element addHandlerDefaultsElement() {
        Element handlers;
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() > 0) {
            handlers = (Element)nl.item(0);
        } else {
            handlers = this.m_document.createElement("log_handlers");
            root.appendChild(handlers);
        }
        Element handlerDefaults = this.m_document.createElement("default_properties");
        handlers.appendChild(handlerDefaults);
        return handlerDefaults;
    }

    public Properties getHandlerDefaults() {
        Element handlerDefaults = this.getHandlerDefaultsElement();
        Properties properties = handlerDefaults != null ? this.getProperties(handlerDefaults) : new Properties();
        return properties;
    }

    public void setHandlerDefault(String propertyName, String propertyValue) {
        Element handlerDefaults = this.getHandlerDefaultsElement();
        if (handlerDefaults == null) {
            handlerDefaults = this.addHandlerDefaultsElement();
        }
        this.setProperty(handlerDefaults, propertyName, propertyValue);
    }

    public void removeHandlerDefault(String propertyName) {
        Element prop;
        Element handlerDefaults = this.getHandlerDefaultsElement();
        boolean found = false;
        if (handlerDefaults != null && (prop = this.getPropertyElement(handlerDefaults, propertyName)) != null) {
            found = true;
            handlerDefaults.removeChild(prop);
        }
        if (!found) {
            throw new IllegalArgumentException("Handler defaults do not include property " + propertyName);
        }
    }

    private void checkLevel(String levelName) {
        if (levelName != null && levelName.length() > 0) {
            ODLLevel.parse(levelName);
        }
    }

    private void checkHandlerAttribute(String attr) {
        if (!("class".equals(attr) || "level".equals(attr) || "errorManager".equals(attr) || "filter".equals(attr) || "formatter".equals(attr) || "encoding".equals(attr))) {
            throw new IllegalArgumentException("Invalid handler attribute name: " + attr);
        }
    }

    private String getHandlerAttribute(String handlerName, String attrName) throws IllegalArgumentException {
        Element handler = this.getDefinedHandler(handlerName);
        this.checkHandlerAttribute(attrName);
        return this.getHandlerAttribute(handler, attrName);
    }

    private void setHandlerAttribute(String handlerName, String attrName, String attrValue) throws IllegalArgumentException {
        Element handler = this.getDefinedHandler(handlerName);
        this.checkHandlerAttribute(attrName);
        if ("level".equals(attrName)) {
            this.checkLevel(attrValue);
        }
        this.setHandlerAttribute(handler, attrName, attrValue);
    }

    private Element getDefinedLogger(String loggerName) {
        Element logger = this.getLoggerElement(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException(Msgs.get("ODL-52056", loggerName));
        }
        return logger;
    }

    private Element getLoggerElement(String loggerName) {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("loggers");
        if (nl.getLength() == 0) {
            return null;
        }
        Element loggers = (Element)nl.item(0);
        NodeList nl2 = loggers.getElementsByTagName("logger");
        for (int i = 0; i < nl2.getLength(); ++i) {
            Element logger = (Element)nl2.item(i);
            String name = logger.getAttribute("name");
            if (!loggerName.equals(name)) continue;
            return logger;
        }
        return null;
    }

    private Element addLoggerElement(String loggerName) {
        Element loggers;
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("loggers");
        if (nl.getLength() > 0) {
            loggers = (Element)nl.item(0);
        } else {
            loggers = this.m_document.createElement("loggers");
            root.appendChild(loggers);
        }
        Element logger = this.m_document.createElement("logger");
        logger.setAttribute("name", loggerName);
        loggers.appendChild(logger);
        return logger;
    }

    private List<String> getLoggerHandlers(Element logger) {
        NodeList nl = logger.getElementsByTagName("handler");
        ArrayList<String> handlers = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            handlers.add(((Element)nl.item(i)).getAttribute("name"));
        }
        return handlers;
    }

    private void addHandlerToLogger(Element logger, String handlerName) {
        if (this.getLoggerHandlers(logger).contains(handlerName)) {
            throw new IllegalArgumentException(Msgs.get("ODL-52059", logger.getAttribute("name"), handlerName));
        }
        Element h = this.m_document.createElement("handler");
        h.setAttribute("name", handlerName);
        logger.appendChild(h);
    }

    private void removeHandlerFromLogger(Element logger, String handlerName) {
        NodeList nl = logger.getElementsByTagName("handler");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element h = (Element)nl.item(i);
            if (!handlerName.equals(h.getAttribute("name"))) continue;
            logger.removeChild(h);
            return;
        }
        throw new IllegalArgumentException(Msgs.get("ODL-52060", logger.getAttribute("name"), handlerName));
    }

    private NodeList getHandlerElements() {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() == 0) {
            return nl;
        }
        Element handlers = (Element)nl.item(0);
        return handlers.getElementsByTagName("log_handler");
    }

    private Element getDefinedHandler(String handlerName) {
        Element handler = this.getHandlerElement(handlerName);
        if (handler == null) {
            throw new IllegalArgumentException(Msgs.get("ODL-52057", handlerName));
        }
        return handler;
    }

    private Element getHandlerElement(String handlerName) {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() == 0) {
            return null;
        }
        Element handlers = (Element)nl.item(0);
        NodeList nl2 = handlers.getElementsByTagName("log_handler");
        for (int i = 0; i < nl2.getLength(); ++i) {
            Element handler = (Element)nl2.item(i);
            String name = handler.getAttribute("name");
            if (!handlerName.equals(name)) continue;
            return handler;
        }
        return null;
    }

    private Element addHandlerElement(String handlerName, String className) {
        Element handlers;
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() > 0) {
            handlers = (Element)nl.item(0);
        } else {
            handlers = this.m_document.createElement("log_handlers");
            root.appendChild(handlers);
        }
        Element handler = this.m_document.createElement("log_handler");
        handler.setAttribute("name", handlerName);
        handler.setAttribute("class", className);
        handlers.appendChild(handler);
        return handler;
    }

    private String getHandlerAttribute(Element handler, String attrName) {
        return handler.getAttribute(attrName);
    }

    private void setHandlerAttribute(Element handler, String attrName, String attrValue) {
        handler.setAttribute(attrName, attrValue);
    }

    private Element addHandlerProperty(Element handlerElement, String name, String value) {
        NodeList nl = handlerElement.getElementsByTagName("property");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element p = (Element)nl.item(i);
            if (!name.equals(p.getAttribute("name"))) continue;
            p.setAttribute("value", value);
            return p;
        }
        Element p = this.m_document.createElement("property");
        p.setAttribute("name", name);
        p.setAttribute("value", value);
        handlerElement.appendChild(p);
        return p;
    }

    private Properties getHandlerProperties(Element handler) {
        return this.getProperties(handler);
    }

    private void removeHandlerProperty(Element handler, String propertyName) {
        int i;
        Element[] props = this.getChildElements(handler, "property");
        ArrayList<Element> found = new ArrayList<Element>();
        for (i = 0; i < props.length; ++i) {
            if (!propertyName.equals(props[i].getAttribute("name"))) continue;
            found.add(props[i]);
        }
        if (found.size() == 0) {
            throw new IllegalArgumentException(Msgs.get("ODL-52061", handler.getAttribute("name"), propertyName));
        }
        for (i = 0; i < found.size(); ++i) {
            handler.removeChild((Node)found.get(i));
        }
    }

    private Element getLoggingPropertiesElement() {
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("logging_properties");
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private Element addLoggingPropertiesElement() {
        Element root = this.m_document.getDocumentElement();
        Element lp = this.m_document.createElement("logging_properties");
        root.appendChild(lp);
        return lp;
    }

    private Properties getProperties(Element parent) {
        Properties properties = new Properties();
        Element[] ps = this.getChildElements(parent, "property");
        for (int i = 0; i < ps.length; ++i) {
            properties.setProperty(ps[i].getAttribute("name"), ps[i].getAttribute("value"));
        }
        return properties;
    }

    private Element getPropertyElement(Element parent, String name) {
        Element[] ps = this.getChildElements(parent, "property");
        for (int i = 0; i < ps.length; ++i) {
            if (!name.equals(ps[i].getAttribute("name"))) continue;
            return ps[i];
        }
        return null;
    }

    private void setProperty(Element parent, String name, String value) {
        Element p = this.getPropertyElement(parent, name);
        if (p == null) {
            p = this.m_document.createElement("property");
            p.setAttribute("name", name);
            parent.appendChild(p);
        }
        p.setAttribute("value", value);
    }

    private void removeElement(Element element) {
        Node parent = element.getParentNode();
        parent.removeChild(element);
    }

    private String getAttribute(Element elem, String attrName, String defaultValue) {
        String v = elem.getAttribute(attrName);
        if (v == null || v.length() == 0) {
            return defaultValue;
        }
        return v;
    }

    private Element[] getChildElements(Element parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1) continue;
            list.add((Element)node);
        }
        return list.toArray(new Element[list.size()]);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setValidating(false);
        fact.setIgnoringElementContentWhitespace(false);
        return fact.newDocumentBuilder();
    }

    private void writeDocument(OutputStream out, String encoding) throws IOException {
        Element e;
        if (encoding == null) {
            encoding = this.m_document.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = this.m_document.getInputEncoding();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        PrintStream ps = new PrintStream(out, false, encoding);
        ps.println("<?xml version='1.0' encoding='" + encoding + "'?>");
        ps.println("<logging_configuration>");
        Element root = this.m_document.getDocumentElement();
        NodeList nl = root.getElementsByTagName("logging_properties");
        if (nl.getLength() > 0) {
            ps.println(" <logging_properties>");
            e = (Element)nl.item(0);
            this.writeProperties(ps, e.getElementsByTagName("property"), IND2);
            ps.println(" </logging_properties>");
        }
        ps.print(" <log_handlers");
        nl = root.getElementsByTagName("log_handlers");
        if (nl.getLength() > 0) {
            e = (Element)nl.item(0);
            if ("true".equalsIgnoreCase(e.getAttribute("addJvmNumber"))) {
                ps.print(" addJvmNumber='true'");
            }
            ps.println(">");
            this.writeHandlerDefaults(ps, e.getElementsByTagName("default_properties"), IND2);
            this.writeLogHandlers(ps, e.getElementsByTagName("log_handler"), IND2);
        } else {
            ps.println(">");
        }
        ps.println(" </log_handlers>");
        ps.println(" <loggers>");
        nl = root.getElementsByTagName("loggers");
        if (nl.getLength() > 0) {
            e = (Element)nl.item(0);
            this.writeLoggers(ps, e.getElementsByTagName("logger"), IND2);
        }
        ps.println(" </loggers>");
        ps.println("</logging_configuration>");
        out.close();
    }

    private void writeProperties(PrintStream ps, NodeList properties, String indent) {
        for (int i = 0; i < properties.getLength(); ++i) {
            Element p = (Element)properties.item(i);
            ps.print(indent + "<property");
            this.writeAttribute(ps, p, "name");
            this.writeAttribute(ps, p, "value");
            ps.println("/>");
        }
    }

    private void writeHandlerDefaults(PrintStream ps, NodeList handlerDefaults, String indent) {
        if (handlerDefaults != null && handlerDefaults.getLength() > 0) {
            ps.println(indent + "<default_properties>");
            Element defaultsElement = (Element)handlerDefaults.item(0);
            NodeList properties = defaultsElement.getElementsByTagName("property");
            if (properties != null) {
                this.writeProperties(ps, properties, indent + IND1);
            }
            ps.println(indent + "</default_properties>");
        }
    }

    private void writeLogHandlers(PrintStream ps, NodeList handlers, String indent) {
        for (int i = 0; i < handlers.getLength(); ++i) {
            Element h = (Element)handlers.item(i);
            ps.print(indent + "<log_handler");
            this.writeAttribute(ps, h, "name");
            this.writeAttribute(ps, h, "class");
            this.writeAttribute(ps, h, "level");
            this.writeAttribute(ps, h, "formatter");
            this.writeAttribute(ps, h, "filter");
            this.writeAttribute(ps, h, "errorManager");
            this.writeAttribute(ps, h, "encoding");
            NodeList properties = h.getElementsByTagName("property");
            if (properties.getLength() > 0) {
                ps.println(">");
                this.writeProperties(ps, properties, indent + IND1);
                ps.println(indent + "</log_handler>");
                continue;
            }
            ps.println("/>");
        }
    }

    private void writeLoggers(PrintStream ps, NodeList loggers, String indent) {
        for (int i = 0; i < loggers.getLength(); ++i) {
            Element l = (Element)loggers.item(i);
            ps.print(indent + "<logger");
            this.writeAttribute(ps, l, "name", true);
            this.writeAttribute(ps, l, "level");
            this.writeAttribute(ps, l, "useParentHandlers");
            this.writeAttribute(ps, l, "filter");
            NodeList handlers = l.getElementsByTagName("handler");
            if (handlers.getLength() > 0) {
                ps.println(">");
                for (int j = 0; j < handlers.getLength(); ++j) {
                    Element h = (Element)handlers.item(j);
                    ps.print(indent + IND1 + "<handler");
                    this.writeAttribute(ps, h, "name");
                    ps.println("/>");
                }
                ps.println(indent + "</logger>");
                continue;
            }
            ps.println("/>");
        }
    }

    private void writeAttribute(PrintStream ps, Element e, String attrName) {
        this.writeAttribute(ps, e, attrName, false);
    }

    private void writeAttribute(PrintStream ps, Element e, String attrName, boolean force) {
        String v = e.getAttribute(attrName);
        if (v != null && v.length() > 0) {
            StringBuffer sb = new StringBuffer(v.length());
            XMLUtil.escapeAttrChars(v, sb);
            ps.print(IND1 + attrName + "='" + sb.toString() + "'");
        } else if (force) {
            ps.print(IND1 + attrName + "=''");
        }
    }
}

