/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.weblogic;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.LogRecord;
import oracle.core.ojdl.logging.impl.MessageIdSupport;
import weblogic.logging.WLLogRecord;

class LogRecordMapper {
    private MessageIdSupport m_msgIdSupport = new MessageIdSupport();

    LogRecordMapper() {
    }

    public WLLogRecord toWLLogRecord(LogRecord rec) {
        Object[] args;
        String s = rec.getMessage();
        String msgText = null;
        String msgId = null;
        ResourceBundle bundle = rec.getResourceBundle();
        if (bundle != null) {
            try {
                msgText = bundle.getString(s);
                msgId = this.m_msgIdSupport.getMessageId(bundle, s);
            }
            catch (Exception e) {
                msgText = s;
            }
        } else {
            msgText = s;
        }
        if ((args = rec.getParameters()) != null && args.length > 0 && msgText != null && msgText.indexOf("{") >= 0) {
            try {
                msgText = MessageFormat.format(msgText, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        WLLogRecord wlRec = new WLLogRecord(rec.getLevel(), msgText);
        if (msgId != null) {
            wlRec.setId(msgId);
        }
        wlRec.setLoggerName(rec.getLoggerName());
        wlRec.setMillis(rec.getMillis());
        wlRec.setParameters(rec.getParameters());
        wlRec.setResourceBundle(rec.getResourceBundle());
        wlRec.setResourceBundleName(rec.getResourceBundleName());
        wlRec.setSequenceNumber(rec.getSequenceNumber());
        wlRec.setSourceClassName(rec.getSourceClassName());
        wlRec.setSourceMethodName(rec.getSourceMethodName());
        wlRec.setThreadID(rec.getThreadID());
        wlRec.setThrown(rec.getThrown());
        return wlRec;
    }
}

