/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.PackageEntry;
import oracle.jdeveloper.java.locator.URLClassLocator;
import oracle.jdeveloper.java.util.ClassFileCache;

public class JarURLClassLocator
extends URLClassLocator {
    private static boolean CACHE_RESOURCES;
    private static boolean SKIP_JARINDEX_TIMESTAMP;
    private boolean CACHE_RESOURCES_PER_JAR_ACCESS = CACHE_RESOURCES || System.getProperty("JARURLCLASSLOCATOR_CACHE_RESOURCES_PER_JAR_ACCESS") != null;
    private static volatile long _lastBuiltTime;
    private static final Map<JarURLClassLocator, Boolean> INSTANCES;
    private volatile Map<String, PackageEntry> _packageMap;
    private long _lastJarTimestamp = -1L;
    private final URL _jarFileURL;
    private Set<String> _resourceSuffixes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastBuiltTime() {
        ArrayList<JarURLClassLocator> instances;
        Map<JarURLClassLocator, Boolean> map = INSTANCES;
        synchronized (map) {
            instances = new ArrayList<JarURLClassLocator>(INSTANCES.keySet());
        }
        for (JarURLClassLocator instance : instances) {
            instance.buildIndex();
        }
        return _lastBuiltTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarURLClassLocator(URL jarURL, int classType) {
        super(jarURL, classType);
        this._jarFileURL = URLFactory.intern((URL)JarUtil.getJarFileURL((URL)jarURL));
        Map<JarURLClassLocator, Boolean> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(this, Boolean.TRUE);
        }
        if (this.CACHE_RESOURCES_PER_JAR_ACCESS) {
            this._resourceSuffixes = new HashSet<String>(9);
            this._resourceSuffixes.add(".cpx");
            this._resourceSuffixes.add(".dcx");
            this._resourceSuffixes.add(".jpx");
            this._resourceSuffixes.add(".rpx");
            this._resourceSuffixes.add(".sva");
            this._resourceSuffixes.add(".xcfg");
            this._resourceSuffixes.add(".xml");
            this._resourceSuffixes.add(".xsd");
            this._resourceSuffixes.add(".wsdl");
        } else {
            this._resourceSuffixes = Collections.emptySet();
        }
    }

    @Override
    public synchronized void buildIndex() {
        if (SKIP_JARINDEX_TIMESTAMP && this._packageMap != null) {
            return;
        }
        JarIndex jarIndex = this.getJarIndex();
        long timestamp = jarIndex.getTimestamp();
        if (this._packageMap == null || timestamp != this._lastJarTimestamp) {
            this.buildIndexImpl(jarIndex);
            this._lastJarTimestamp = timestamp;
            _lastBuiltTime = System.nanoTime();
        }
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            entry.getSubpackageNames(out);
        }
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                entry.getClasses(out);
            } else {
                entry.getTopLevelClasses(out);
            }
        }
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.buildIndex();
        for (PackageEntry entry : this._packageMap.values()) {
            String[] classNames;
            String packageName = entry._packageName;
            for (String className : classNames = entry.getClasses()) {
                if (className.indexOf(36) >= 0) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packageName);
                }
                if (!acceptName) continue;
                String fqName = JarURLClassLocator.buildFQName(packageName, className);
                out.add(fqName);
            }
        }
    }

    @Override
    protected Collection<String> getClassesDirectly() {
        return this.getAllClasses();
    }

    @Override
    protected Collection<URL> getResourcesDirectly(String name) {
        return this.getResourceURLs(name);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.buildIndex();
        for (String packagePrefix : this._packageMap.keySet()) {
            if (packagePrefix.length() <= 0 || filter != null && !filter.acceptPackageName(packagePrefix)) continue;
            out.add(packagePrefix);
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        int countCascades;
        this.buildIndex();
        String[] nameCascades = JarURLClassLocator.getNameCascades(fqClassName);
        String[] nameParts = JarURLClassLocator.getNameParts(fqClassName);
        int countParts = countCascades = nameCascades.length;
        String packagePrefix = countCascades > 1 ? nameCascades[countCascades - 2] : "";
        PackageEntry foundEntry = this.findPackage(packagePrefix);
        if (foundEntry == null) {
            return null;
        }
        String className = nameParts[countParts - 1];
        if (!foundEntry.containsClass(className)) {
            return null;
        }
        for (String suffix : this.isSourceTypeLocator() ? SOURCE_SUFFIXES : CLASS_SUFFIXES) {
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            boolean exists = true;
            String name = rootPrefix + entryPath;
            if (this._hasNonDefaultSuffixes) {
                exists = this.getJarIndex().exists(name);
            } else assert (this.getJarIndex().exists(name)) : "Class/Source doesn't exist but should exist: " + name;
            if (!exists) continue;
            return URLFactory.newJarURL((URL)rootURL, (String)entryPath);
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        if (this.isClassTypeLocator()) {
            int lastDot;
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            if ((lastDot = resourceName.lastIndexOf(46)) > 0 && this._resourceSuffixes.contains(resourceName.substring(lastDot))) {
                int countCascades;
                this.buildIndex();
                String fqResourceName = resourceName.substring(0, lastDot).replace('/', '.').replace('\\', '.');
                String[] nameCascades = JarURLClassLocator.getNameCascades(fqResourceName);
                String[] nameParts = JarURLClassLocator.getNameParts(fqResourceName);
                int countParts = countCascades = nameCascades.length;
                String packagePrefix = countCascades > 1 ? nameCascades[countCascades - 2] : "";
                PackageEntry foundEntry = this.findPackage(packagePrefix);
                if (foundEntry == null) {
                    return null;
                }
                String shortResourceName = nameParts[countParts - 1] + resourceName.substring(lastDot);
                if (foundEntry.containsClass(shortResourceName)) {
                    return URLFactory.newJarURL((URL)rootURL, (String)resourceName);
                }
            } else if (this.getJarIndex().exists(rootPrefix + resourceName)) {
                return URLFactory.newJarURL((URL)rootURL, (String)resourceName);
            }
        }
        return null;
    }

    private void buildIndexImpl(JarIndex jarIndex) {
        String[] entryList = jarIndex.getEntries();
        int numEntries = entryList.length;
        String rootPrefix = JarUtil.getJarEntry((URL)this.getRootURL());
        int rootLen = rootPrefix != null ? rootPrefix.length() : 0;
        HashMap<String, Collection<String>> packageToClassMap = new HashMap<String, Collection<String>>(numEntries);
        HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(numEntries);
        String defaultSuffix = (String)this._suffixes.iterator().next();
        for (int i = 0; i < numEntries; ++i) {
            String entry = entryList[i];
            if (rootLen > 0) {
                if (!entry.startsWith(rootPrefix)) continue;
                entry = entry.substring(rootLen);
            }
            if (entry.length() == 0 || !this.isMatchingFileType(entry)) continue;
            this.addClassToMaps(entry, packageToClassMap, packageToSubMap, defaultSuffix);
        }
        ArraySortedSet allKeys = new ArraySortedSet(100);
        allKeys.addAll(packageToClassMap.keySet());
        allKeys.addAll(packageToSubMap.keySet());
        HashMap<String, PackageEntry> finalPackageMap = new HashMap<String, PackageEntry>(allKeys.size());
        for (String packageName : allKeys) {
            Collection classes = (Collection)packageToClassMap.get(packageName);
            Collection subs = (Collection)packageToSubMap.get(packageName);
            if ((classes == null || classes.isEmpty()) && (subs == null || subs.isEmpty())) continue;
            finalPackageMap.put(packageName, new PackageEntry(packageName, classes, subs));
        }
        this._packageMap = finalPackageMap;
    }

    private void addClassToMaps(String classEntry, Map<String, Collection<String>> packageToClassMap, Map<String, Collection<String>> packageToSubMap, String defaultSuffix) {
        String className;
        int lastDot;
        int suffixDot = classEntry.lastIndexOf(46);
        if (suffixDot < 0) {
            return;
        }
        String fqName = classEntry.substring(0, suffixDot).replace('/', '.');
        String suffix = classEntry.substring(suffixDot);
        boolean isResourceSuffix = this._resourceSuffixes.contains(suffix);
        if (!isResourceSuffix && this._checkForDefaultSuffix && !this._hasNonDefaultSuffixes && !defaultSuffix.equals(suffix)) {
            this._hasNonDefaultSuffixes = true;
        }
        String packagePrefix = (lastDot = fqName.lastIndexOf(46)) != -1 ? fqName.substring(0, lastDot) : "";
        String string = className = lastDot != -1 ? fqName.substring(lastDot + 1) : fqName;
        if (isResourceSuffix) {
            className = className + suffix;
        }
        boolean existingPackage = true;
        ArraySortedSet classList = packageToClassMap.get(packagePrefix);
        if (classList == null) {
            classList = new ArraySortedSet(75);
            packageToClassMap.put(packagePrefix, (Collection<String>)classList);
            existingPackage = false;
        } else {
            className = new String(className);
        }
        classList.add(className);
        if (existingPackage) {
            return;
        }
        if (packagePrefix.length() == 0) {
            return;
        }
        JarURLClassLocator.fillPackagesInMaps(packagePrefix, packageToSubMap);
    }

    private static void fillPackagesInMaps(String packagePrefix, Map<String, Collection<String>> packageToSubMap) {
        String outer = "";
        int pos = 0;
        boolean done = false;
        while (!done) {
            int nextDot = packagePrefix.indexOf(46, pos);
            if (nextDot == -1) {
                done = true;
                nextDot = packagePrefix.length();
            }
            String sub = packagePrefix.substring(pos, nextDot);
            ArraySortedSet subList = packageToSubMap.get(outer);
            if (subList == null) {
                subList = new ArraySortedSet(20);
                packageToSubMap.put(outer, (Collection<String>)subList);
            }
            subList.add((String)sub);
            outer = packagePrefix.substring(0, nextDot);
            pos = nextDot + 1;
        }
    }

    private PackageEntry findPackage(String packageName) {
        this.buildIndex();
        return this._packageMap.get(packageName);
    }

    private JarIndex getJarIndex() {
        return JarIndex.getInstance((URL)this._jarFileURL, (boolean)false);
    }

    @Override
    protected Object getClasspathTreeNode() {
        return this._jarFileURL;
    }

    @Override
    public String getModuleNameOfClass(String fqClassName) {
        if (!this.getContainsModuleClasses()) {
            return null;
        }
        URL classURL = this.getClassURL(fqClassName);
        if (classURL != null) {
            ClassFile classFile;
            classURL = this.getClassURL("module-info");
            ClassFile classFile2 = classFile = classURL != null ? ClassFileCache.getClassFile(classURL) : null;
            if (classFile != null) {
                return classFile.getModuleName();
            }
            return URLFileSystem.getName((URL)this._jarFileURL);
        }
        return null;
    }

    @Override
    protected boolean isMatchingFileType(String filename) {
        if (super.isMatchingFileType(filename)) {
            return true;
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex <= 0) {
            return false;
        }
        return this._resourceSuffixes.contains(filename.substring(dotIndex));
    }

    static {
        SKIP_JARINDEX_TIMESTAMP = CACHE_RESOURCES = System.getProperty("ASSUME_IMMUTABLE_CLASSPATH_JARS") != null;
        _lastBuiltTime = -1L;
        INSTANCES = new WeakHashMap<JarURLClassLocator, Boolean>();
    }
}

