/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;

public final class SourceElementAsList {
    private SourceElementAsList() {
    }

    public static List<SourceElement> asList(SourceElement root) {
        ArrayList<SourceElement> list = new ArrayList<SourceElement>();
        SourceElementAsList.asList(root, list);
        return list;
    }

    private static void asList(SourceElement parent, List<SourceElement> list) {
        list.add(parent);
        List children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SourceElement child = (SourceElement)children.get(i);
            SourceElementAsList.asList(child, list);
        }
    }

    public static List<SourceElement> asList(SourceElement root, Class elementClass) {
        ArrayList<SourceElement> arrayList = new ArrayList<SourceElement>();
        SourceElementAsList.asList(root, arrayList, elementClass);
        return arrayList;
    }

    private static void asList(SourceElement parent, List<SourceElement> arrayList, Class elementClass) {
        if (elementClass.isAssignableFrom(parent.getClass())) {
            arrayList.add(parent);
        }
        List children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SourceElement child = (SourceElement)children.get(i);
            SourceElementAsList.asList(child, arrayList, elementClass);
        }
    }

    public static List<SourceElement> asList(SourceElement root, int symbolKind) {
        ArrayList<SourceElement> list = new ArrayList<SourceElement>();
        SourceElementAsList.asList(root, list, new int[]{symbolKind});
        return list;
    }

    public static List<SourceElement> asList(SourceElement root, int[] symbolKinds) {
        ArrayList<SourceElement> list = new ArrayList<SourceElement>();
        SourceElementAsList.asList(root, list, symbolKinds);
        return list;
    }

    private static void asList(SourceElement parent, List<SourceElement> list, int[] symbolKinds) {
        int parentKind = parent.getSymbolKind();
        for (int i = 0; i < symbolKinds.length; ++i) {
            int symbolKind = symbolKinds[i];
            if (parentKind != symbolKind) continue;
            list.add(parent);
            break;
        }
        List children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SourceElement child = (SourceElement)children.get(i);
            SourceElementAsList.asList(child, list, symbolKinds);
        }
    }

    public static List<SourceElement> filterNamedElements(List<SourceElement> list, String name) {
        ArrayList<SourceElement> ret = new ArrayList<SourceElement>();
        for (SourceElement sourceElement : list) {
            SourceHasName sourceHasName;
            if (!(sourceElement instanceof SourceHasName) || !name.equals((sourceHasName = (SourceHasName)sourceElement).getName())) continue;
            ret.add((SourceElement)sourceHasName);
        }
        return ret;
    }

    public static List<SourceElement> filterByClass(List<SourceElement> list, Class elementClass) {
        ArrayList<SourceElement> ret = new ArrayList<SourceElement>();
        for (SourceElement sourceElement : list) {
            if (!elementClass.isAssignableFrom(sourceElement.getClass())) continue;
            ret.add(sourceElement);
        }
        return ret;
    }

    public static List<SourceElement> filterBySymbolKind(List<SourceElement> list, int symbolKind) {
        ArrayList<SourceElement> ret = new ArrayList<SourceElement>();
        for (SourceElement sourceElement : list) {
            if (sourceElement.getSymbolKind() != symbolKind) continue;
            ret.add(sourceElement);
        }
        return ret;
    }
}

