/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

class KeyValuesColor
extends KeyValues<Color> {
    public KeyValuesColor(Color ... colorArray) {
        super(colorArray);
        for (Color color : colorArray) {
            this.values.add(color);
        }
    }

    @Override
    public Class<?> getType() {
        return Color.class;
    }

    @Override
    public void setValue(Object object, Method method, int n, int n2, float f) {
        Color color;
        Color color2 = (Color)this.values.get(n);
        if (color2 == null) {
            color2 = (Color)this.startValue;
        }
        if (n == n2) {
            color = color2;
        } else {
            Color color3 = color2;
            Color color4 = (Color)this.values.get(n2);
            int n3 = (int)((double)((float)color3.getRed() + (float)(color4.getRed() - color3.getRed()) * f) + 0.5);
            int n4 = (int)((double)((float)color3.getGreen() + (float)(color4.getGreen() - color3.getGreen()) * f) + 0.5);
            int n5 = (int)((double)((float)color3.getBlue() + (float)(color4.getBlue() - color3.getBlue()) * f) + 0.5);
            int n6 = (int)((double)((float)color3.getAlpha() + (float)(color4.getAlpha() - color3.getAlpha()) * f) + 0.5);
            color = new Color(n3, n4, n5, n6);
        }
        try {
            method.invoke(object, color);
        }
        catch (Exception exception) {
            System.out.println("Problem invoking method in KVColor.setValue:" + exception);
        }
    }

    @Override
    public void setValue(Object object, Method method, int n) {
        try {
            method.invoke(object, this.values.get(n));
        }
        catch (Exception exception) {
            System.out.println("Problem invoking method in KVColor.setValue:" + exception);
        }
    }
}

