/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SQLExpressionBuilderPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class SourcesPanel
extends AbstractPanel<AbstractNode> {
    private SQLExpressionBuilderPanel _parent;
    private SQLContext _context;
    private JLabel jMessageLabel;
    private JTextPane jMessageTextPane;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private JTree jSourcesTree;

    public SourcesPanel(SQLExpressionBuilderPanel sQLExpressionBuilderPanel, SQLContext sQLContext) {
        super(sQLContext.getContext(), sQLContext.getNode());
        this._parent = sQLExpressionBuilderPanel;
        this._context = sQLContext;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMessageLabel, (Component)this.jMessageTextPane, (String)DialogsLrb.get("SQLQUERY_SOURCE_MESSAGE"));
    }

    @Override
    public void initUI() {
        this.loadAttributeList();
        this.jSourcesTree.setTransferHandler(new FromTransferHandler());
        this.jSourcesTree.setDragEnabled(true);
        this.jMessageTextPane.setEditable(false);
    }

    public Vector getSourceAttributeNames() {
        Vector<String> vector = new Vector<String>();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.jSourcesTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            vector.add(defaultMutableTreeNode2.getUserObject().toString());
        }
        return vector;
    }

    private void loadAttributeList() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        this.jSourcesTree.setCellRenderer(defaultTreeCellRenderer);
        this.jSourcesTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(DialogsLrb.get("SQLQUERY_LOADING"))));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jSourcesTree = new JTree();
        this.jScrollPane1 = new JScrollPane();
        this.jMessageTextPane = new JTextPane();
        this.jMessageLabel = new JLabel();
        this.jSourcesTree.setAutoscrolls(true);
        this.jSourcesTree.setDragEnabled(true);
        this.jSourcesTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SourcesPanel.this.jSourcesTreeMousePressed(mouseEvent);
            }
        });
        this.jSourcesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SourcesPanel.this.jSourcesTreeValueChanged(treeSelectionEvent);
            }
        });
        this.jSourcesTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SourcesPanel.this.jSourcesTreeKeyPressed(keyEvent);
            }
        });
        this.jScrollPane.setViewportView(this.jSourcesTree);
        this.jScrollPane1.setViewportView(this.jMessageTextPane);
        this.jMessageLabel.setText("Message:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jScrollPane, -1, 320, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMessageLabel).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane, -1, 384, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 30, -2)));
    }

    private void jSourcesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.jSourcesTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof UserObject) {
            UserObject userObject = (UserObject)object;
            this.jMessageTextPane.setText(userObject.toMessageString());
        } else {
            this.jMessageTextPane.setText("");
        }
    }

    private void jSourcesTreeKeyPressed(KeyEvent keyEvent) {
        TreePath treePath;
        if (keyEvent.getKeyCode() == 10 && (treePath = this.jSourcesTree.getSelectionPath()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof UserObject) {
                UserObject userObject = (UserObject)object;
                this._parent.insertSQLExpression(userObject.toSQLString());
            }
            keyEvent.consume();
        }
    }

    private void jSourcesTreeMousePressed(MouseEvent mouseEvent) {
        int n = this.jSourcesTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.jSourcesTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && mouseEvent.getClickCount() == 2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof UserObject) {
                UserObject userObject = (UserObject)object;
                this._parent.insertSQLExpression(userObject.toSQLString());
            }
            mouseEvent.consume();
        }
    }

    class FromTransferHandler
    extends TransferHandler {
        FromTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            int[] nArray = SourcesPanel.this.jSourcesTree.getSelectionRows();
            Arrays.sort(nArray);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                TreePath treePath = SourcesPanel.this.jSourcesTree.getPathForRow(nArray[i]);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof UserObject)) continue;
                UserObject userObject = (UserObject)object;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",\n");
                }
                stringBuilder.append(userObject.toSQLString());
            }
            return new StringSelection(stringBuilder.toString());
        }
    }

    private static class UserObject {
        Vector _columnInfo;

        UserObject(Vector vector) {
            this._columnInfo = vector;
        }

        public String toString() {
            return this._columnInfo.get(0).toString();
        }

        public String getOwner() {
            return this._columnInfo.get(1) != null ? this._columnInfo.get(1).toString() : null;
        }

        public String getObjectType() {
            return this._columnInfo.get(2).toString();
        }

        public String toMessageString() {
            return this._columnInfo.get(3).toString();
        }

        public String toSQLString() {
            String string = null;
            string = this.getOwner() == null ? "\"" + this.toString() + "\"" : "\"" + this.getOwner() + "\".\"" + this.toString() + "\"";
            return string;
        }
    }

    private class LoadUI
    extends SwingWorker<DefaultTreeModel, Void> {
        private LoadUI() {
        }

        @Override
        protected DefaultTreeModel doInBackground() throws Exception {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(SourcesPanel.this._context.isExpressionOnly() ? "Node" : "Nodes");
            for (AbstractNode abstractNode : SourcesPanel.this._context.getSourceNodes()) {
                Object object;
                List<RefModelType> list;
                Object object2;
                if (!(abstractNode instanceof DataProvider) && !(abstractNode instanceof ModelProvider)) continue;
                Vector<Object> vector = null;
                String string = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (!SourcesPanel.this._context.isExpressionOnly()) {
                    vector = new Vector<Object>(4);
                    object2 = abstractNode.getData().getName();
                    string = abstractNode.getData().getName();
                    if (abstractNode instanceof DataProvider) {
                        string = abstractNode.getAliasName();
                    }
                    vector.add(string);
                    vector.add(null);
                    vector.add(abstractNode.getDefaultName());
                    if (((String)object2).compareTo(string) != 0) {
                        vector.add(DialogsLrb.get("SQLQUERY_SOURCE_NODE_NAME") + " " + (String)object2 + "\n" + DialogsLrb.get("SQLQUERY_SOURCE_NODE_TYPE") + " " + abstractNode.getDefaultName());
                    } else {
                        vector.add(DialogsLrb.get("SQLQUERY_SOURCE_NODE_TYPE") + " " + abstractNode.getDefaultName());
                    }
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                    defaultMutableTreeNode2.setUserObject(new UserObject(vector));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                if (abstractNode instanceof DataProvider) {
                    object2 = (DataProvider)((Object)abstractNode);
                    list = object2.getAttributes().getAttribute();
                    Collections.sort(list, AttributeTypeComparator.getComparator());
                    for (RefModelType refModelType : list) {
                        vector = new Vector(4);
                        string = refModelType.getAlias() != null && !refModelType.getAlias().trim().isEmpty() ? refModelType.getAlias() : refModelType.getName();
                        vector.add(string);
                        vector.add(SourcesPanel.this._context.isExpressionOnly() ? null : abstractNode.getAliasName());
                        vector.add(refModelType.getDataType());
                        vector.add(DialogsLrb.get("SQLQUERY_SOURCE_DATA_TYPE") + " " + DatabaseMetadataUtils.getJSONDataType(refModelType.getDataType(), refModelType.getDataTypeQualifier()));
                        object = new DefaultMutableTreeNode(string);
                        ((DefaultMutableTreeNode)object).setUserObject(new UserObject(vector));
                        if (defaultMutableTreeNode2 == null) {
                            defaultMutableTreeNode.add((MutableTreeNode)object);
                            continue;
                        }
                        defaultMutableTreeNode2.add((MutableTreeNode)object);
                    }
                    continue;
                }
                if (!(abstractNode instanceof ModelProvider)) continue;
                object2 = (ModelProvider)((Object)abstractNode);
                list = object2.getOutputModels();
                for (RefModelType refModelType : list) {
                    vector = new Vector(4);
                    string = refModelType.getName();
                    vector.add(string);
                    vector.add(refModelType.getSchema());
                    object = ServerConstants.MiningFunction.getUIFunctionName((String)refModelType.getMiningFunction().name());
                    String string2 = ServerConstants.Algorithm.getUIAlgorithmName((String)refModelType.getMiningAlgorithm().name());
                    String string3 = (String)object + " - " + string2;
                    vector.add(string3);
                    vector.add(DialogsLrb.get("SQLQUERY_SOURCE_MODEL_TYPE") + " " + string3);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string);
                    defaultMutableTreeNode3.setUserObject(new UserObject(vector));
                    if (defaultMutableTreeNode2 == null) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode3);
                        continue;
                    }
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
            }
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            return defaultTreeModel;
        }

        @Override
        protected void done() {
            try {
                SourcesPanel.this.jSourcesTree.setModel((TreeModel)this.get());
            }
            catch (InterruptedException | ExecutionException exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
        }
    }
}

