/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.partition.AbstractPartitionToolbar;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.HyperlinkButton;

public class ModelViewerPartitionToolbar
extends AbstractPartitionToolbar<ModelViewerPartitionToolbar> {
    private static final Map<String, AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar>> TOOLBAR_MAP = new HashMap<String, AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar>>();
    private JPanel container;
    private JPanel jPanel1;
    private HyperlinkButton jPartitionHyperlink;
    private JLabel jPartitionLabel;
    private JButton jSearchPartitionButton;

    public ModelViewerPartitionToolbar() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        this.jSearchPartitionButton.setIcon(OracleIcons.getIcon((String)"search.png"));
        ResourceUtils.resLabel((JLabel)this.jPartitionLabel, (Component)this.jPartitionHyperlink, (String)PartitionsLrb.get("TOOLBAR_COMPARE_PARTITION"));
    }

    private void initUI() {
        this.jSearchPartitionButton.addActionListener(new AbstractPartitionToolbar.SearchPartitionActionListener(this));
        this.jPartitionHyperlink.addActionListener((ActionListener)new AbstractPartitionToolbar.PartitionDetailsActionListener(this));
        this.partitionLink = this.jPartitionHyperlink;
    }

    @Override
    protected void initVirtualInstance() {
        String string = this.node.getLongLabel();
        AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar> virtualInstance = TOOLBAR_MAP.get(string);
        if (virtualInstance != null) {
            this.setVirtualInstance(virtualInstance);
        } else {
            TOOLBAR_MAP.put(string, this.getVirtualInstance());
        }
    }

    @Override
    protected void initModelInformation() {
        if (this.node.getRepositoryData() instanceof ModelNodeType.Models.Model) {
            ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)this.node.getRepositoryData();
            this.getVirtualInstance().setModelName(model.getName());
            this.getVirtualInstance().setModelSchema(model.getSchema());
        } else if (this.node.getRepositoryData() instanceof ModelType) {
            ModelType modelType = (ModelType)this.node.getRepositoryData();
            this.getVirtualInstance().setModelSchema(((ModelNode)((Object)this.node)).getSchema());
            this.getVirtualInstance().setModelName(modelType.getName());
        } else if (this.node.getRepositoryData() instanceof TestModelType.Model) {
            TestModelType.Model model = (TestModelType.Model)this.node.getRepositoryData();
            this.getVirtualInstance().setModelName(model.getName());
            this.getVirtualInstance().setModelSchema(model.getSchema());
        }
    }

    @Override
    protected void showToolbar(List<PartitionVO> list) {
        this.checkPartition(list);
        this.getVirtualInstance().setNode(this.node);
        this.getVirtualInstance().getRelatedToolbars().add(this);
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }

    private void checkPartition(List<PartitionVO> list) {
        boolean bl;
        PartitionVO partitionVO = this.getVirtualInstance().getPartition();
        boolean bl2 = bl = !list.contains(partitionVO);
        if (bl) {
            PartitionVO partitionVO2 = list.get(0);
            this.getVirtualInstance().setPartition(partitionVO2, false);
        }
        SwingUtilities.invokeLater(() -> this.updatePartitionHyperlink());
    }

    public PartitionVO getPartitionVO() {
        PartitionVO partitionVO = this.getVirtualInstance().getPartition();
        if (partitionVO == null) {
            partitionVO = PartitionVO.createEmpty();
        }
        return partitionVO;
    }

    @Override
    protected int getComponentsWidth() {
        if (this.componentsWidth == -1) {
            String string = this.jPartitionLabel.getText();
            int n = this.jPartitionLabel.getFontMetrics(this.jPartitionLabel.getFont()).stringWidth(string);
            this.componentsWidth = n + this.jSearchPartitionButton.getPreferredSize().width;
        }
        return this.componentsWidth;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPartitionLabel = new JLabel();
        this.container = new JPanel();
        this.jPartitionHyperlink = new HyperlinkButton();
        this.jSearchPartitionButton = new JButton();
        this.setMaximumSize(new Dimension(400, 30));
        this.setPreferredSize(new Dimension(170, 30));
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        flowLayout.setAlignOnBaseline(true);
        this.jPanel1.setLayout(flowLayout);
        this.jPartitionLabel.setText("Partition:");
        this.jPartitionLabel.setPreferredSize(new Dimension(51, 25));
        this.jPanel1.add(this.jPartitionLabel);
        FlowLayout flowLayout2 = new FlowLayout(0, 5, 0);
        flowLayout2.setAlignOnBaseline(true);
        this.container.setLayout(flowLayout2);
        this.jPartitionHyperlink.setText("None");
        this.jPartitionHyperlink.setAlwaysUnderlined(true);
        this.jPartitionHyperlink.setHorizontalTextPosition(2);
        this.jPartitionHyperlink.setIconTextGap(0);
        this.jPartitionHyperlink.setMaximumSize(new Dimension(100, 23));
        this.jPartitionHyperlink.setPreferredSize(new Dimension(35, 25));
        this.container.add((Component)this.jPartitionHyperlink);
        this.jSearchPartitionButton.setIconTextGap(2);
        this.jSearchPartitionButton.setPreferredSize(new Dimension(30, 30));
        this.container.add(this.jSearchPartitionButton);
        this.jPanel1.add(this.container);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel1, -1, 170, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
    }

    public static void setSelectedPartitionForModel(String string, PartitionVO partitionVO) {
        AbstractPartitionToolbar.VirtualInstance<ModelViewerPartitionToolbar> virtualInstance = TOOLBAR_MAP.get(string);
        if (virtualInstance != null) {
            virtualInstance.setPartition(partitionVO, true);
        } else {
            virtualInstance = new AbstractPartitionToolbar.VirtualInstance(null, partitionVO, null);
            TOOLBAR_MAP.put(string, virtualInstance);
        }
    }
}

