/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARObjectAbstractFormatter;
import oracle.dmt.dataminer.utils.ClipboardUtils;

public class ARObjectDetailsExporter<O> {
    private List<O> objects;
    private ARObjectAbstractFormatter<O> formatter;

    public ARObjectDetailsExporter(List<O> list, ARObjectAbstractFormatter<O> aRObjectAbstractFormatter) {
        this.objects = list;
        this.formatter = aRObjectAbstractFormatter;
    }

    public void exportToFile(File file) {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(this.getHtml(this.objects, this.formatter));
        }
        catch (IOException iOException) {
            throw new DataMinerException(iOException);
        }
    }

    public void exportToClipboard() {
        String string = this.getHtml(this.objects, this.formatter);
        ClipboardUtils clipboardUtils = new ClipboardUtils(string);
        clipboardUtils.setContentToClipboard();
    }

    private String getHtml(List<O> list, ARObjectAbstractFormatter<O> aRObjectAbstractFormatter) {
        return aRObjectAbstractFormatter.formatAll(list);
    }
}

