/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARItemSetAbstractFormatter;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.Formats;

public class ARItemSetAggregateFormatter
extends ARItemSetAbstractFormatter {
    private String ruleHTMLTemplate = FileHelper.loadFile("/oracle/dmt/dataminer/mviewer/res/ARItemsetAggregateTemplate.html");
    private ARPreferences preferences = ARPreferences.getInstance();
    private NumberFormat formatter;
    private boolean showAverage;
    private List<String> aggregates;

    @Override
    protected String formatBody(ItemSet itemSet) {
        this.initVariables(itemSet);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AGGREGATE_METRICS", ARRulesLrb.get("METRIC_DETAILS_AGGREGATES"));
        hashMap.put("TABLE_HEAD", this.createHeader());
        hashMap.put("TABLE_BODY", this.createBody(itemSet));
        String string = StringUtils.getReplacedString((String)this.ruleHTMLTemplate, hashMap);
        return string;
    }

    private void initVariables(ItemSet itemSet) {
        this.formatter = Formats.ModelViewer.getNumeric();
        this.showAverage = this.preferences.getShowAverageMetricDetailsColumn();
        this.aggregates = ((Item)itemSet.getItems().get(0)).getAggregateNames();
    }

    private String createHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<th>");
        stringBuilder.append(CoreCommonLrb.get((String)"LEVEL"));
        stringBuilder.append("</th><th>");
        stringBuilder.append(CoreCommonLrb.get((String)"ITEM"));
        stringBuilder.append("</th>");
        for (String string : this.aggregates) {
            stringBuilder.append("<th>");
            stringBuilder.append(string);
            stringBuilder.append("</th>");
        }
        if (this.showAverage) {
            for (String string : this.aggregates) {
                stringBuilder.append("<th>");
                stringBuilder.append(string);
                stringBuilder.append("_AVG</th>");
            }
        }
        return stringBuilder.toString();
    }

    private String createBody(ItemSet itemSet) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        this.appendItemSetLevelRow(stringBuilder, itemSet);
        this.appendItemLevelRows(stringBuilder, itemSet);
        return stringBuilder.toString();
    }

    private void appendItemSetLevelRow(StringBuilder stringBuilder, ItemSet itemSet) {
        stringBuilder.append("<tr class='trEven'><td>");
        stringBuilder.append(ARLrb.get((String)"ITEMSET"));
        stringBuilder.append("</td><td></td>");
        for (String string : this.aggregates) {
            this.addCellTextTo(stringBuilder, itemSet, string, false);
        }
        if (this.showAverage) {
            for (String string : this.aggregates) {
                this.addCellTextTo(stringBuilder, itemSet, string, true);
            }
        }
        stringBuilder.append("</tr>");
    }

    private void appendItemLevelRows(StringBuilder stringBuilder, ItemSet itemSet) {
        int n = 0;
        for (Item item : itemSet.getItems()) {
            if (++n % 2 == 0) {
                stringBuilder.append("<tr class='trEven'>");
            } else {
                stringBuilder.append("<tr class='trOdd'>");
            }
            stringBuilder.append("<td>");
            stringBuilder.append(ARLrb.get((String)"ITEMSET"));
            stringBuilder.append("</td><td>");
            stringBuilder.append(item.getFullAttributeName());
            stringBuilder.append("</td>");
            for (String string : this.aggregates) {
                this.addCellTextTo(stringBuilder, item.getAggregate(string));
            }
            if (this.showAverage) {
                for (String string : this.aggregates) {
                    this.addCellTextTo(stringBuilder, item.getAggregateAvg(string));
                }
            }
            stringBuilder.append("</tr>");
        }
    }

    private void addCellTextTo(StringBuilder stringBuilder, ItemSet itemSet, String string, boolean bl) {
        stringBuilder.append("<td align='right'>");
        Double d = 0.0;
        for (Item item : itemSet.getItems()) {
            if (bl) {
                d = d + item.getAggregateAvg(string);
                continue;
            }
            d = d + item.getAggregate(string);
        }
        stringBuilder.append(this.formatter.format(d));
        stringBuilder.append("</td>");
    }

    private void addCellTextTo(StringBuilder stringBuilder, Double d) {
        stringBuilder.append("<td align='right'>");
        stringBuilder.append(this.formatter.format(d));
        stringBuilder.append("</td>");
    }
}

