/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.itemsets;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.ar.Item;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.core.utils.res.ARLrb;

public class ARItemSetsTableModel
extends ODMrTableModel<ItemSet> {
    private static final String[] COLUMN_NAMES = new String[]{CoreCommonLrb.get((String)"ID"), ARLrb.get((String)"ITEMSETS_ITEMS"), ARLrb.get((String)"SUPPORT_PERCENT"), ARLrb.get((String)"ITEMS_IN_RULE")};
    public static final int ITEMSETS_ID = 0;
    public static final int ITEMS = 1;
    public static final int SUPPORT = 2;
    public static final int SIZE = 3;
    public static final int LAST_BASE_COLUMNS_INDEX = COLUMN_NAMES.length;

    public ARItemSetsTableModel(List<ItemSet> list) {
        super(COLUMN_NAMES, list);
    }

    public ARItemSetsTableModel(List<ItemSet> list, List<String> list2) {
        super(list);
        Object[] objectArray = Arrays.copyOf(COLUMN_NAMES, LAST_BASE_COLUMNS_INDEX + list2.size());
        ListIterator<String> listIterator = list2.listIterator();
        for (int i = LAST_BASE_COLUMNS_INDEX; i < objectArray.length; ++i) {
            objectArray[i] = listIterator.next();
        }
        this.setColumnIdentifiers(objectArray);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ItemSet itemSet = (ItemSet)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = itemSet.getId();
                break;
            }
            case 1: {
                object = itemSet.getItemsToString();
                break;
            }
            case 2: {
                if (itemSet.getSupport() == null) break;
                object = itemSet.getSupport() * 100.0;
                break;
            }
            case 3: {
                object = itemSet.getNumberOfItems();
                break;
            }
            default: {
                String string = this.getColumnName(n2);
                double d = 0.0;
                for (Item item : itemSet.getItems()) {
                    d += item.getAggregate(string).doubleValue();
                }
                object = d;
            }
        }
        return object;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: {
                return ToStringComparator.getComparator();
            }
            case 0: 
            case 2: 
            case 3: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }
}

