/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.clustering.ClusterFilterPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewer;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.StateChangeListener;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.BlockingComponent;

public class SingleClusterMainPanel
extends DataMinerViewGUI
implements StateChangeListener {
    SingleClusterViewer _clusterViewerPanel;
    ClusterFilterPanel _singleClusterViewerFilterPanel;
    SingleClusterViewerState _state;

    public ClusterFilterPanel getSingleClusterViewerFilterPanel() {
        return this._singleClusterViewerFilterPanel;
    }

    public SingleClusterMainPanel(Editor editor, Context context) {
        super(editor, context);
        Node node = context.getNode();
        ModelNode modelNode = (ModelNode)node;
        if (!modelNode.exists()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this._state = new SingleClusterViewerState(context);
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this._singleClusterViewerFilterPanel = new ClusterFilterPanel(this, this._state);
        this._clusterViewerPanel = new SingleClusterViewer(this.getEditor(), this, this._state);
        this.add((Component)this._singleClusterViewerFilterPanel, "North");
        this.add((Component)this._clusterViewerPanel, "Center");
        this._state.addStateChangeListener(this);
    }

    @Override
    public void setBlockingComponent(BlockingComponent blockingComponent) {
        super.setBlockingComponent(blockingComponent);
        if (this._clusterViewerPanel != null) {
            this._clusterViewerPanel.setBlockingComponent(blockingComponent);
        }
    }

    @Override
    public void stateChanged() {
        this._singleClusterViewerFilterPanel.executeAppy();
    }

    protected void updateLoaded(boolean bl) {
        this.setLoaded(bl);
    }

    protected void updateLoading(boolean bl) {
        this._singleClusterViewerFilterPanel.setLoading(bl);
        this.setLoading(bl);
    }

    public void setFilterState(ClusteringFilterSetting clusteringFilterSetting, boolean bl) {
        this._clusterViewerPanel.setFilterState(clusteringFilterSetting, bl);
    }

    public void setFilterPanelInitialState(ClusteringFilterSetting clusteringFilterSetting) {
        this._singleClusterViewerFilterPanel.setupUI(clusteringFilterSetting);
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._clusterViewerPanel.getHelpInfo();
    }

    @Override
    public void reload() {
        this._singleClusterViewerFilterPanel.load();
        this._clusterViewerPanel.prepareReload(true);
    }

    void prepareReload(boolean bl) {
        this._singleClusterViewerFilterPanel.load();
        this._clusterViewerPanel.prepareReload(bl);
    }

    @Override
    public void load() {
        this._singleClusterViewerFilterPanel.load();
        this._clusterViewerPanel.load();
    }

    void updateClusterIDs() {
        this._singleClusterViewerFilterPanel.setupClusterCombo();
    }
}

