/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentViewerState;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.ide.Context;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentProjections
extends JPanel
implements DataminerGUIPanel {
    private Context _context;
    private ClusterComponentViewerState _state;
    private JScrollPane jScrollPane1;
    private DataMinerTable _jComponentProjectionsTable;
    private JLabel _jTotalComponentLabel = new JLabel();
    private JComponent _findPane;
    private SearchField _jFilterCtl = new SearchField();
    public static final int FILTER_DETAIL_ATTRIBUTE = 0;
    private SearchCategory _defaultSearchCategory = new SearchCategory(ComponentLrb.get("CLUSTER_COMPONENT_DETAIL_TABLE_COLUMN_NAME"));
    private int _currentSearchCategory = 0;
    private ComponentWithTitlebar<JComponent> jComponentWithTitlebar;

    public ClusterComponentProjections(ClusterComponentViewerState clusterComponentViewerState, Context context) {
        this._context = context;
        this._state = clusterComponentViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jComponentWithTitlebar = new ComponentWithTitlebar();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 590, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 590, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 303, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jComponentWithTitlebar, GroupLayout.Alignment.TRAILING, -1, 303, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this._jComponentProjectionsTable = new DataMinerTable();
        this.jScrollPane1 = new JScrollPane((Component)((Object)this._jComponentProjectionsTable));
        this._jComponentProjectionsTable.setFillsViewportHeight(true);
        this.jComponentWithTitlebar.setComponent((JComponent)this.jScrollPane1);
        this.jComponentWithTitlebar.setLabel(this._jTotalComponentLabel);
        ControlBar controlBar = new ControlBar();
        this.setupFilterControl(controlBar);
        this.jComponentWithTitlebar.setControlBar(controlBar);
        this._jComponentProjectionsTable.setShowGrid(true);
        this.jComponentWithTitlebar.setPreferredSize(new Dimension(400, 400));
        this.setupTable(this._state.getProjectionTableModel());
    }

    public void setupTable(GenericBaseTableModel genericBaseTableModel) {
        this._jComponentProjectionsTable.setModel((TableModel)genericBaseTableModel);
        this._jComponentProjectionsTable.setSorted(true);
        this._jComponentProjectionsTable.setAutoResizeMode(3);
    }

    public void setupTable() {
        this._jComponentProjectionsTable.setModel((TableModel)this._state.getProjectionTableModel());
        this._jComponentProjectionsTable.setSorted(true);
        this._jComponentProjectionsTable.setAutoResizeMode(3);
    }

    private void setupFilterControl(ControlBar controlBar) {
        this._findPane = new Box(2);
        this._jFilterCtl = this.searchField();
        this._jFilterCtl.setStyle(SearchField.Style.FILTER);
        this._jFilterCtl.addCategory(this._defaultSearchCategory);
        this._jFilterCtl.setSelectedCategory(this._defaultSearchCategory);
        this._findPane.setName("Find");
        this._findPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._findPane.add((Component)this._jFilterCtl);
        Dimension dimension = this._findPane.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 145);
        Dimension dimension3 = this.derive(dimension, 80);
        this._findPane.setPreferredSize(dimension2);
        this._findPane.setMaximumSize(dimension2);
        this._findPane.setMinimumSize(dimension3);
        controlBar.add((Component)this._findPane);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                ClusterComponentProjections.this.translateSearchCategoryToConstant(ClusterComponentProjections.this._jFilterCtl.getSelectedCategory());
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                ClusterComponentProjections.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
            }
        });
        return searchField;
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        if (searchCategory.getLabel().equals(ComponentLrb.get("CLUSTER_COMPONENT_SEARCH_CATEGORY_NAME"))) {
            this._currentSearchCategory = 0;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }
}

