/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.clas.common.GLMCoefficient;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.GLMModelDetail;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.fe.common.FeatureCoefficient;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefAnomItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefESAItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefGLMItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefGLMRegItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefNBItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefNMFItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefPCAItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefSVDItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefSVMItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefSVMRegItemSetsSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientItemTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.ESACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.GLMCoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.NBProbabilitiesTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.PCACoefViewerTableModel;
import oracle.dmt.dataminer.mviewer.coefficients.SVDCoefViewerTableModel;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.dmt.dataminer.server.model.SVMBiasRowData;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.ObjectComparator;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.util.Version;

public class CoefViewerState
extends BaseViewerState {
    public static final String TYPICAL = CoefficientsLrb.get("TARGET_VALUE_TYPICAL");
    public static final String OUTLIER = CoefficientsLrb.get("TARGET_VALUE_OUTLIER");
    private static final String SORT_OPTION_NAME = CoefficientsLrb.get("FILTER_SORT_OPTION_NAME");
    private static final String SORT_OPTION_VALUE = CoefficientsLrb.get("FILTER_SORT_OPTION_VALUE");
    private static final String SORT_OPTION_NAME_SUBNAME = CoefficientsLrb.get("FILTER_SORT_OPTION_NAME_SUBNAME");
    private static Map<String, String> sortingOptions = new HashMap<String, String>();
    private static Map<String, Integer> predictiveValues;
    private static final ModelViewerPreferenceSettings _modelViewerPrefenceSettings;
    private static final CoefAnomItemSetsSettings coefAnomItemSetsFilterSettings;
    private static final CoefSVMItemSetsSettings coefSVMItemSetsSettings;
    private static final CoefGLMItemSetsSettings coefGLMItemSetsSettings;
    private static final CoefGLMRegItemSetsSettings coefGLMRegItemSetsSettings;
    private static final CoefSVMRegItemSetsSettings coefSVMRegItemSetsSettings;
    private static final CoefPCAItemSetsSettings coefPCAItemSetsSettings;
    private static final CoefSVDItemSetsSettings coefSVDItemSetsSettings;
    private static final CoefNMFItemSetsSettings coefNMFItemSetsSettings;
    private static final CoefESAItemSetsSettings coefESAItemSetsSettings;
    private static final CoefNBItemSetsSettings coefNBItemSetsSettings;
    private boolean loaded;
    private boolean queryForTotalDetailCount = true;
    private boolean covarianceIndicatorExists = true;
    private Object selectedTargetClass;
    private String predictiveValue;
    private Double maximumABSCoefficient = 0.0;
    private Integer totalDetailCount = 0;
    private SVMBiasRowData regressionBias;
    private List<SortSpec> sortSpecifications = new ArrayList<SortSpec>();
    private List<SVMBiasRowData> classificationBiases;
    private List<TargetPriorsPredictionSet> targetValuePriors;
    private CoefficientFilterSetting cachedFilterSetting;
    private CoefficientFilterSetting filterSetting;
    private CoefViewerTableModel coefTableModel;
    private GLMCoefViewerTableModel glmTableModel;
    private SVDCoefViewerTableModel svdTableModel;
    private PCACoefViewerTableModel pcaTableModel;
    private ESACoefViewerTableModel esaTableModel;
    private NBProbabilitiesTableModel nbTableModel;
    private CoefficientItemTableModel filterItemTableModel;

    public CoefViewerState(Context context) {
        super(context);
        this.sortSpecifications.add(new SortSpec("attribute_name_subname", SortDirection.DESCENDING, true));
    }

    public boolean isFeatureLabelUnique(String string) {
        if (this.isNMF()) {
            return this.getFeatureExtraction().isFeatureUnique(string);
        }
        if (this.isSVD() || this.isPCA()) {
            return this.getSvd().isFeatureLabelUnique(string);
        }
        assert (false) : "isFeatureLabelUniquie error.";
        return false;
    }

    public CoefViewerState load(PartitionVO partitionVO) throws Exception {
        Object object;
        this.filterSetting = new CoefficientFilterSetting(this);
        if (this.isAnomaly()) {
            this.filterSetting.setFilterByAbsolute(coefAnomItemSetsFilterSettings.getSortByAbsoluteValue());
        } else if (this.isSVM()) {
            if (this.isRegression()) {
                this.filterSetting.setFilterByAbsolute(coefSVMRegItemSetsSettings.getSortByAbsoluteValue());
            } else {
                this.filterSetting.setFilterByAbsolute(coefSVMItemSetsSettings.getSortByAbsoluteValue());
            }
        } else if (this.isGLM()) {
            if (this.isRegression()) {
                this.filterSetting.setFilterByAbsolute(coefGLMRegItemSetsSettings.getSortByAbsoluteValue());
            } else {
                this.filterSetting.setFilterByAbsolute(coefGLMItemSetsSettings.getSortByAbsoluteValue());
            }
        } else if (this.isPCA()) {
            this.filterSetting.setFilterByAbsolute(coefPCAItemSetsSettings.getSortByAbsoluteValue());
            this.filterSetting.setFetchSize(coefPCAItemSetsSettings.getFetchSizeValue());
        } else if (this.isSVD()) {
            this.filterSetting.setFilterByAbsolute(coefSVDItemSetsSettings.getSortByAbsoluteValue());
            this.filterSetting.setFetchSize(coefSVDItemSetsSettings.getFetchSizeValue());
        } else if (this.isNMF()) {
            this.filterSetting.setFilterByAbsolute(coefNMFItemSetsSettings.getSortByAbsoluteValue());
            this.filterSetting.setFetchSize(coefNMFItemSetsSettings.getFetchSizeValue());
        } else if (this.isESA()) {
            this.filterSetting.setFetchSize(coefESAItemSetsSettings.getFetchSizeValue());
        }
        this.cachedFilterSetting = new CoefficientFilterSetting(this);
        String string = null;
        if (partitionVO != null) {
            string = partitionVO.getPartitionID();
        }
        this.setPartitionId(string);
        if (this.isGLM()) {
            this.covarianceIndicatorExists = this.findCovarianceMatrixIndicator(string);
        }
        if (this.isClassification()) {
            if (this.isSVM() || this.isAnomaly()) {
                object = null;
                object = this.getSvmC().getAbsMaxValue();
                this.filterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                this.filterSetting.setMaxCoefficient(new BigDecimal((Double)object));
                this.cachedFilterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                this.cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object));
            } else if (this.isGLM()) {
                object = this.getGlmC().getMinMaxValue();
                this.filterSetting.setMinCoefficient(new BigDecimal((Double)object[0]));
                this.filterSetting.setMaxCoefficient(new BigDecimal((Double)object[1]));
                this.cachedFilterSetting.setMinCoefficient(new BigDecimal((Double)object[0]));
                this.cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object[1]));
            } else if (this.isNB()) {
                this.filterSetting.setFilterByAbsolute(coefNBItemSetsSettings.getSortByAbsoluteValue());
                this.filterSetting.setFetchSize(coefNBItemSetsSettings.getFetchSizeValue());
            }
        } else if (this.isFeatureExtraction() && !this.isSVD()) {
            object = this.getModelTypeClass();
            Double d = this.getFeatureExtraction().getMaximumCoefficient((Class<? extends ModelType>)object);
            this.filterSetting.setMinCoefficient(BigDecimal.ZERO);
            this.filterSetting.setMaxCoefficient(new BigDecimal(d));
            this.cachedFilterSetting.setMinCoefficient(BigDecimal.ZERO);
            this.cachedFilterSetting.setMaxCoefficient(new BigDecimal(d));
        }
        if (this.isClassification()) {
            this.targetValuePriors = this.getClassification().getTargetValuePredictionSet(partitionVO);
            if (this.targetValuePriors.size() < 2) {
                throw new DataMinerException(CoefficientsLrb.get("COEFFICIENT_VIEWER_NO_TARGET_PRIORS_VALUES"));
            }
            this.filterSetting.setTargetValuePriors(this.targetValuePriors);
        } else if (this.isRegression()) {
            object = this.getRegression().getRegressionModelTarget();
            this.filterSetting.setTargetValue(object);
        } else if (this.isFeatureExtraction()) {
            if (this.isSVD() || this.isPCA()) {
                this.getSvd().loadSingularValuesToIdValueMap();
            }
            if (!this.isESA()) {
                this.targetValuePriors = this.getFeatureExtraction().getTargetValuePredictionSet(partitionVO);
                this.filterSetting.setTargetValuePriors(this.targetValuePriors);
            }
        }
        if (!this.isESA()) {
            this.loadDefaultTargetValue();
        }
        object = new DetailCounter(string);
        ((DetailCounter)object).count();
        this.totalDetailCount = ((DetailCounter)object).getCount();
        this.maximumABSCoefficient = ((DetailCounter)object).getMaximumABSCoefficient();
        this.initInternalTable();
        if (!this.isESA()) {
            this.loadCoefficients(string);
        }
        this.queryForTotalDetailCount = false;
        this.loaded = true;
        return this;
    }

    private boolean findCovarianceMatrixIndicator(String string) throws ODMrDAOException {
        List<GLMModelDetail> list = this.getGLMModelDetails(string);
        boolean bl = this.modelConvergedOrHasValidCovarianceMatrix(list);
        return bl;
    }

    private List<GLMModelDetail> getGLMModelDetails(String string) throws ODMrDAOException {
        List<Object> list = new ArrayList();
        ModelNode modelNode = (ModelNode)this.context.getNode();
        this.setPartitionId(string);
        list = modelNode instanceof GLMCModelNode ? this.getGlmC().getGlobalDetails() : this.getGlmR().getGlobalDetails();
        return list;
    }

    private boolean modelConvergedOrHasValidCovarianceMatrix(List<GLMModelDetail> list) {
        boolean bl = false;
        if (!DbVersionHelper.isDB122Up((Version)this.connectionManager.getDbVersion())) {
            for (GLMModelDetail gLMModelDetail : list) {
                if (!"VALID_COVARIANCE_MATRIX".equals(gLMModelDetail.getName()) && !"MODEL_CONVERGED".equals(gLMModelDetail.getName())) continue;
                bl = (Boolean)gLMModelDetail.getValue();
            }
        }
        return bl;
    }

    private void loadDefaultTargetValue() {
        if (this.isClassification()) {
            if (this.isSVM() || this.isAnomaly()) {
                this.setSelectedTargetClass(this.getSvmC().findMostCommonTargetValue(this.targetValuePriors).getPrediction());
            } else if (this.isGLM()) {
                this.setSelectedTargetClass(this.getGlmC().findMostCommonTargetValue(this.targetValuePriors).getPrediction());
            } else if (this.isNB()) {
                this.setSelectedTargetClass(this.getNb().findMostCommonTargetValue(this.targetValuePriors).getPrediction());
            }
        } else if (this.isSVD() || this.isPCA()) {
            this.setSelectedTargetClass(this.getSvd().findMostCommonTargetValue(this.targetValuePriors).getPrediction());
        } else if (this.isFeatureExtraction() && !this.isESA()) {
            this.setSelectedTargetClass(this.getFeatureExtraction().findMostCommonTargetValue(this.targetValuePriors).getPrediction());
        }
    }

    private void initInternalTable() {
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            this.coefTableModel = new CoefViewerTableModel();
        } else if (this.isGLM()) {
            ArrayList<GLMCoefficient> arrayList = new ArrayList<GLMCoefficient>();
            this.glmTableModel = new GLMCoefViewerTableModel(arrayList, this.isCovarianceIndicator(), this.isClassification());
        } else if (this.isNB()) {
            this.nbTableModel = new NBProbabilitiesTableModel();
        } else if (this.isSVD()) {
            this.svdTableModel = new SVDCoefViewerTableModel();
        } else if (this.isPCA()) {
            this.pcaTableModel = new PCACoefViewerTableModel();
        } else if (this.isESA()) {
            this.esaTableModel = new ESACoefViewerTableModel();
        } else assert (false) : "CoefViewerState not loaded.";
    }

    private void loadCoefficients(String string) throws ODMrDAOException, SQLException {
        this.setPartitionId(string);
        if (this.isSVM() || this.isAnomaly()) {
            List<Object> list = new ArrayList(0);
            if (this.isClassification()) {
                list = this.getSvmC().getCoefficients(this.filterSetting);
            } else if (this.isRegression()) {
                list = this.getSvmR().getCoefficients(this.filterSetting);
            }
            this.coefTableModel.setSrcData(list);
        } else if (this.isGLM()) {
            List<Object> list = new ArrayList();
            if (this.isClassification()) {
                list = this.getGlmC().getCoefficients(this.filterSetting);
            } else if (this.isRegression()) {
                list = this.getGlmR().getCoefficients(this.filterSetting);
            } else assert (false) : "Invalid model type";
            this.glmTableModel.setSrcData(list);
        } else if (this.isNB()) {
            List<AttributeBiCoefficient> list = this.getNb().getProbabilities(this.filterSetting);
            this.nbTableModel.setSrcData(list);
        } else if (this.isNMF()) {
            List<AttributeBiCoefficient> list = this.getFeatureExtraction().getCoefficients(this.filterSetting);
            this.coefTableModel.setSrcData(list);
        } else if (this.isSVD()) {
            List<SVDCoefficient> list = this.getSvd().getSVDCoefficients(this.filterSetting);
            this.svdTableModel.setSrcData(list);
        } else if (this.isPCA()) {
            List<SVDCoefficient> list = this.getSvd().getSVDCoefficients(this.filterSetting);
            this.pcaTableModel.setSrcData(list);
        } else if (this.isESA()) {
            List<FeatureCoefficient> list = this.getFeatureExtraction().getFeatureCoefficients(ExplicitSemanticAnalysisModelType.class, this.filterSetting.getSortSpecification(), this.filterSetting.getFetchSize(), this.filterSetting.getTargetValue().toString());
            this.esaTableModel.setSrcData(list);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public void reloadFeatureValues(PartitionVO partitionVO) throws Exception {
        this.setPartitionId(partitionVO);
        if (this.isNMF()) {
            this.targetValuePriors = this.getFeatureExtraction().getTargetValuePredictionSet(partitionVO);
        } else if (this.isSVD() || this.isPCA()) {
            this.getSvd().loadSingularValuesToIdValueMap();
            this.targetValuePriors = this.getSvd().getTargetValuePredictionSet(partitionVO);
        }
        this.filterSetting.setTargetValuePriors(this.targetValuePriors);
        this.loadDefaultTargetValue();
    }

    public CoefViewerState reloadCoefficients(String string) throws Exception {
        if (this.queryForTotalDetailCount) {
            DetailCounter detailCounter = new DetailCounter(string);
            detailCounter.count();
            this.totalDetailCount = detailCounter.getCount();
            this.maximumABSCoefficient = detailCounter.getMaximumABSCoefficient();
            this.queryForTotalDetailCount = false;
            this.loadCoefficients(string);
        } else {
            this.initInternalTable();
            if (!this.isESA()) {
                this.loadCoefficients(string);
            }
        }
        return this;
    }

    public BigDecimal getBias() {
        BigDecimal bigDecimal = null;
        if (this.getSvmC() != null) {
            String string = this.getSelectedTargetClass().toString();
            for (SVMBiasRowData sVMBiasRowData : this.classificationBiases) {
                if (!sVMBiasRowData.getClassValue().equals(string)) continue;
                bigDecimal = sVMBiasRowData.getBias();
                break;
            }
            if (this.getFilterSetting().isBinaryClassModel() && bigDecimal == null) {
                bigDecimal = this.classificationBiases.get(0).getBias().negate();
            }
        } else if (this.getSvmR() != null) {
            bigDecimal = this.regressionBias.getBias();
        }
        return bigDecimal;
    }

    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isSVM() && this.isClassification()) {
            string = "svmc_coeff_help";
        } else if (this.isSVM() && this.isRegression()) {
            string = "svmr_coeff_help";
        } else if (this.isGLM() && this.isClassification()) {
            string = "glmc_coeff_help";
        } else if (this.isGLM() && this.isRegression()) {
            string = "glmr_coeff_help";
        } else if (this.isNB()) {
            string = "nb_coeff_help";
        } else if (this.isAnomaly()) {
            string = "svmc_coeff_help_grid";
        } else if (this.isNMF()) {
            string = "nmf_coeff_help";
        } else if (this.isPCA()) {
            string = "pca_viewer_coeff";
        } else if (this.isSVD()) {
            string = "svd_viewer_coeff";
        } else if (this.isESA()) {
            string = "esa_viewer_coeff";
        }
        return new HelpInfo(string);
    }

    public void setFilterSetting(CoefficientFilterSetting coefficientFilterSetting) {
        this.filterSetting = coefficientFilterSetting;
        if (this.getSelectedTargetClass() != null) {
            this.filterSetting.setTargetValue(this.getSelectedTargetClass());
        }
        if (this.getTargetValuePrior() != null) {
            this.filterSetting.setTargetValuePriors(this.getTargetValuePrior());
        }
    }

    public CoefficientFilterSetting getFilterSetting() {
        return this.filterSetting;
    }

    public List<Object> getTargetPredictions() {
        return ObjectComparator.getTargetPredictions(this.targetValuePriors);
    }

    public List<TargetPriorsPredictionSet> getTargetValuePrior() {
        return this.targetValuePriors;
    }

    public void setSelectedTargetClass(Object object) {
        this.selectedTargetClass = object;
        this.queryForTotalDetailCount = true;
        this.filterSetting.setTargetValue(object);
    }

    public Object getSelectedTargetClass() {
        return this.selectedTargetClass;
    }

    public void clearRows() {
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            if (this.coefTableModel != null) {
                this.coefTableModel.clear();
            }
        } else if (this.isGLM()) {
            if (this.glmTableModel != null) {
                this.glmTableModel.clear();
            }
        } else if (this.isNB()) {
            if (this.nbTableModel != null) {
                this.nbTableModel.clear();
            }
        } else if (this.isSVD()) {
            if (this.svdTableModel != null) {
                this.svdTableModel.clear();
            }
        } else if (this.isPCA()) {
            if (this.pcaTableModel != null) {
                this.pcaTableModel.clear();
            }
        } else if (this.isESA()) {
            if (this.esaTableModel != null) {
                this.esaTableModel.clear();
            }
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public void addRow(AttributeBiCoefficient attributeBiCoefficient) {
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            this.coefTableModel.addRow(attributeBiCoefficient);
        } else if (this.isNB()) {
            this.nbTableModel.addRow(attributeBiCoefficient);
        } else assert (false) : "Loaded a SVM Coefficient row when model was not SVM.";
    }

    public void addSVDRow(SVDCoefficient sVDCoefficient) {
        this.svdTableModel.addRow(sVDCoefficient);
    }

    public void addPCARow(SVDCoefficient sVDCoefficient) {
        this.pcaTableModel.addRow(sVDCoefficient);
    }

    public void addRow(GLMCoefficient gLMCoefficient) {
        if (this.isGLM()) {
            this.glmTableModel.addRow(gLMCoefficient);
        } else assert (false) : "Loaded a GLM Coefficient row when model was not GLM.";
    }

    public void addRow(FeatureCoefficient featureCoefficient) {
        if (!this.isESA()) {
            return;
        }
        this.esaTableModel.addRow(featureCoefficient);
    }

    public ODMrTableModel getTableModel() {
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            return this.coefTableModel;
        }
        if (this.isGLM()) {
            return this.glmTableModel;
        }
        if (this.isNB()) {
            return this.nbTableModel;
        }
        if (this.isSVD()) {
            return this.svdTableModel;
        }
        if (this.isPCA()) {
            return this.pcaTableModel;
        }
        if (this.isESA()) {
            return this.esaTableModel;
        }
        assert (false) : "CoefViewerState not loaded.";
        return null;
    }

    public void setCachedFilterSetting(CoefficientFilterSetting coefficientFilterSetting) {
        this.cachedFilterSetting = coefficientFilterSetting;
    }

    public CoefficientFilterSetting getCachedFilterSetting() {
        return this.cachedFilterSetting;
    }

    public void setSortByAbsoluteValue(boolean bl) {
        this.cachedFilterSetting.setFilterByAbsolute(bl);
        if (this.isAnomaly()) {
            this.coefTableModel.setAbsoluteValueSort(bl);
            coefAnomItemSetsFilterSettings.setSortByAbsoluteValue(bl);
        } else if (this.isSVM()) {
            this.coefTableModel.setAbsoluteValueSort(bl);
            if (this.isRegression()) {
                coefSVMRegItemSetsSettings.setSortByAbsoluteValue(bl);
            } else {
                coefSVMItemSetsSettings.setSortByAbsoluteValue(bl);
            }
        } else if (this.isGLM()) {
            this.glmTableModel.setAbsoluteValueSort(bl);
            if (this.isRegression()) {
                coefGLMRegItemSetsSettings.setSortByAbsoluteValue(bl);
            } else {
                coefGLMItemSetsSettings.setSortByAbsoluteValue(bl);
            }
        } else if (this.isNB()) {
            this.nbTableModel.setAbsoluteValueSort(bl);
            coefNBItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isSVD()) {
            this.svdTableModel.setAbsoluteValueSort(bl);
            coefSVDItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isPCA()) {
            this.pcaTableModel.setAbsoluteValueSort(bl);
            coefPCAItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isNMF()) {
            this.coefTableModel.setAbsoluteValueSort(bl);
            coefNMFItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isESA()) {
            this.esaTableModel.setAbsoluteValueSort(bl);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public boolean getSortByAbsoluteValue() {
        boolean bl = false;
        if (this.isSVM() || this.isAnomaly() || this.isNMF()) {
            bl = this.coefTableModel.getAbsoluteValueSort();
        } else if (this.isGLM()) {
            bl = this.glmTableModel.getAbsoluteValueSort();
        } else if (this.isNB()) {
            bl = this.nbTableModel.getAbsoluteValueSort();
        } else if (this.isSVD()) {
            bl = this.svdTableModel.getAbsoluteValueSort();
        } else if (this.isPCA()) {
            bl = this.pcaTableModel.getAbsoluteValueSort();
        } else assert (false) : CoefficientsLrb.get("INVALID_FILTER_SORT_OPTION_VALUE");
        return bl;
    }

    public int getFetchSizeValue() {
        int n = 1000;
        if (this.isSVM() || this.isAnomaly()) {
            n = coefSVMItemSetsSettings.getFetchSizeValue();
        } else if (this.isGLM()) {
            n = coefGLMItemSetsSettings.getFetchSizeValue();
        } else if (this.isNB()) {
            n = coefNBItemSetsSettings.getFetchSizeValue();
        } else if (this.isPCA()) {
            n = coefPCAItemSetsSettings.getFetchSizeValue();
        } else if (this.isNMF()) {
            n = coefNMFItemSetsSettings.getFetchSizeValue();
        } else if (this.isSVD()) {
            n = coefSVDItemSetsSettings.getFetchSizeValue();
        } else if (this.isESA()) {
            n = coefESAItemSetsSettings.getFetchSizeValue();
        } else assert (false) : "CoefViewerState not loaded.";
        return n;
    }

    public void setFetchSizeValue(int n) {
        this.cachedFilterSetting.setFetchSize(n);
        if (this.isSVM() || this.isAnomaly()) {
            coefSVMItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isGLM()) {
            coefGLMItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isNB()) {
            coefNBItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isPCA()) {
            coefPCAItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isNMF()) {
            coefNMFItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isSVD()) {
            coefSVDItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isESA()) {
            coefESAItemSetsSettings.setFetchSizeValue(n);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public List<? extends AttributeBiCoefficient> getData(List<SortSpec> list) throws ODMrDAOException, SQLException {
        return this.getAllData(list);
    }

    public List<? extends AttributeBiCoefficient> getAllData(CoefficientFilterSetting coefficientFilterSetting) throws ODMrDAOException, SQLException {
        List<Object> list = new ArrayList(0);
        if (this.isSVM()) {
            if (this.isClassification()) {
                list = this.getSvmC().getAllCoefficients(coefficientFilterSetting);
            } else if (this.isRegression()) {
                list = this.getSvmR().getAllCoefficients(coefficientFilterSetting);
            }
        } else if (this.isGLM()) {
            if (this.isClassification()) {
                list = this.getGlmC().getAllCoefficients(coefficientFilterSetting);
            } else if (this.isRegression()) {
                list = this.getGlmR().getAllCoefficients(coefficientFilterSetting);
            } else assert (false) : "Invalid model type";
        } else if (this.isNB()) {
            list = this.getNb().getAllProbabilities(coefficientFilterSetting);
        } else if (this.isNMF()) {
            list = this.getFeatureExtraction().getAllCoefficients(coefficientFilterSetting);
        } else assert (false) : "CoefViewerState not loaded.";
        return list;
    }

    private List<? extends AttributeBiCoefficient> getAllData(List<SortSpec> list) throws ODMrDAOException, SQLException {
        CoefficientFilterSetting coefficientFilterSetting = new CoefficientFilterSetting();
        coefficientFilterSetting.setUseFilterSpecification(false);
        coefficientFilterSetting.setFetchSize(_modelViewerPrefenceSettings.getFetchSizeOtherModels());
        coefficientFilterSetting.setSortSpecification(list);
        coefficientFilterSetting.setWhereSpecification(null);
        List<Object> list2 = new ArrayList();
        if (this.isSVM()) {
            if (this.isClassification()) {
                list2 = this.getSvmC().getAllCoefficients(coefficientFilterSetting);
            } else if (this.isRegression()) {
                list2 = this.getSvmR().getAllCoefficients(coefficientFilterSetting);
            }
        } else if (this.isGLM()) {
            if (this.isClassification()) {
                list2 = this.getGlmC().getAllCoefficients(coefficientFilterSetting);
            } else if (this.isRegression()) {
                list2 = this.getGlmR().getAllCoefficients(coefficientFilterSetting);
            } else assert (false) : "Invalid model type";
        } else if (this.isNB()) {
            list2 = this.getNb().getAllProbabilities(coefficientFilterSetting);
        } else if (this.isNMF()) {
            list2 = this.getFeatureExtraction().getAllCoefficients(coefficientFilterSetting);
        } else assert (false) : "CoefViewerState not loaded.";
        return list2;
    }

    public void setSortSpec(List<SortSpec> list) {
        this.sortSpecifications = new ArrayList<SortSpec>(list);
    }

    public List<SortSpec> getSortSpec() {
        return this.sortSpecifications;
    }

    public static boolean isNameSortOption(List<SortSpec> list) {
        for (SortSpec sortSpec : list) {
            String string = sortSpec.getAttributeName();
            if (!string.equals("attribute_name")) continue;
            return true;
        }
        return false;
    }

    public static boolean isNameSubnameSortOption(List<SortSpec> list) {
        for (SortSpec sortSpec : list) {
            String string = sortSpec.getAttributeName();
            if (!string.equals("attribute_name_subname")) continue;
            return true;
        }
        return false;
    }

    public static boolean isValueSortOption(List<SortSpec> list) {
        for (SortSpec sortSpec : list) {
            String string = sortSpec.getAttributeName();
            if (!string.equals("attribute_value")) continue;
            return true;
        }
        return false;
    }

    public List<AttributeBiCoefficient> getSelectedFilterItems() {
        ArrayList<AttributeBiCoefficient> arrayList = this.filterItemTableModel != null ? this.filterItemTableModel.getSrcData() : new ArrayList();
        return arrayList;
    }

    public String getPredictiveValue() {
        return this.predictiveValue;
    }

    public void setPredictiveValue(String string) {
        this.predictiveValue = string;
        if (this.filterSetting != null) {
            this.setSelectedTargetClass(this.translatePredictiveValue(string));
        }
    }

    public Integer translatePredictiveValue(String string) {
        return predictiveValues.get(string);
    }

    public void setFilterItemTableModel(CoefficientItemTableModel coefficientItemTableModel) {
        this.filterItemTableModel = coefficientItemTableModel;
    }

    public CoefficientItemTableModel getFilterItemTableModel() {
        return this.filterItemTableModel;
    }

    public Integer getTotalDetailCount() {
        return this.totalDetailCount;
    }

    public boolean isCovarianceIndicator() {
        return this.covarianceIndicatorExists;
    }

    public Double getMaximumABSCoefficient() {
        return this.maximumABSCoefficient;
    }

    public void renameFeature(String string, String string2) throws Exception {
        if (this.isFeatureExtraction()) {
            this.getFeatureExtraction().renameFeature(string, string2);
        }
    }

    public Double getFeatureIdSingularValue(Object object) {
        return this.getSvd().getSingularByFeatureIdValue(object.toString());
    }

    public static String predictiveValuesToString(Object object) {
        if (object instanceof BigDecimal) {
            if (((BigDecimal)object).intValue() == 1) {
                return TYPICAL;
            }
            return OUTLIER;
        }
        return object.toString();
    }

    public static String getSortColumnName(String string) {
        return sortingOptions.get(string);
    }

    static {
        sortingOptions.put(SORT_OPTION_NAME_SUBNAME, "attribute_name_subname");
        sortingOptions.put(SORT_OPTION_NAME, "attribute_name");
        sortingOptions.put(SORT_OPTION_VALUE, "attribute_value");
        predictiveValues = new HashMap<String, Integer>();
        predictiveValues.put(TYPICAL, 1);
        predictiveValues.put(OUTLIER, 0);
        _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance();
        coefAnomItemSetsFilterSettings = CoefAnomItemSetsSettings.getInstance();
        coefSVMItemSetsSettings = CoefSVMItemSetsSettings.getInstance();
        coefGLMItemSetsSettings = CoefGLMItemSetsSettings.getInstance();
        coefGLMRegItemSetsSettings = CoefGLMRegItemSetsSettings.getInstance();
        coefSVMRegItemSetsSettings = CoefSVMRegItemSetsSettings.getInstance();
        coefPCAItemSetsSettings = CoefPCAItemSetsSettings.getInstance();
        coefSVDItemSetsSettings = CoefSVDItemSetsSettings.getInstance();
        coefNMFItemSetsSettings = CoefNMFItemSetsSettings.getInstance();
        coefESAItemSetsSettings = CoefESAItemSetsSettings.getInstance();
        coefNBItemSetsSettings = CoefNBItemSetsSettings.getInstance();
    }

    private class DetailCounter {
        private int count;
        private Double maximumABSCoefficient;
        private String partitionId;
        private List<Object> targetValues = this.generateTargetValuesCollection();

        public DetailCounter(String string) {
            this.partitionId = string;
            this.count = 0;
            this.maximumABSCoefficient = 0.0;
        }

        public void count() throws Exception {
            Integer n = 0;
            Double d = 0.0;
            CoefViewerState.this.setPartitionId(this.partitionId);
            if (CoefViewerState.this.isSVM() || CoefViewerState.this.isAnomaly()) {
                if (CoefViewerState.this.isClassification()) {
                    Map<String, Object> map = CoefViewerState.this.getSvmC().getCoefficientStatistics(this.targetValues, CoefViewerState.this.filterSetting);
                    n = (Integer)map.get("TOTAL_COEFFICIENTS");
                    d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                } else if (CoefViewerState.this.isRegression()) {
                    Map<String, Object> map = CoefViewerState.this.getSvmR().getCoefficientStatistics();
                    n = (Integer)map.get("TOTAL_COEFFICIENTS");
                    d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                }
            } else if (CoefViewerState.this.isGLM()) {
                if (CoefViewerState.this.isClassification()) {
                    Map<String, Object> map = CoefViewerState.this.getGlmC().getCoefficientStatistics(this.targetValues, CoefViewerState.this.filterSetting);
                    n = (Integer)map.get("TOTAL_COEFFICIENTS");
                    d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                } else if (CoefViewerState.this.isRegression()) {
                    Map<String, Object> map = CoefViewerState.this.getGlmR().getCoefficientStatistics();
                    n = (Integer)map.get("TOTAL_COEFFICIENTS");
                    d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
                }
            } else if (CoefViewerState.this.isNB()) {
                n = CoefViewerState.this.getNb().getTotalCountProbabilities(this.targetValues);
            } else if (CoefViewerState.this.isNMF()) {
                Map<String, Object> map = CoefViewerState.this.getFeatureExtraction().getCoefficientStatistics(this.targetValues);
                n = (Integer)map.get("TOTAL_COEFFICIENTS");
                d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
            } else if (CoefViewerState.this.isESA()) {
                Map<String, Object> map = CoefViewerState.this.getFeatureExtraction().getESACoefficientStatistics(this.targetValues);
                n = (Integer)map.get("TOTAL_COEFFICIENTS");
                d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
            } else if (CoefViewerState.this.isSVD()) {
                Map<String, Object> map = CoefViewerState.this.getSvd().getCoefficientStatistics(this.targetValues);
                n = (Integer)map.get("TOTAL_COEFFICIENTS");
                d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
            } else if (CoefViewerState.this.isPCA()) {
                Map<String, Object> map = CoefViewerState.this.getSvd().getCoefficientStatistics(this.targetValues);
                n = (Integer)map.get("TOTAL_COEFFICIENTS");
                d = (Double)map.get("MAXIMUM_ABS_COEFFICIENT_VALUE");
            } else assert (false) : "CoefViewerState not loaded. ";
            this.count = n;
            this.maximumABSCoefficient = d;
        }

        private List<Object> generateTargetValuesCollection() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(CoefViewerState.this.selectedTargetClass);
            return arrayList;
        }

        public Integer getCount() {
            return this.count;
        }

        public Double getMaximumABSCoefficient() {
            return this.maximumABSCoefficient;
        }
    }
}

