/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DataMinerTagCloud;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortType;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.features.FeatureViewerState;
import oracle.dmt.dataminer.utils.Formats;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class FeatureCoefficientsPanel
extends JPanel
implements DataminerGUIPanel {
    private static final double MAX_HISTOGRAM_VALUE = 1.0;
    private NumberFormat labelNumericalFormat;
    private HistogramBarRenderer barRenderer;
    private FeatureViewerState state;
    private ButtonGroup buttonGroup;
    private JPanel cloudPanel;
    private DataMinerTablePanel coefficientsTablePanel;
    private JLabel fetchLabel;
    private JSpinner fetchSpinner;
    private JCheckBox filterCheckBox;
    private JComboBox<String> orderComboBox;
    private JLabel orderLabel;
    private JRadioButton radioButtonAscending;
    private JRadioButton radioButtonDescending;
    private JButton refreshButton;
    private JTabbedPane tabbedPane;
    private DataMinerTagCloud tagCloud;

    public FeatureCoefficientsPanel(FeatureViewerState featureViewerState) {
        assert (featureViewerState != null) : "State cannot be null";
        this.state = featureViewerState;
        this.labelNumericalFormat = Formats.ModelViewer.getNumeric();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.tabbedPane = new JTabbedPane();
        this.cloudPanel = new JPanel();
        this.orderLabel = new JLabel();
        this.orderComboBox = new JComboBox();
        this.radioButtonAscending = new JRadioButton();
        this.radioButtonDescending = new JRadioButton();
        this.tagCloud = new DataMinerTagCloud();
        this.coefficientsTablePanel = new DataMinerTablePanel();
        this.refreshButton = new JButton();
        this.fetchSpinner = new JSpinner();
        this.filterCheckBox = new JCheckBox();
        this.fetchLabel = new JLabel();
        this.orderLabel.setText("Order By:");
        this.buttonGroup.add(this.radioButtonAscending);
        this.radioButtonAscending.setText("Ascending");
        this.buttonGroup.add(this.radioButtonDescending);
        this.radioButtonDescending.setSelected(true);
        this.radioButtonDescending.setText("Descending");
        GroupLayout groupLayout = new GroupLayout(this.cloudPanel);
        this.cloudPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.orderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderComboBox, 0, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioButtonAscending).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonDescending).addContainerGap(355, Short.MAX_VALUE)).addComponent(this.tagCloud, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.orderLabel).addComponent(this.orderComboBox, -2, -1, -2).addComponent(this.radioButtonAscending).addComponent(this.radioButtonDescending)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagCloud, -1, 306, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Tag Cloud", this.cloudPanel);
        this.tabbedPane.addTab("Coefficients", this.coefficientsTablePanel);
        this.refreshButton.setText("Refresh");
        this.fetchSpinner.setValue(100);
        this.filterCheckBox.setSelected(true);
        this.filterCheckBox.setText("Show Only Filtered");
        this.filterCheckBox.setEnabled(false);
        this.fetchLabel.setText("Size:");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.filterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fetchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fetchSpinner, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton).addContainerGap()).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshButton).addComponent(this.fetchSpinner, -2, -1, -2).addComponent(this.filterCheckBox).addComponent(this.fetchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.refreshButton, (String)"");
        this.refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        ResourceUtils.resLabel((JLabel)this.orderLabel, this.orderComboBox, (String)ControlsLrb.get("CONTROLS_SORTING_ORDER_BY"));
        ResourceUtils.resButton((AbstractButton)this.radioButtonAscending, (String)ControlsLrb.get("CONTROLS_SORTING_ASCENDING"));
        ResourceUtils.resButton((AbstractButton)this.radioButtonDescending, (String)ControlsLrb.get("CONTROLS_SORTING_DESCENDING"));
        ResourceUtils.resLabel((JLabel)this.fetchLabel, (Component)this.fetchSpinner, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this.fetchSpinner.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this.fetchSpinner.setModel(new SpinnerNumberModel(100, 1, Integer.MAX_VALUE, 100));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(ControlsLrb.get("CONTROLS_SORTING_ALPHABETICAL"));
        defaultComboBoxModel.addElement(ControlsLrb.get("CONTROLS_SORTING_COEFFICIENTS"));
        this.orderComboBox.setModel(defaultComboBoxModel);
        ResourceUtils.resButton((AbstractButton)this.filterCheckBox, (String)CommonLrb.get("MSG_SHOW_ONLY_FILTERED"));
    }

    @Override
    public void initUI() {
        this.setPreferredConfiguration();
        this.initializeCoefficientsTable();
        this.addListeners();
    }

    private void setPreferredConfiguration() {
        this.filterCheckBox.setSelected(this.state.retrieveFilteredCoefficientsOnly());
        this.orderComboBox.setSelectedIndex(SortType.ALPHABETICAL.equals((Object)this.state.getCoefficientSortType()) ? 0 : 1);
        if (SortDirection.DESCENDING.equals((Object)this.state.getCoefficientSortDirection())) {
            this.radioButtonDescending.setSelected(true);
        } else {
            this.radioButtonAscending.setSelected(true);
        }
    }

    private void initializeCoefficientsTable() {
        this.barRenderer = new HistogramBarRenderer(1.0, true, this.labelNumericalFormat);
        this.barRenderer.setMaximumValue(1.0);
        DataMinerTable dataMinerTable = this.coefficientsTablePanel.getTable();
        dataMinerTable.setSortColumn(2, false);
        this.coefficientsTablePanel.setup((TableModel)((Object)this.state.getCoefficientTableModel()), "", -1, true);
        dataMinerTable.getFullColumnModel().getColumn(2).setCellRenderer(this.barRenderer);
    }

    private void addListeners() {
        this.orderComboBox.addActionListener(new OrderingTypeListener());
        SortingDirectionListener sortingDirectionListener = new SortingDirectionListener();
        this.radioButtonAscending.addActionListener(sortingDirectionListener);
        this.radioButtonDescending.addActionListener(sortingDirectionListener);
        this.filterCheckBox.addChangeListener(new CoefficientFilterListener());
        this.fetchSpinner.addChangeListener(new CoefficientFetchSizeListener());
    }

    public DataMinerTable getCoefficientsTable() {
        return this.coefficientsTablePanel.getTable();
    }

    public void enableTagCloudFilter(boolean bl) {
        this.filterCheckBox.setEnabled(bl);
    }

    public void clearTagCloud() {
        this.tagCloud.setOrderType(this.state.getCoefficientSortType());
        this.tagCloud.setSortDirection(this.state.getCoefficientSortDirection());
        this.tagCloud.clearWords();
    }

    public void drawTagCloud() {
        this.tagCloud.redrawCloud(this.state.getCoefficientTableModel().getSrcData(), this.filterCheckBox.isSelected() && this.filterCheckBox.isEnabled());
    }

    public void addRefreshAction(ActionListener actionListener) {
        this.refreshButton.addActionListener(actionListener);
    }

    private class CoefficientFetchSizeListener
    implements ChangeListener {
        private CoefficientFetchSizeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = FeatureCoefficientsPanel.this.fetchSpinner.getValue();
            if (object == null || !(object instanceof Integer)) {
                return;
            }
            FeatureCoefficientsPanel.this.state.setCoefficientFetchSize((Integer)object);
        }
    }

    private class CoefficientFilterListener
    implements ChangeListener {
        private CoefficientFilterListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FeatureCoefficientsPanel.this.state.setCoefficientsFiltered(FeatureCoefficientsPanel.this.filterCheckBox.isSelected());
        }
    }

    private class SortingDirectionListener
    implements ActionListener {
        private SortingDirectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FeatureCoefficientsPanel.this.radioButtonAscending.isSelected()) {
                FeatureCoefficientsPanel.this.state.setCoefficientSortDirection(SortDirection.ASCENDING);
            } else if (FeatureCoefficientsPanel.this.radioButtonDescending.isSelected()) {
                FeatureCoefficientsPanel.this.state.setCoefficientSortDirection(SortDirection.DESCENDING);
            }
        }
    }

    private class OrderingTypeListener
    implements ActionListener {
        private OrderingTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureCoefficientsPanel.this.state.setCoefficientSortType(FeatureCoefficientsPanel.this.orderComboBox.getSelectedIndex() == 0 ? SortType.ALPHABETICAL : SortType.NUMERICAL);
        }
    }
}

