/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.glmdetails;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.glmdetails.DetailsViewerState;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsLrb;
import oracle.dmt.dataminer.mviewer.glmdetails.GLMDetailsTableModel;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;

public class DetailsPanel
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(DetailsPanel.class.getName());
    private GLMDetailsTableModel tableModel;
    private DetailsViewerState state;
    private DataMinerTablePanel detailsTablePanel;
    private ModelViewerPartitionToolbar partitionToolbar;

    public DetailsPanel(Editor editor, Context context) {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (modelNode == null) {
            theLogger.log(Level.FINEST, "Null node");
        }
        if (!modelNode.exists()) {
            this.add(new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")));
            return;
        }
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.detailsTablePanel = new DataMinerTablePanel();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this.detailsTablePanel.setTitle("Details");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.detailsTablePanel, -1, 474, Short.MAX_VALUE).addComponent(this.partitionToolbar, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.partitionToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailsTablePanel, -1, 253, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        this.partitionToolbar.setVisible(false);
        this.tableModel = new GLMDetailsTableModel();
        this.detailsTablePanel.setup((TableModel)((Object)this.tableModel), GLMDetailsLrb.get("EDITOR_PANEL_NAME"), 0);
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isClassification()) {
            string = "glmc_global_details_help";
        } else if (this.isRegression()) {
            string = "glmr_global_details_help";
        }
        return new HelpInfo(string);
    }

    public boolean isClassification() {
        ModelNode modelNode = (ModelNode)this.getContext().getNode();
        return modelNode instanceof GLMCModelNode;
    }

    public boolean isRegression() {
        ModelNode modelNode = (ModelNode)this.getContext().getNode();
        return modelNode instanceof GLMRModelNode;
    }

    private String getPartitionId() {
        String string = this.partitionToolbar.getSelectedPartitionID();
        return string;
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        public LoadWorker() {
            super(DetailsPanel.this, DetailsPanel.this.overLayPanel, DetailsPanel.this.detailsTablePanel.getTable());
        }

        @Override
        protected Void doInBackground() throws Exception {
            DetailsPanel.this.partitionToolbar.load(DetailsPanel.this.getEditor());
            DetailsPanel.this.state = new DetailsViewerState(DetailsPanel.this.getContext());
            DetailsPanel.this.state.loadGlobalDetails(DetailsPanel.this.getPartitionId());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            DetailsPanel.this.tableModel.addRows(DetailsPanel.this.state.getGlobalDetails());
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DetailsPanel.this.detailsTablePanel.getTable().displayMessage(GLMDetailsLrb.get("DETAILS_FAILURE"));
            DataMinerEditor.handleEditorException(DetailsPanel.this.getEditor().getContext(), throwable, GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), GLMDetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"));
        }
    }
}

