/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFileSystemHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;

public class ProjectFolderFilter
extends BaseDeferredFilter {
    private static final Logger theLogger = Logger.getLogger(ProjectFolderFilter.class.getName());

    @Override
    protected List<Element> loadChildrenImpl(TNode tNode) throws Exception {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getAncestor(ConnectionFolder.class);
        ProjectFolder projectFolder = (ProjectFolder)tNode.getAncestor(ProjectFolder.class);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            connectionFolder.open();
            List<Workflow> list = Workflow.getWorkflows(connectionFolder, projectFolder.getId());
            for (Workflow workflow : list) {
                WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
                if (workflowNode.getRepositoryData() == null) {
                    workflowNode.setRepositoryData(workflow);
                }
                workflowNode.setId(workflow.getId());
                workflowNode.setParent(this.getOwner());
                workflowNode.markDirty(false);
                arrayList.add((Element)workflowNode);
                projectFolder.add((Element)workflowNode, false);
            }
            projectFolder.markDirty(false);
        }
        catch (IOException | SQLException exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return arrayList;
    }

    public static WorkflowNode getWorkflowNode(String string, boolean bl) {
        WorkflowNode workflowNode = null;
        try {
            URL uRL = URLFactory.newURL((String)DMURLFileSystemHelper.getProtocol(), (String)string);
            workflowNode = bl ? (WorkflowNode)NodeFactory.findOrCreate(WorkflowNode.class, (URL)uRL) : (WorkflowNode)NodeFactory.find((URL)uRL);
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, exception.getMessage());
        }
        return workflowNode;
    }
}

