/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMException;
import ilog.views.sdm.IlvSDMModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.diagram.sdm.undo.ContextNodeUndoStateHelper;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.navigator.AbstractSDMEngineNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class WorkflowNode
extends AbstractSDMEngineNode {
    private static final Logger LOGGER = Logger.getLogger(WorkflowNode.class.getName());
    private BigDecimal _id;
    private TNode _parent = null;
    private Object _reposObj = null;
    private WorkflowModel _wfModel = null;
    private ConnectionFolder _connFolder = null;
    private Timestamp _lastSavedOn = new Timestamp(0L);
    private Connection sessionConnection = null;
    private Lock savingLock = new ReentrantLock();
    private Object repositoryDataReadLock = new Object();
    public Object loadSyncObject = new Object();

    public WorkflowNode() {
        this.disableSaveAs();
    }

    public WorkflowNode(URL uRL) {
        super(uRL);
        this.disableSaveAs();
    }

    private void disableSaveAs() {
        this.getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
        this.getAttributes().unset(ElementAttributes.SAVEABLE_AS);
    }

    public void setWorkflowModel(WorkflowModel workflowModel) {
        this._wfModel = workflowModel;
    }

    public WorkflowModel getWorkflowModel() {
        return this._wfModel;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean setReadOnly(boolean bl) {
        try {
            if (this._wfModel == null) {
                throw new RuntimeException("Cannot setReadOnly because WorkflowModel not initialized (ok if node not being edited)");
            }
            this._wfModel = WorkflowUtils.getWorkflowModel(this);
            this._wfModel.setEditable(!bl);
            if (bl) {
                this.getAttributes().set(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            } else {
                this.getAttributes().unset(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getMessage(), exception);
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return ((Workflow)this.getRepositoryData()).isReadOnly();
    }

    public Timestamp getLastSavedOn() {
        return this._lastSavedOn;
    }

    public void setLastSavedOn(Timestamp timestamp) {
        this._lastSavedOn = timestamp;
    }

    public static WorkflowNode getWorkflowNode(Context context) {
        WorkflowNode workflowNode = null;
        Node node = context.getNode();
        DataMinerNode dataMinerNode = (DataMinerNode)node;
        if (node == null) {
            return null;
        }
        if (node instanceof Connections) {
            return null;
        }
        if (node instanceof ConnectionFolder) {
            return null;
        }
        if (node instanceof ProjectFolder) {
            return null;
        }
        if (node instanceof WorkflowNode) {
            workflowNode = (WorkflowNode)node;
        } else {
            Element element = dataMinerNode.getParent().getAncestor(WorkflowNode.class);
            if (element != null && element instanceof WorkflowNode) {
                workflowNode = (WorkflowNode)element;
            }
        }
        return workflowNode;
    }

    public Icon getIcon() {
        return DataMinerIcons.get(Icons.WORKFLOW_NODE_ICON);
    }

    public Connection getSessionConnection() {
        return this.sessionConnection;
    }

    public void setSessionConnection(Connection connection) {
        this.sessionConnection = connection;
        try {
            this.sessionConnection.setAutoCommit(false);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
    }

    public void closeSessionConnection() {
        new CloseConnection().execute();
    }

    protected void renameImpl(URL uRL, URL uRL2) throws IOException {
    }

    @Override
    protected void saveImpl() throws IOException {
        boolean bl = false;
        final WorkflowEditor workflowEditor = WorkflowEditor.findWorkflowEditor(this._wfModel.getContext());
        if (SwingUtilities.isEventDispatchThread()) {
            if (workflowEditor != null) {
                workflowEditor.displayOverLayPanel(this._wfModel.getContext().getView(), BlockingComponent.Message.SAVING);
            }
            SaveWorker saveWorker = new SaveWorker(bl, workflowEditor);
            saveWorker.execute();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        workflowEditor.displayOverLayPanel(WorkflowNode.this._wfModel.getContext().getView(), BlockingComponent.Message.SAVING);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException);
                throw new IOException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, interruptedException.getMessage(), interruptedException);
                throw new IOException(interruptedException);
            }
            this.save(bl, workflowEditor);
        }
    }

    private void save(boolean bl, WorkflowEditor workflowEditor) throws IOException {
        Workflow workflow = (Workflow)this.getRepositoryData();
        try {
            this._lastSavedOn = workflow.save(this.sessionConnection, this._lastSavedOn, bl);
        }
        catch (SQLException sQLException) {
            String string = "";
            string = sQLException.getErrorCode() == 0 ? DataminerNavigatorLrb.get("CANNOT_SAVE_LOCKED") : sQLException.getMessage();
            LOGGER.log(Level.SEVERE, string, sQLException);
            throw new IOException(sQLException);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            throw new IOException(exception);
        }
        finally {
            if (workflowEditor != null) {
                workflowEditor.hideOverLayPanel();
            }
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.flush((Node)this);
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        Workflow workflow = (Workflow)this.getRepositoryData();
        workflow.unload();
        List list = EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)this));
        for (Object e : list) {
            if (!(e instanceof WorkflowEditor)) continue;
            ((WorkflowEditor)e).stopJobMonitoring();
        }
        this.setWorkflowModel(null);
    }

    public static void delete(Map<WorkflowNode, Connection> map) throws Exception {
        if (map.values().size() == 0) {
            return;
        }
        for (WorkflowNode workflowNode : map.keySet()) {
            Workflow.delete(map);
            workflowNode.closeNode();
            WorkflowNode.removeNodeFromProject(workflowNode);
        }
    }

    private static void removeNodeFromProject(final WorkflowNode workflowNode) {
        if (!EventQueue.isDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (workflowNode.getParent() == null) {
                            return;
                        }
                        ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
                        projectFolder.remove((Element)workflowNode, true);
                        projectFolder.markDirty(false);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else {
            ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
            projectFolder.remove((Element)workflowNode, true);
            projectFolder.markDirty(false);
        }
    }

    public String export(final ConnectionManager connectionManager, final String string) throws Exception {
        class Worker
        extends ProgressRunnable {
            private boolean _validate;
            private boolean _canceled;
            private final Workflow wf;
            private String workflowXML;

            Worker(boolean bl) {
                this.wf = (Workflow)WorkflowNode.this.getRepositoryData();
                this._validate = bl;
            }

            protected Object doWork() throws Exception {
                if (this._validate) {
                    this.wf.validateWorkflow(connectionManager, WorkflowNode.this._lastSavedOn);
                } else {
                    this.workflowXML = this.wf.export(WorkflowNode.this._lastSavedOn, connectionManager, string);
                }
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public String getWorkflowXML() {
                return this.workflowXML;
            }
        }
        Worker worker;
        block2: {
            worker = new Worker(true);
            worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
            worker.setMessage(WorkflowEditorLrb.get("VALIDATE_WORKFLOW_DESCR"));
            worker.setCancelable(false);
            try {
                worker.start(true);
                worker = new Worker(false);
                worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
                worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
                worker.setCancelable(false);
                worker.start(true);
            }
            catch (Exception exception) {
                String string2 = MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_EXPORT_INVALID_CONFIRM"), exception.getLocalizedMessage());
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowEditorLrb.get("SAVE_WORKFLOW"), null, (boolean)true)) break block2;
                worker = new Worker(false);
                worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
                worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
                worker.setCancelable(false);
                worker.start(true);
            }
        }
        return worker.getWorkflowXML();
    }

    @Override
    protected void revertImpl() throws IOException {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine != null && !this.isNew()) {
            this.loadEngine();
        } else {
            super.revertImpl();
        }
    }

    @Override
    protected void loadEngine() {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/default-odmr.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (IlvSDMException ilvSDMException) {
            LOGGER.log(Level.SEVERE, ilvSDMException.getMessage(), ilvSDMException);
        }
    }

    @Override
    protected IlvSDMEngine createEngine() {
        IlvSDMEngine ilvSDMEngine = super.createEngine();
        ilvSDMEngine.setHighlightingSelection(true);
        return ilvSDMEngine;
    }

    @Override
    public IlvSDMModel createModel() {
        if (this._wfModel == null) {
            this._wfModel = new WorkflowModel();
        }
        return this._wfModel;
    }

    @Override
    protected void installModelFilters(IlvSDMEngine ilvSDMEngine) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = new OdmrSDMUndoFilter(ilvSDMEngine.getModel());
        odmrSDMUndoFilter.addStateHelper((StateHelper)new ContextNodeUndoStateHelper());
        ilvSDMEngine.setModel((IlvSDMModel)odmrSDMUndoFilter);
    }

    @Override
    public Object getRepositoryData() {
        return this._reposObj;
    }

    @Override
    public void setRepositoryData(Object object) {
        this._reposObj = object;
    }

    public Object getRepositoryDataReadLock() {
        return this.repositoryDataReadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reloadRepositoryData() throws Exception {
        assert (!SwingUtilities.isEventDispatchThread());
        Object object = this.loadSyncObject;
        synchronized (object) {
            Workflow workflow = (Workflow)this._reposObj;
            Connection connection = this.getSessionConnection();
            WorkflowEditor workflowEditor = WorkflowEditor.findWorkflowEditor(this._wfModel.getContext());
            boolean bl = workflowEditor != null ? workflowEditor.isLockOwner() : false;
            int n = WorkflowEditor.getMaxLockRetry();
            int n2 = WorkflowEditor.getLockRetryInterval();
            Connection connection2 = null;
            try {
                Connection connection3 = connection == null ? (connection2 = ConnectionFolder.getConnection(this._wfModel.getContext())) : connection;
                Timestamp timestamp = null;
                timestamp = bl ? workflow.loadWriteLockWithRetry(connection3, this.getLastSavedOn(), n, n2) : workflow.loadReadLock(connection3, this.getLastSavedOn());
                this.setLastSavedOn(timestamp);
                connection3 = null;
                String string = bl ? DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED_LOCKED") : DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED_UNLOCKED");
                LOGGER.log(Level.INFO, DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED") + " " + string);
                if (connection2 == null) return;
            }
            catch (Exception exception) {
                try {
                    LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    throw exception;
                }
                catch (Throwable throwable) {
                    if (connection2 == null) throw throwable;
                    SQLHelper.close(connection2);
                    throw throwable;
                }
            }
            SQLHelper.close(connection2);
            {
            }
            return;
        }
    }

    public static WorkflowNode findParentWorkflowNode(Context context) {
        URL uRL = context.getNode().getURL();
        URL uRL2 = DMURLFormatHelper.getWorkflowURL(uRL);
        WorkflowNode workflowNode = uRL2 != null ? (WorkflowNode)NodeFactory.find((URL)uRL2) : null;
        return workflowNode;
    }

    @Override
    public void setParent(TNode tNode) {
        this._parent = tNode;
    }

    @Override
    public TNode getParent() {
        return this._parent;
    }

    @Override
    public void setConnectionFolder(ConnectionFolder connectionFolder) {
        this._connFolder = connectionFolder;
    }

    public void setId(BigDecimal bigDecimal) {
        this._id = bigDecimal;
    }

    public BigDecimal getId() {
        return this._id;
    }

    @Override
    public ConnectionFolder getConnectionFolder() {
        if (this._parent != null) {
            Element element = this._parent.getAncestor(ConnectionFolder.class);
            return (ConnectionFolder)element;
        }
        return this._connFolder;
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    @Override
    public void closeChildren() {
        BaseTreeNode.closeChildrenImpl((Node)this);
    }

    private class CloseConnection
    extends ODMrSwingWorker<Void, Void> {
        private CloseConnection() {
            super(null);
        }

        @Override
        protected Void doInBackground() throws Exception {
            if (WorkflowNode.this.sessionConnection == null) {
                return null;
            }
            try {
                Connection connection = WorkflowNode.this.sessionConnection;
                WorkflowNode.this.sessionConnection = null;
                WorkflowNode.this.savingLock.lock();
                connection.commit();
                connection.setAutoCommit(true);
                connection.close();
            }
            finally {
                WorkflowNode.this.savingLock.unlock();
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
        }

        @Override
        protected void onFailure(Throwable throwable) {
            LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private class SaveWorker
    extends ODMrSwingWorker<Void, Void> {
        private boolean force;
        private WorkflowEditor wfe;

        public SaveWorker(boolean bl, WorkflowEditor workflowEditor) {
            super(null);
            this.force = false;
            this.wfe = null;
            this.force = bl;
            this.wfe = workflowEditor;
        }

        @Override
        protected Void doInBackground() throws IOException {
            try {
                WorkflowNode.this.savingLock.lock();
                WorkflowNode.this.save(this.force, this.wfe);
                Void void_ = null;
                return void_;
            }
            finally {
                WorkflowNode.this.savingLock.unlock();
            }
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
        }
    }
}

