/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.util.logging.Logger;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.javatools.util.Version;

public class GLMRModelNode
extends AbstractModelNode {
    private static final Logger LOGGER = Logger.getLogger(GLMCModelNode.class.getName());
    private Boolean _hasRowDiagnosticsTable;

    @Override
    protected Model initModel() {
        return new GeneralizedLinearModelR(this.connManager, this._schema, this.modelName);
    }

    public boolean hasRowDiagnosticsTable() {
        Object object = this.getRepositoryData();
        if (object == null) {
            LOGGER.info("No repository object loaded for node being opened.");
            return false;
        }
        Version version = this.connManager.getDbVersion();
        this._hasRowDiagnosticsTable = false;
        if (DbVersionHelper.isDB122Up((Version)version)) {
            if (object instanceof RGeneralizedLinearModelType) {
                RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)object;
                String string = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSROWDIAGNOSTICS();
                this._hasRowDiagnosticsTable = "GLMS_ROW_DIAG_ENABLE".equals(string);
            } else if (object instanceof ModelNodeType.Models.Model) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
                for (ModelSettingODMType modelSettingODMType : model.getModelSettingsODM().getModelSettingODM()) {
                    if (!"GLMS_ROW_DIAGNOSTICS".equals(modelSettingODMType.getName())) continue;
                    this._hasRowDiagnosticsTable = "GLMS_ROW_DIAG_ENABLE".equals(modelSettingODMType.getValue());
                    break;
                }
            }
        } else {
            String string = null;
            if (object instanceof RGeneralizedLinearModelType) {
                RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)object;
                string = rGeneralizedLinearModelType.getRGeneralizedLinearModelAlgo().getGLMSDIAGNOSTICSTABLENAME();
            } else if (object instanceof ModelNodeType.Models.Model) {
                ModelNodeType.Models.Model model = (ModelNodeType.Models.Model)object;
                for (ModelSettingODMType modelSettingODMType : model.getModelSettingsODM().getModelSettingODM()) {
                    if (!"GLMS_DIAGNOSTICS_TABLE_NAME".equals(modelSettingODMType.getName())) continue;
                    string = modelSettingODMType.getValue();
                    break;
                }
            }
            this._hasRowDiagnosticsTable = !CommonSettingDataObject.isValueNull(string);
        }
        return this._hasRowDiagnosticsTable;
    }
}

